/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.common.utils;

import cn.hutool.core.collection.CollectionUtil;
import com.jxdinfo.idp.icpac.common.entity.FileBytesInfo;
import com.jxdinfo.idp.icpac.utils.ReadWordUtil;
import com.jxdinfo.idp.icpac.utils.entity.word.WordCellInfo;
import com.jxdinfo.idp.icpac.utils.entity.word.WordParagraphInfo;
import com.jxdinfo.idp.icpac.utils.entity.word.WordRowInfo;
import com.jxdinfo.idp.icpac.utils.entity.word.WordStructureInfo;
import com.jxdinfo.idp.icpac.utils.entity.word.WordTableInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sign2Util {
    private static final Logger log = LoggerFactory.getLogger(Sign2Util.class);
    public static final String EXAMINE_POINT_CLASS_SUSPECT = "suspect-class";
    public static final String EXAMINE_POINT_CLASS_MUST_CHANGE = "must-change-class";
    public static final String EXAMINE_POINT_CLASS_PROMPT = "prompt-class";
    public static final String SIGN_CELL = "<sign_cell:%s:%s>";
    public static final String SIGN_PARA = "<sign_para:%s:%d:%d>";
    public static final String SIGN_TABLE = "<sign_table:%s:%d:%d>";
    public static final String SIGN_TEXT = "<sign_text:%s:%d:%d>";
    public static final String SIGN_PARA_REGULAR = "<sign_para:(.*?):(.*?):(.*?)>";
    public static final String SIGN_TABLE_REGULAR = "<sign_table:(.*?):(.*?):(.*?)>";
    public static final String SIGN_TEXT_REGULAR = "<sign_text:(.*?):(.*?):(.*?)>";
    public static final String SIGN_CELL_REGULAR = "<sign_cell:(.*?):(.*?)>";
    public static final String LABEL_REGULAR = "<.*>(.*)</.*>";
    public static final String TEXT_REGULAR = "(?<=>)(?![\\\\w\\\\W]*<sign.*>)(.*)";

    public static String markPara(String id, Integer delFlag, Integer isFirst) {
        return String.format(SIGN_PARA, id, delFlag, isFirst);
    }

    public static String markTable(String id, Integer delFlag, Integer isFirst) {
        return String.format(SIGN_TABLE, id, delFlag, isFirst);
    }

    public static String markCell(String id, String position) {
        return String.format(SIGN_CELL, id, position);
    }

    public static String markText(String id, Integer index, Integer length) {
        return String.format(SIGN_TEXT, id, index, length);
    }

    private static Matcher matchProp(String text, String regular) {
        Pattern pattern = Pattern.compile(regular);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            return matcher;
        }
        return null;
    }

    public static Matcher matchParaProp(String text) {
        return Sign2Util.matchProp(text, SIGN_PARA_REGULAR);
    }

    public static Matcher matchTableProp(String text) {
        return Sign2Util.matchProp(text, SIGN_TABLE_REGULAR);
    }

    public static Matcher matchCellProp(String text) {
        return Sign2Util.matchProp(text, SIGN_CELL_REGULAR);
    }

    public static Matcher matchTextProp(String text) {
        return Sign2Util.matchProp(text, SIGN_TEXT_REGULAR);
    }

    private static List<String> batchMatch(String text, String regular) {
        ArrayList<String> groups = new ArrayList<String>();
        Pattern pattern = Pattern.compile(regular);
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            groups.add(matcher.group());
        }
        return groups;
    }

    public static List<String> batchMatchPara(String text) {
        return Sign2Util.batchMatch(text, SIGN_PARA_REGULAR);
    }

    public static List<String> batchMatchTable(String text) {
        return Sign2Util.batchMatch(text, SIGN_TABLE_REGULAR);
    }

    public static List<String> batchMatchText(String text) {
        return Sign2Util.batchMatch(text, SIGN_TEXT_REGULAR);
    }

    public static List<String> batchMatchCell(String text) {
        return Sign2Util.batchMatch(text, SIGN_CELL_REGULAR);
    }

    public static String matchText(String text) {
        Pattern pattern = Pattern.compile(TEXT_REGULAR);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public static List<Element> findText2Elements(Element root) {
        ArrayList<Element> elements = new ArrayList();
        List nodes = root.childNodes();
        for (Node node : nodes) {
            if (!(node instanceof TextNode)) continue;
            Element element = new Element("span");
            TextNode textNode = (TextNode)node;
            element.text(textNode.getWholeText());
            node.replaceWith((Node)element);
        }
        Elements children = root.children();
        if (CollectionUtil.isEmpty((Collection)children)) {
            String text = Sign2Util.text(root.toString());
            if (StringUtils.isNotEmpty((CharSequence)text)) {
                root.text(Sign2Util.matchText(text));
            }
            elements.add(root);
        }
        elements = Sign2Util.findNodeElements((List<Element>)children);
        return elements;
    }

    private static List<Element> findNodeElements(List<Element> elements) {
        ArrayList<Element> result = new ArrayList<Element>();
        boolean flag = true;
        for (Element element : elements) {
            String eText = element.text();
            if (flag && !eText.contains("sign_")) continue;
            if (StringUtils.isNotEmpty((CharSequence)eText)) {
                if (eText.contains("sign_")) {
                    flag = false;
                    String pureText = Sign2Util.matchText(eText);
                    element.text(pureText);
                }
                result.add(element);
                continue;
            }
            eText = Sign2Util.text(element.toString());
            if ("".equals(eText) || eText == null) continue;
            result.add(element);
        }
        return result;
    }

    public static String getEClass(String type) {
        switch (type) {
            case "1": {
                return "add-class";
            }
            case "2": {
                return "change-class";
            }
            case "3": {
                return "del-class";
            }
        }
        return "equal-class";
    }

    private static String text(String element, String regular) {
        Pattern pattern = Pattern.compile(regular);
        Matcher matcher = pattern.matcher(element);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public static String text(String element) {
        return Sign2Util.text(element, LABEL_REGULAR);
    }

    public static void handleDocxTable(Document document, FileBytesInfo fileInfo) {
        Elements tables = document.getElementsByTag("table");
        WordStructureInfo wordInfo = ReadWordUtil.getWordInfo(fileInfo);
        List<WordTableInfo> tableInfos = wordInfo.getTableInfos();
        if (CollectionUtils.isEmpty(tableInfos) || tableInfos.size() != tables.size()) {
            return;
        }
        for (int i = 0; i < tables.size(); ++i) {
            Element table = (Element)tables.get(i);
            String originStyle = table.attr("style");
            table.attr("style", originStyle + "width: 100%;");
            table.children().remove();
            Element tbody = new Element("tbody");
            table.appendChild((Node)tbody);
            WordTableInfo tableInfo = tableInfos.get(i);
            List<WordRowInfo> rows = tableInfo.getRows();
            for (WordRowInfo row : rows) {
                Element tr = new Element("tr");
                tbody.appendChild((Node)tr);
                List<WordCellInfo> cells = row.getCells();
                for (WordCellInfo cell : cells) {
                    Integer colSpan = cell.getColSpan();
                    Integer rowSpan = cell.getRowSpan();
                    if (rowSpan == null) continue;
                    Element td = new Element("td");
                    tr.appendChild((Node)td);
                    td.attr("colspan", String.valueOf(colSpan)).attr("rowspan", String.valueOf(rowSpan));
                    List<WordParagraphInfo> paragraphs = cell.getPInfos();
                    if (!CollectionUtil.isNotEmpty(paragraphs)) continue;
                    Element p = new Element("p");
                    td.appendChild((Node)p);
                    for (WordParagraphInfo paragraph : paragraphs) {
                        Element span = new Element("span");
                        p.appendChild((Node)span);
                        span.text(paragraph.getText());
                    }
                }
            }
        }
    }
}

