/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.common.ocr.handler.parser;

import com.jxdinfo.idp.icpac.common.entity.PdfOcrResponse;
import com.jxdinfo.idp.icpac.common.entity.po.ExtractElement;
import com.jxdinfo.idp.icpac.common.ocr.handler.parser.DateParser;
import com.jxdinfo.idp.icpac.common.ocr.handler.parser.NumberParser;
import com.jxdinfo.idp.icpac.common.ocr.handler.parser.PageParser;
import com.jxdinfo.idp.icpac.common.ocr.handler.parser.SealParser;
import com.jxdinfo.idp.icpac.common.ocr.handler.parser.SignParser;
import com.jxdinfo.idp.icpac.common.ocr.handler.parser.TableParser;
import com.jxdinfo.idp.icpac.common.ocr.handler.parser.TextParser;
import com.jxdinfo.idp.icpac.common.ocr.handler.parser.WriteDataParse;
import com.jxdinfo.idp.icpac.doccontrast.entity.po.ConfigDocElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OcrResponseParser {
    private static final Map<String, String> dictMap = new HashMap<String, String>();
    private final TextParser textParser;
    private final TableParser tableParser;
    private final SignParser signParser;
    private final SealParser sealParser;
    private final NumberParser numberParser;
    private final WriteDataParse writeDataParse;
    private final DateParser dateParser;
    private final PageParser pageParser;

    public OcrResponseParser(PdfOcrResponse ocrResponse) {
        String docFormat = "5";
        this.textParser = new TextParser(ocrResponse, docFormat, dictMap.get(docFormat + "_text"));
        this.tableParser = new TableParser(ocrResponse, docFormat, dictMap.get(docFormat + "_table"));
        this.sealParser = new SealParser(ocrResponse, docFormat, dictMap.get(docFormat + "_seal"));
        this.signParser = new SignParser(ocrResponse, docFormat, dictMap.get(docFormat + "_sign"));
        this.numberParser = new NumberParser(ocrResponse, docFormat, dictMap.get(docFormat + "_number"));
        this.writeDataParse = new WriteDataParse(ocrResponse, docFormat, dictMap.get(docFormat + "_writedata"));
        this.dateParser = new DateParser(ocrResponse, docFormat, dictMap.get(docFormat + "_date"));
        this.pageParser = new PageParser(ocrResponse);
    }

    public List<ExtractElement> parse(List<ConfigDocElement> configDocElements) {
        ArrayList<ExtractElement> extractElements = new ArrayList<ExtractElement>();
        List<ExtractElement> texts = this.textParser.parse(configDocElements);
        extractElements.addAll(texts);
        List<ExtractElement> tables = this.tableParser.parse();
        extractElements.addAll(tables);
        List<ExtractElement> signs = this.signParser.parse();
        extractElements.addAll(signs);
        List<ExtractElement> seals = this.sealParser.parse();
        extractElements.addAll(seals);
        List<ExtractElement> dates = this.dateParser.parse(configDocElements);
        extractElements.addAll(dates);
        List<ExtractElement> numbers = this.numberParser.parse(configDocElements);
        extractElements.addAll(numbers);
        List<ExtractElement> writedata = this.writeDataParse.parse();
        extractElements.addAll(writedata);
        List<ExtractElement> genericTexts = this.pageParser.parse();
        extractElements.addAll(genericTexts);
        return extractElements;
    }

    static {
        dictMap.put("5_text", "text");
        dictMap.put("5_sign", "sign");
        dictMap.put("5_seal", "seal");
        dictMap.put("5_table", "table");
        dictMap.put("5_number", "number");
        dictMap.put("5_date", "date");
        dictMap.put("5_writedata", "writedata");
        dictMap.put("5_page", "page");
    }
}

