/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.duplicatecheck.api.entity.dto;

import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckChapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DuplicateCheckChapterDto
extends DuplicateCheckChapter {
    private List<String> keyWordList;
    private List<String> noKeyWordList;

    public DuplicateCheckChapterDto(DuplicateCheckChapter chapter) {
        super(chapter);
    }

    @Override
    public void setKeyWord(String keyWord) {
        super.setKeyWord(keyWord);
        this.keyWordList = StringUtils.isNotEmpty((CharSequence)keyWord) ? Arrays.asList(keyWord.split(";")) : new ArrayList<String>();
    }

    @Override
    public void setNoKeyWord(String noKeyWord) {
        super.setNoKeyWord(noKeyWord);
        this.noKeyWordList = StringUtils.isNotEmpty((CharSequence)noKeyWord) ? Arrays.asList(noKeyWord.split(";")) : new ArrayList<String>();
    }

    public static List<DuplicateCheckChapterDto> toDto(List<? extends DuplicateCheckChapter> checkChapters) {
        ArrayList<DuplicateCheckChapterDto> result = new ArrayList<DuplicateCheckChapterDto>();
        for (DuplicateCheckChapter duplicateCheckChapter : checkChapters) {
            result.add(new DuplicateCheckChapterDto(duplicateCheckChapter));
        }
        return result;
    }

    public List<String> getKeyWordList() {
        return this.keyWordList == null ? new ArrayList() : this.keyWordList;
    }

    public List<String> getNoKeyWordList() {
        return this.noKeyWordList == null ? new ArrayList() : this.noKeyWordList;
    }

    public void setKeyWordList(List<String> keyWordList) {
        this.keyWordList = keyWordList;
    }

    public void setNoKeyWordList(List<String> noKeyWordList) {
        this.noKeyWordList = noKeyWordList;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DuplicateCheckChapterDto)) {
            return false;
        }
        DuplicateCheckChapterDto other = (DuplicateCheckChapterDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$keyWordList = this.getKeyWordList();
        List<String> other$keyWordList = other.getKeyWordList();
        if (this$keyWordList == null ? other$keyWordList != null : !((Object)this$keyWordList).equals(other$keyWordList)) {
            return false;
        }
        List<String> this$noKeyWordList = this.getNoKeyWordList();
        List<String> other$noKeyWordList = other.getNoKeyWordList();
        return !(this$noKeyWordList == null ? other$noKeyWordList != null : !((Object)this$noKeyWordList).equals(other$noKeyWordList));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DuplicateCheckChapterDto;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $keyWordList = this.getKeyWordList();
        result = result * 59 + ($keyWordList == null ? 43 : ((Object)$keyWordList).hashCode());
        List<String> $noKeyWordList = this.getNoKeyWordList();
        result = result * 59 + ($noKeyWordList == null ? 43 : ((Object)$noKeyWordList).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "DuplicateCheckChapterDto(keyWordList=" + this.getKeyWordList() + ", noKeyWordList=" + this.getNoKeyWordList() + ")";
    }

    public DuplicateCheckChapterDto(List<String> keyWordList, List<String> noKeyWordList) {
        this.keyWordList = keyWordList;
        this.noKeyWordList = noKeyWordList;
    }

    public DuplicateCheckChapterDto() {
    }
}

