/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.multisimilaritycompare.utils.structure;

import com.jxdinfo.idp.common.entity.util.docparse.word.TableIndex;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.WordElementInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordCellInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordChapterInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordFooter;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordHeader;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordParagraphInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordRowInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordStructureInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordTableInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.utils.structure.WordStructureUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDecimalNumber;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTVMerge;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STMerge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocxStructureUtil
extends WordStructureUtil {
    private static final Logger log = LoggerFactory.getLogger(DocxStructureUtil.class);

    @Override
    public WordStructureInfo getWordInfo(InputStream is, String fileName) {
        WordStructureInfo result = new WordStructureInfo();
        try (XWPFDocument document = new XWPFDocument(is);){
            result.setWordHeaders(this.getHeaders(document));
            result.setWordFooters(this.getFooters(document));
            ArrayList<WordElementInfo> elementInfos = new ArrayList<WordElementInfo>();
            result.setElementInfos(elementInfos);
            ArrayList<WordTableInfo> tInfos = new ArrayList<WordTableInfo>();
            result.setTableInfos(tInfos);
            Iterator iterator = document.getBodyElementsIterator();
            int pIndex = -1;
            int tIndex = -1;
            int index = -1;
            while (iterator.hasNext()) {
                IBodyElement element = (IBodyElement)iterator.next();
                if (element.getElementType().equals((Object)BodyElementType.PARAGRAPH)) {
                    ++index;
                    XWPFParagraph paragraph = element.getBody().getParagraphArray(++pIndex);
                    String text = paragraph.getParagraphText();
                    if (StringUtils.isEmpty((CharSequence)text)) continue;
                    WordParagraphInfo info = new WordParagraphInfo();
                    elementInfos.add(info);
                    info.setPoiIndex(pIndex);
                    info.setText(text);
                    info.setIndex(index);
                    info.setLevel(this.pLevel(document, paragraph));
                    continue;
                }
                if (!element.getElementType().equals((Object)BodyElementType.TABLE)) continue;
                ++tIndex;
                ++index;
                WordTableInfo info = new WordTableInfo();
                tInfos.add(info);
                elementInfos.add(info);
                TableIndex tableIndex = new TableIndex();
                tableIndex.setPoiIndex(Integer.valueOf(tIndex));
                info.getTableIndices().add(tableIndex);
                info.setPoiIndex(tIndex);
                info.setIndex(index);
                this.assembleTable(tInfos, info, element.getBody().getTableArray(tIndex));
                info.setLevel(0);
            }
            List<WordChapterInfo> wordChapterInfos = this.assembleChapter(elementInfos);
            result.setChapterInfos(wordChapterInfos);
        }
        catch (IOException e) {
            log.error("docx\u89e3\u6790\u51fa\u9519:", (Throwable)e);
            log.error("docx\u6587\u6863+\u3010" + fileName + "\u3011\u52a0\u8f7d\u5f02\u5e38\uff01");
        }
        return result;
    }

    private List<WordFooter> getFooters(XWPFDocument document) {
        ArrayList<WordFooter> result = new ArrayList<WordFooter>();
        List footers = document.getFooterList();
        for (int i = 0; i < footers.size(); ++i) {
            WordFooter wordFooter = new WordFooter();
            wordFooter.setIndex(i);
            wordFooter.setText(((XWPFFooter)footers.get(i)).getText());
            result.add(wordFooter);
        }
        return result;
    }

    private List<WordHeader> getHeaders(XWPFDocument document) {
        ArrayList<WordHeader> result = new ArrayList<WordHeader>();
        List headers = document.getHeaderList();
        for (int i = 0; i < headers.size(); ++i) {
            WordHeader wordHeader = new WordHeader();
            wordHeader.setIndex(i);
            wordHeader.setText(((XWPFHeader)headers.get(i)).getText());
            result.add(wordHeader);
        }
        return result;
    }

    private int pLevel(XWPFDocument doc, XWPFParagraph para) {
        try {
            if (para.getCTP().getPPr().getOutlineLvl() != null) {
                return para.getCTP().getPPr().getOutlineLvl().getVal().intValue() + 1;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (doc.getStyles().getStyle(para.getStyle()).getCTStyle().getPPr().getOutlineLvl() != null) {
                return doc.getStyles().getStyle(para.getStyle()).getCTStyle().getPPr().getOutlineLvl().getVal().intValue() + 1;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (doc.getStyles().getStyle(doc.getStyles().getStyle(para.getStyle()).getCTStyle().getBasedOn().getVal()).getCTStyle().getPPr().getOutlineLvl() != null) {
                String styleName = doc.getStyles().getStyle(para.getStyle()).getCTStyle().getBasedOn().getVal();
                return doc.getStyles().getStyle(styleName).getCTStyle().getPPr().getOutlineLvl().getVal().intValue() + 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    private List<WordChapterInfo> assembleChapter(List<WordElementInfo> elementInfos) {
        WordChapterInfo before = null;
        ArrayList<WordChapterInfo> chapterList = new ArrayList<WordChapterInfo>();
        for (WordElementInfo elementInfo : elementInfos) {
            WordChapterInfo chapterInfo;
            int level = elementInfo.getLevel();
            if (level == 0 || level == 10) {
                if (before == null) {
                    chapterInfo = new WordChapterInfo();
                    chapterInfo.setTitleName("virtual_chapter");
                    chapterInfo.addParagraph(elementInfo);
                    chapterInfo.setLevel(null);
                    chapterList.add(chapterInfo);
                    continue;
                }
                before.addParagraph(elementInfo);
                elementInfo.setBelongChapter(before.getTitleName());
                continue;
            }
            chapterInfo = new WordChapterInfo();
            WordParagraphInfo paragraphInfo = (WordParagraphInfo)elementInfo;
            chapterInfo.setTitleName(paragraphInfo.getText());
            chapterInfo.setLevel(paragraphInfo.getLevel());
            WordChapterInfo parent = this.getParent(before, level);
            if (parent == null) {
                chapterList.add(chapterInfo);
            } else {
                parent.addChildChapter(chapterInfo);
                chapterInfo.setParent(parent);
            }
            before = chapterInfo;
        }
        return chapterList;
    }

    private WordChapterInfo getParent(WordChapterInfo before, int level) {
        if (before == null) {
            return null;
        }
        Integer beforeLevel = before.getLevel();
        WordChapterInfo parent = null;
        int minDistance = Integer.MAX_VALUE;
        if (beforeLevel < level) {
            return before;
        }
        if (beforeLevel == level) {
            return before.getParent();
        }
        for (WordChapterInfo cursor = before.getParent(); cursor != null; cursor = cursor.getParent()) {
            int distance = level - cursor.getLevel();
            if (distance <= 0 || minDistance <= distance) continue;
            parent = cursor;
            minDistance = distance;
        }
        return parent;
    }

    private void assembleTable(List<WordTableInfo> tInfos, WordTableInfo parentTInfo, XWPFTable table) {
        ArrayList<WordRowInfo> rowInfos = new ArrayList<WordRowInfo>();
        parentTInfo.setRows(rowInfos);
        List rows = table.getRows();
        for (int j = 0; j < rows.size(); ++j) {
            WordRowInfo rowInfo = new WordRowInfo();
            rowInfo.setIndex(j);
            rowInfos.add(rowInfo);
            ArrayList<WordCellInfo> cellInfos = new ArrayList<WordCellInfo>();
            rowInfo.setCells(cellInfos);
            XWPFTableRow row = table.getRow(j);
            List tableCells = row.getTableCells();
            for (int k = 0; k < tableCells.size(); ++k) {
                WordCellInfo cellInfo = new WordCellInfo();
                cellInfo.setIndex(k);
                cellInfos.add(cellInfo);
                XWPFTableCell cell = row.getCell(k);
                cellInfo.setText(cell.getText().trim());
                this.handleCell(cellInfo, cell, k, j, table);
                ArrayList<WordElementInfo> elementInfos = new ArrayList<WordElementInfo>();
                cellInfo.setElementInfos(elementInfos);
                int pIndex = 0;
                int tIndex = 0;
                List bodyElements = cell.getBodyElements();
                for (IBodyElement bodyElement : bodyElements) {
                    if (bodyElement.getElementType().equals((Object)BodyElementType.PARAGRAPH)) {
                        XWPFParagraph paragraph = bodyElement.getBody().getParagraphArray(pIndex);
                        WordParagraphInfo pInfo = new WordParagraphInfo();
                        elementInfos.add(pInfo);
                        pInfo.setPoiIndex(pIndex);
                        pInfo.setType("para");
                        pInfo.setText(paragraph.getText().trim());
                        ++pIndex;
                        continue;
                    }
                    if (!bodyElement.getElementType().equals((Object)BodyElementType.TABLE)) continue;
                    XWPFTable childTable = bodyElement.getBody().getTableArray(tIndex);
                    WordTableInfo info = new WordTableInfo();
                    tInfos.add(info);
                    elementInfos.add(info);
                    LinkedList<TableIndex> parentTableIndices = parentTInfo.getTableIndices();
                    TableIndex parent = parentTableIndices.getLast();
                    parent.setRowIndex(Integer.valueOf(j));
                    parent.setCellIndex(Integer.valueOf(k));
                    TableIndex tableIndex = new TableIndex(Integer.valueOf(tIndex));
                    parentTableIndices.forEach(parentTableIndex -> info.getTableIndices().add((TableIndex)parentTableIndex));
                    info.getTableIndices().add(tableIndex);
                    info.setPoiIndex(tIndex);
                    info.setType("table");
                    this.assembleChildTable(tInfos, info, childTable);
                    ++tIndex;
                }
            }
        }
    }

    private void assembleChildTable(List<WordTableInfo> tInfos, WordTableInfo parentTInfo, XWPFTable table) {
        ArrayList<WordRowInfo> rowInfos = new ArrayList<WordRowInfo>();
        parentTInfo.setRows(rowInfos);
        List rows = table.getRows();
        for (int j = 0; j < rows.size(); ++j) {
            WordRowInfo rowInfo = new WordRowInfo();
            rowInfo.setIndex(j);
            rowInfos.add(rowInfo);
            ArrayList<WordCellInfo> cellInfos = new ArrayList<WordCellInfo>();
            rowInfo.setCells(cellInfos);
            XWPFTableRow row = table.getRow(j);
            List tableCells = row.getTableCells();
            for (int k = 0; k < tableCells.size(); ++k) {
                WordCellInfo cellInfo = new WordCellInfo();
                cellInfo.setIndex(k);
                cellInfos.add(cellInfo);
                XWPFTableCell cell = row.getCell(k);
                cellInfo.setText(cell.getText().trim());
                this.handleCell(cellInfo, cell, k, j, table);
                ArrayList<WordElementInfo> elementInfos = new ArrayList<WordElementInfo>();
                cellInfo.setElementInfos(elementInfos);
                int pIndex = 0;
                int tIndex = 0;
                List bodyElements = cell.getBodyElements();
                for (IBodyElement bodyElement : bodyElements) {
                    if (bodyElement.getElementType().equals((Object)BodyElementType.PARAGRAPH)) {
                        XWPFParagraph paragraph = bodyElement.getBody().getParagraphArray(pIndex);
                        WordParagraphInfo pInfo = new WordParagraphInfo();
                        elementInfos.add(pInfo);
                        pInfo.setPoiIndex(pIndex);
                        pInfo.setType("para");
                        pInfo.setText(paragraph.getText().trim());
                        ++pIndex;
                        continue;
                    }
                    if (!bodyElement.getElementType().equals((Object)BodyElementType.TABLE)) continue;
                    XWPFTable childTable = bodyElement.getBody().getTableArray(tIndex);
                    WordTableInfo tInfo = new WordTableInfo();
                    tInfos.add(tInfo);
                    elementInfos.add(tInfo);
                    tInfo.setPoiIndex(tIndex);
                    LinkedList<TableIndex> parentTableIndices = parentTInfo.getTableIndices();
                    TableIndex parent = parentTableIndices.getLast();
                    parent.setRowIndex(Integer.valueOf(j));
                    parent.setCellIndex(Integer.valueOf(k));
                    parentTableIndices.forEach(parentTableIndex -> tInfo.getTableIndices().add((TableIndex)parentTableIndex));
                    tInfo.getTableIndices().add(new TableIndex(Integer.valueOf(tIndex)));
                    tInfo.setType("table");
                    this.assembleChildTable(tInfos, tInfo, childTable);
                    ++tIndex;
                }
            }
        }
    }

    private void handleCell(WordCellInfo cellInfo, XWPFTableCell cell, int x, int y, XWPFTable table) {
        CTDecimalNumber colspan;
        STMerge.Enum vMergeVal;
        CTTc ctTc = cell.getCTTc();
        List rows = table.getRows();
        CTTcPr tcPr = ctTc.getTcPr();
        CTVMerge rowspan = tcPr.getVMerge();
        int rowspanNum = 1;
        if (rowspan != null && (vMergeVal = rowspan.getVal()) != null && STMerge.RESTART.toString().equals(vMergeVal.toString())) {
            for (int i = y + 1; i < rows.size(); ++i) {
                if (((XWPFTableRow)rows.get(i)).getTableCells().size() > x) {
                    STMerge.Enum nextVMergeVal;
                    CTVMerge nextVMerge = ((XWPFTableRow)rows.get(i)).getCell(x).getCTTc().getTcPr().getVMerge();
                    if (nextVMerge == null || (nextVMergeVal = nextVMerge.getVal()) != null && STMerge.RESTART.toString().equals(nextVMergeVal.toString())) break;
                    ++rowspanNum;
                    continue;
                }
                ++rowspanNum;
            }
        }
        if ((colspan = tcPr.getGridSpan()) != null) {
            cellInfo.setColSpan(colspan.getVal().intValue());
        } else {
            cellInfo.setColSpan(1);
        }
        if (rowspan != null) {
            if (rowspan.getVal() != null) {
                cellInfo.setRowSpan(rowspanNum);
            }
            if (rowspan.getVal() == null || rowspan.getVal() != STMerge.RESTART) {
                cellInfo.setRowSpan(null);
            }
        } else {
            cellInfo.setRowSpan(1);
        }
    }

    public static void main(String[] args) throws FileNotFoundException {
        FileInputStream inputStream = new FileInputStream("1-\u4fe1\u606f\u5316\u9879\u76ee\u53ef\u884c\u6027\u7814\u7a76\u62a5\u544a\uff08\u6d4b\u8bd5\u516c\u53f8-\u6d4b\u8bd5\u5de5\u5177\u4f18\u5316\u63d0\u5347-\u5f00\u53d1\u5b9e\u65bd\u9879\u76ee\uff09.docx");
        DocxStructureUtil util = new DocxStructureUtil();
        WordStructureInfo wordInfoNew = util.getWordInfo(inputStream, "1-\u4fe1\u606f\u5316\u9879\u76ee\u53ef\u884c\u6027\u7814\u7a76\u62a5\u544a\uff08\u6d4b\u8bd5\u516c\u53f8-\u6d4b\u8bd5\u5de5\u5177\u4f18\u5316\u63d0\u5347-\u5f00\u53d1\u5b9e\u65bd\u9879\u76ee\uff09.docx");
        System.out.println("ddd");
    }
}

