/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.multisimilaritycompare.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.entity.dto.DuplicateCheckSimilarSentenceDto;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.entity.po.DuplicateCheckSimilarSentence;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.entity.query.DuplicateCheckSimilarSentenceQuery;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.mapper.DuplicateCheckSimilaritySentenceMapper;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.service.DuplicateCheckSimilarSentenceService;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DuplicateCheckSimilarSentenceServiceImpl
extends ServiceImpl<DuplicateCheckSimilaritySentenceMapper, DuplicateCheckSimilarSentence>
implements DuplicateCheckSimilarSentenceService {
    private static final Logger log = LoggerFactory.getLogger(DuplicateCheckSimilarSentenceServiceImpl.class);
    @Resource
    private DuplicateCheckSimilaritySentenceMapper mapper;
    @Resource
    private SqlSessionFactory sqlSessionFactory;

    @Override
    public void saveBatch(List<DuplicateCheckSimilarSentenceDto> similarSentenceDtoList) {
        if (CollectionUtils.isEmpty(similarSentenceDtoList)) {
            log.info("\u63d2\u5165\u7684\u76f8\u4f3c\u8bed\u53e5\u6761\u6570\u4e3a0\u6761");
            return;
        }
        List<DuplicateCheckSimilarSentence> similarSentenceList = DuplicateCheckSimilarSentence.toEntity(similarSentenceDtoList);
        this.insertBatch(similarSentenceList);
        log.info("\u76f8\u4f3c\u8bed\u53e5\u63d2\u5165\u6210\u529f\uff0c\u63d2\u5165\u7684\u8bed\u53e5\u6761\u6570\u4e3a\uff1a{}", (Object)similarSentenceList.size());
    }

    private void insertBatch(List<DuplicateCheckSimilarSentence> similarSentenceList) {
        long startTime = System.currentTimeMillis();
        String prefix = "SELECT 1";
        SqlSession sqlSession = null;
        Connection connection = null;
        Statement statement = null;
        int size = similarSentenceList.size();
        int commitSize = 3000;
        int commitCount = size / commitSize + 1;
        try {
            sqlSession = this.sqlSessionFactory.openSession();
            connection = sqlSession.getConnection();
            connection.setAutoCommit(false);
            statement = connection.prepareStatement(prefix);
            int index = 0;
            for (int i = 0; i < commitCount; ++i) {
                StringBuilder sql = new StringBuilder("INSERT INTO idp_icpac_duplicate_check_similar_sentence (id, result_id, sentence,location,sentence_index,similarity,sentence_id,belong_chapter) values");
                int baseSqlLen = sql.length();
                int newCommitSize = commitSize * (i + 1);
                while (index < size && index < newCommitSize) {
                    DuplicateCheckSimilarSentence similarSentence = similarSentenceList.get(index);
                    String sentence = similarSentence.getSentence();
                    if (sentence.contains("'")) {
                        sentence = sentence.replaceAll("'", "\\\\'");
                    }
                    sql.append("('").append(similarSentence.getId()).append("','").append(similarSentence.getResultId()).append("','").append(sentence).append("','").append(similarSentence.getLocation()).append("','").append(similarSentence.getSentenceIndex()).append("','").append(similarSentence.getSimilarity()).append("','").append(similarSentence.getSentenceId()).append("','").append(similarSentence.getBelongChapter()).append("'),");
                    ++index;
                }
                if (sql.length() <= baseSqlLen) continue;
                statement.addBatch(sql.substring(0, sql.lastIndexOf(",")));
                statement.executeBatch();
                connection.commit();
                statement.clearBatch();
            }
        }
        catch (SQLException e) {
            log.error("\u63d2\u5165\u51fa\u9519,", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException ignored) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ignored) {}
            }
            if (sqlSession != null) {
                sqlSession.close();
            }
            log.info("\u63d2\u5165\u7ed3\u675f,\u8017\u8d39\u65f6\u95f4\uff1a{}", (Object)((System.currentTimeMillis() - startTime) / 1000L));
        }
    }

    @Override
    public void deleteByResultIds(List<String> resultIds) {
        if (CollectionUtils.isEmpty(resultIds)) {
            return;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(DuplicateCheckSimilarSentence::getResultId, resultIds);
        this.remove((Wrapper)wrapper);
    }

    @Override
    public List<DuplicateCheckSimilarSentenceDto> getSimilaritySentenceNoPage(DuplicateCheckSimilarSentenceQuery query) {
        return this.mapper.getSimilaritySentence(query, null);
    }

    public ArrayList getMaxSimilaritySentence(DuplicateCheckSimilarSentenceQuery similarSentenceQuery) {
        if (CollectionUtils.isEmpty(similarSentenceQuery.getSentenceIds())) {
            return new ArrayList();
        }
        List<DuplicateCheckSimilarSentenceDto> sentenceList = this.mapper.getSimilaritySentence(similarSentenceQuery, null);
        HashMap<String, DuplicateCheckSimilarSentenceDto> sentenceIdObjMap = new HashMap<String, DuplicateCheckSimilarSentenceDto>();
        for (DuplicateCheckSimilarSentenceDto sentenceDto : sentenceList) {
            String sentenceId = sentenceDto.getSentenceId();
            DuplicateCheckSimilarSentenceDto maybeMaxObj = (DuplicateCheckSimilarSentenceDto)sentenceIdObjMap.get(sentenceId);
            if (maybeMaxObj != null && Double.compare(maybeMaxObj.getSimilarity(), sentenceDto.getSimilarity()) >= 0) continue;
            sentenceIdObjMap.put(sentenceId, sentenceDto);
        }
        return new ArrayList(sentenceIdObjMap.values());
    }

    @Override
    public Page<? extends DuplicateCheckSimilarSentence> getSimilaritySentence(DuplicateCheckSimilarSentenceQuery query) {
        Page<DuplicateCheckSimilarSentenceDto> page = query.getPage(DuplicateCheckSimilarSentenceDto.class);
        List<DuplicateCheckSimilarSentenceDto> list = this.mapper.getSimilaritySentence(query, page);
        page.setRecords(list);
        return page;
    }
}

