/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.multisimilaritycompare.system.service.handler.sentencehandler;

import com.jxdinfo.idp.icpac.multisimilaritycompare.system.core.handler.SentenceHandler;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.service.handler.sentencehandler.PdfSentenceHandler;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.service.handler.sentencehandler.SentenceHandlerSupport;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.service.handler.sentencehandler.TextSentenceHandler;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.service.handler.sentencehandler.WordSentenceHandler;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.web.multipart.MultipartFile;

public class SentenceHandlerManagement {
    private static final List<SentenceHandler> SENTENCE_HANDLER_LIST = new CopyOnWriteArrayList<SentenceHandler>();

    public static SentenceHandler get(MultipartFile file) {
        for (SentenceHandler sentenceHandler : SENTENCE_HANDLER_LIST) {
            SentenceHandlerSupport support = (SentenceHandlerSupport)((Object)sentenceHandler);
            if (!support.support(file)) continue;
            return sentenceHandler;
        }
        return null;
    }

    static {
        SENTENCE_HANDLER_LIST.add(new WordSentenceHandler());
        SENTENCE_HANDLER_LIST.add(new PdfSentenceHandler());
        SENTENCE_HANDLER_LIST.add(new TextSentenceHandler());
    }
}

