/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.multisimilaritycompare.system.core.rmi;

import com.jxdinfo.idp.icpac.multisimilaritycompare.system.core.entity.DuplicateCheckInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.core.rmi.DocCheckRmi;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.core.rmi.entity.DuplicateCheckIgnoreSentence;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.core.rmi.entity.DuplicateCheckRimDoc;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.core.rmi.feign.MutilCompareFeignHttp;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.core.rmi.resp.DuplicateCheckResponse;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.utils.DuplicateCheckProgress;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultDuplicateCheckRmi
implements DocCheckRmi {
    private static final Logger log = LoggerFactory.getLogger(DefaultDuplicateCheckRmi.class);
    @Autowired
    protected MutilCompareFeignHttp iMutilCompareFeignHttp;

    @Override
    public DuplicateCheckResponse checkRepeat(DuplicateCheckInfo info) throws IOException {
        log.info("\u8c03\u7528\u5ba1\u67e5\u670d\u52a1\u5f00\u542f\u3002\u3002\u3002\u3002\u3002\u3002");
        String checkId = info.getCheckId();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sentence", info.getCandidateSentenceList());
        map.put("project_id", info.getAttachment("projectId", String.class));
        map.put("document_id", info.getAttachment("docId", String.class));
        map.put("sim_thresh", info.getAttachment("simThresh", Double.class));
        map.put("update_lib", "1");
        DuplicateCheckResponse response = (DuplicateCheckResponse)this.iMutilCompareFeignHttp.compare(map).getData();
        log.info("\u8c03\u7528\u5ba1\u67e5\u670d\u52a1\u7ed3\u675f\u3002");
        DuplicateCheckProgress.setProgress(checkId, 20);
        return response;
    }

    @Override
    public void deleteRemoteDoc(DuplicateCheckInfo info) {
        List docIds = info.getAttachment("uploadIds", List.class);
        DuplicateCheckRimDoc rimDoc = new DuplicateCheckRimDoc();
        if (CollectionUtils.isNotEmpty((Collection)docIds)) {
            rimDoc.setDocument_id(docIds);
        } else {
            rimDoc.setDocument_id(new ArrayList<String>());
        }
        String projectId = info.getAttachment("projectId", String.class);
        if (StringUtils.isEmpty((CharSequence)projectId)) {
            return;
        }
        rimDoc.setProject_id(projectId);
        this.iMutilCompareFeignHttp.deleteRemoteDoc(Arrays.asList(rimDoc));
    }

    @Override
    public void addIgnoreSentence(DuplicateCheckInfo info) {
        String projectId = info.getAttachment("projectId", String.class);
        if (StringUtils.isEmpty((CharSequence)projectId)) {
            return;
        }
        String text = info.getAttachment("text", String.class);
        if (StringUtils.isEmpty((CharSequence)text)) {
            return;
        }
        this.iMutilCompareFeignHttp.addIgnoreSentence(new DuplicateCheckIgnoreSentence(projectId, text));
    }
}

