/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.multisimilaritycompare.system.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.entity.dto.DuplicateCheckDocDto;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.entity.po.DuplicateCheckDoc;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.entity.query.DuplicateCheckDocQuery;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.service.DuplicateCheckDocService;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.service.DuplicateCheckExecutorService;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.utils.DuplicateCheckProgress;
import com.jxdinfo.idp.icpac.slice.entity.PreparationFileInfo;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/icpac/multiSimilarity/docInfo"})
public class DuplicateCheckDocController {
    private static final Logger log = LoggerFactory.getLogger(DuplicateCheckDocController.class);
    @Resource
    private DuplicateCheckDocService service;
    @Resource
    private DuplicateCheckExecutorService executorService;

    @PostMapping(value={"/list"})
    public ApiResponse<Page<? extends DuplicateCheckDoc>> list(@RequestBody DuplicateCheckDocQuery query) {
        return ApiResponse.success(this.service.list(query));
    }

    @PostMapping(value={"/insert"})
    public ApiResponse<DuplicateCheckDoc> insert(DuplicateCheckDocDto docInfoDto) throws Exception {
        docInfoDto.setSource("local");
        return ApiResponse.success((Object)this.service.insert(docInfoDto));
    }

    @GetMapping(value={"/detail/{id}"})
    public ApiResponse<? extends DuplicateCheckDoc> detail(@PathVariable String id) {
        return ApiResponse.success((Object)this.service.detail(id));
    }

    @PostMapping(value={"/delete"})
    public ApiResponse<Void> delete(@RequestBody List<String> ids) {
        this.service.delete(ids);
        return ApiResponse.success();
    }

    @PostMapping(value={"/checkDuplicate"})
    public ApiResponse<Void> checkDuplicate(@RequestBody DuplicateCheckDocQuery query) throws Exception {
        this.executorService.asyncCheckDuplicate(query);
        return ApiResponse.success();
    }

    @PostMapping(value={"/sliceUploadFile"})
    public ApiResponse<DuplicateCheckDoc> sliceUploadFile(@RequestBody PreparationFileInfo preparationFileInfo) throws Exception {
        DuplicateCheckDoc doc = this.service.sliceUploadFile(preparationFileInfo);
        return ApiResponse.success((Object)doc);
    }

    @GetMapping(value={"/progress/{docId}"})
    public ApiResponse<Integer> getProcess(@PathVariable(value="docId") String docId) {
        Integer progress = DuplicateCheckProgress.getProgress(docId);
        if (progress >= 0) {
            return ApiResponse.success((Object)progress);
        }
        return ApiResponse.fail((String)"\u5ba1\u67e5\u5931\u8d25");
    }
}

