/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.docexamine.executor.imp.wordelementextractor;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.icpac.common.entity.TabHead;
import com.jxdinfo.idp.icpac.common.entity.TableInfo;
import com.jxdinfo.idp.icpac.common.entity.po.ExtractElement;
import com.jxdinfo.idp.icpac.doccontrast.entity.po.ConfigDocElement;
import com.jxdinfo.idp.icpac.doccontrast.util.StringUtils;
import com.jxdinfo.idp.icpac.docexamine.entity.docconfig.ExtractRule;
import com.jxdinfo.idp.icpac.docexamine.entity.docconfig.extractsetting.ExtractSettings;
import com.jxdinfo.idp.icpac.docexamine.entity.docconfig.extractsetting.TableExtractSettings;
import com.jxdinfo.idp.icpac.docexamine.entity.dto.ExtractContent;
import com.jxdinfo.idp.icpac.docexamine.entity.location.WordLocation;
import com.jxdinfo.idp.icpac.docexamine.executor.imp.wordelementextractor.AbstractElementWordExtractor;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordCellInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordRowInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordStructureInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordTableInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class TableElementWordExtractor
extends AbstractElementWordExtractor {
    public TableElementWordExtractor() {
        super("table");
    }

    @Override
    public ExtractElement extractElement(String subtaskId, ConfigDocElement docElement) {
        ExtractRule extractRule = this.getExtractRule(docElement.getExtractRule());
        TableExtractSettings settings = this.getExtractSettings(extractRule.getExtractSettings());
        ExtractElement extractElement = new ExtractElement();
        List<WordTableInfo> tables = this.getTables(subtaskId);
        WordTableInfo targetTable = this.getTargetTable(settings, tables);
        if (targetTable == null) {
            throw new BusinessException("\u672a\u627e\u5230\u76ee\u6807\u8868\uff01");
        }
        TableInfo tableInfo = new TableInfo();
        ExtractContent content = new ExtractContent();
        WordLocation location = new WordLocation();
        WordLocation.TableLocation tLocation = location.newTLocation();
        tLocation.setType(0);
        tLocation.setIndex(targetTable.getIndex());
        tLocation.setPIndex(targetTable.getPIndex());
        content.setWordLocation(location);
        content.setValue(JSON.toJSONString((Object)targetTable));
        content.setTableInfo(targetTable);
        this.addCache(subtaskId, docElement.getElementName(), content);
        extractElement.setElementLocation(JSON.toJSONString((Object)location));
        String tableText = JSON.toJSONString((Object)tableInfo);
        extractElement.setElementText(tableText);
        extractElement.setOriginText(tableText);
        return extractElement;
    }

    private WordTableInfo getTargetTable(TableExtractSettings settings, List<WordTableInfo> tableInfos) {
        WordTableInfo result = null;
        String tabTitle = settings.getTabTitle();
        List<TabHead> tabHeads = settings.getTabHeads();
        double maxSimilarity = 0.0;
        for (WordTableInfo table : tableInfos) {
            double currentSimilarity = this.isTitle(tabTitle, table) * this.isTable(table.getRows(), tabHeads);
            if (!(maxSimilarity < currentSimilarity)) continue;
            maxSimilarity = currentSimilarity;
            result = table;
        }
        return result;
    }

    private TableInfo getTableInfo(List<TabHead> heads, WordTableInfo tableInfo) {
        for (int i = 0; i < heads.size(); ++i) {
            TabHead tabHead = heads.get(i);
            tabHead.setHeadKey(String.valueOf(i));
        }
        List<WordRowInfo> rowInfos = tableInfo.getRows();
        TableInfo result = new TableInfo();
        int headIndex = 0;
        int rowIndex = -1;
        block1: for (WordRowInfo rowInfo : rowInfos) {
            for (WordCellInfo cell : rowInfo.getCells()) {
                if (cell.getText().contains(heads.get(headIndex).getHeadName())) {
                    if (++headIndex != heads.size()) continue;
                    rowIndex = rowInfo.getIndex();
                    break block1;
                }
                headIndex = 0;
                continue block1;
            }
        }
        result.setTabHeads(heads);
        ArrayList<Map<String, String>> dataList = new ArrayList<Map<String, String>>();
        result.setTabData(dataList);
        for (int i = rowIndex + 1; i < rowInfos.size(); ++i) {
            HashMap<String, String> record = new HashMap<String, String>();
            WordRowInfo row = rowInfos.get(i);
            headIndex = 0;
            for (WordCellInfo cell : row.getCells()) {
                if (headIndex == heads.size()) break;
                TabHead tabHead = heads.get(headIndex);
                record.put(tabHead.getHeadKey(), cell.getText());
                ++headIndex;
            }
            dataList.add(record);
        }
        return result;
    }

    private double isTitle(String tabTitle, WordTableInfo tableInfo) {
        String title = tableInfo.getTableTitle();
        if (StringUtils.isEmpty(title)) {
            return 1.0;
        }
        if ((title = title.replaceAll("\u0007", "").replaceAll("\r", "")).contains(tabTitle)) {
            return 1.0;
        }
        if (StringUtils.isEmpty(tabTitle)) {
            return 0.0;
        }
        return -1.0;
    }

    private double isTable(List<WordRowInfo> rowInfos, List<TabHead> heads) {
        int headIndex = 0;
        block0: for (WordRowInfo rowInfo : rowInfos) {
            for (WordCellInfo cell : rowInfo.getCells()) {
                if (cell.getText().contains(heads.get(headIndex).getHeadName())) {
                    if (++headIndex != heads.size()) continue;
                    return 1.0;
                }
                headIndex = 0;
                continue block0;
            }
        }
        return -1.0;
    }

    private TableExtractSettings getExtractSettings(ExtractSettings settings) {
        TableExtractSettings extractSettings = new TableExtractSettings();
        BeanUtils.copyProperties((Object)settings, (Object)extractSettings);
        return extractSettings;
    }

    private List<WordTableInfo> getTables(String subtaskId) {
        List<WordTableInfo> result = new ArrayList<WordTableInfo>();
        WordStructureInfo wordStructureInfo = (WordStructureInfo)contentMap.get(subtaskId);
        if (wordStructureInfo != null) {
            result = wordStructureInfo.getTableInfos();
        }
        return result;
    }
}

