/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.docexamine.executor.imp.excelelementextractor;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.idp.icpac.common.entity.FileBytesInfo;
import com.jxdinfo.idp.icpac.common.entity.po.ExtractElement;
import com.jxdinfo.idp.icpac.common.handler.ValueHandler;
import com.jxdinfo.idp.icpac.common.handler.ValueHandlerUtils;
import com.jxdinfo.idp.icpac.common.util.entity.excel.CellData;
import com.jxdinfo.idp.icpac.doccontrast.entity.po.ConfigDocElement;
import com.jxdinfo.idp.icpac.docexamine.entity.docconfig.AfterHandle;
import com.jxdinfo.idp.icpac.docexamine.entity.docconfig.ExtractRule;
import com.jxdinfo.idp.icpac.docexamine.entity.docconfig.extractsetting.TextExtractSettings;
import com.jxdinfo.idp.icpac.docexamine.executor.imp.AbstractExtractor;
import com.jxdinfo.idp.icpac.docexamine.executor.imp.excelelementextractor.ElementExcelExtractorFactory;
import com.jxdinfo.idp.icpac.multisimilaritycompare.utils.ReadExcelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DateElementExcelExtractor
extends ElementExcelExtractorFactory {
    private static final Logger log = LoggerFactory.getLogger(DateElementExcelExtractor.class);

    public DateElementExcelExtractor() {
        super("date");
    }

    @Override
    public ExtractElement extractElement(String subtaskId, ConfigDocElement docElement) {
        ExtractElement extractElement = new ExtractElement();
        FileBytesInfo docFileInfo = AbstractExtractor.docFileInfoMap.get(subtaskId);
        ExtractRule extractRule = (ExtractRule)JSON.parseObject((String)docElement.getExtractRule(), ExtractRule.class);
        TextExtractSettings extractSettings = this.getExtractSettings(extractRule.getExtractSettings(), TextExtractSettings.class);
        AfterHandle afterHandle = extractRule.getAfterHandle();
        CellData cellData = ReadExcelUtil.getCellData(extractSettings, subtaskId);
        if (cellData != null) {
            int sheetIndex = ReadExcelUtil.sheetIndex(docFileInfo, cellData.getSheetName());
            String excelDataLocation = cellData.getColumnIndex() + 1 + "," + (cellData.getRowIndex() + 1);
            extractElement.setElementLocation(this.getLocation(sheetIndex, extractSettings.getExtractRange(), excelDataLocation));
            ValueHandler handler = ValueHandlerUtils.get(afterHandle.getDataProcess());
            extractElement.setElementText(handler.value(cellData.getCellData()).toString());
        }
        return extractElement;
    }
}

