/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.doccontrast.util;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.idp.icpac.cache.SymbolCache;
import com.jxdinfo.idp.icpac.common.entity.FileBytesInfo;
import com.jxdinfo.idp.icpac.doccontrast.entity.ContrastResult;
import com.jxdinfo.idp.icpac.doccontrast.entity.ContrastSymbol;
import com.jxdinfo.idp.icpac.doccontrast.entity.dto.ContrastFileInfoDto;
import com.jxdinfo.idp.icpac.doccontrast.entity.dto.DocContrastDto;
import com.jxdinfo.idp.icpac.doccontrast.util.StringUtils;
import com.jxdinfo.idp.icpac.docexamine.entity.location.WordLocation;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordCellInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordParagraphInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordRowInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordTableInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.utils.ReadWordUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.wltea.analyzer.core.IKSegmenter;
import org.wltea.analyzer.core.Lexeme;

@Component
public class CompareUtil {
    private static final Logger log = LoggerFactory.getLogger(CompareUtil.class);

    public static boolean matchParagraph(String str1, String str2) {
        int k;
        int j;
        boolean result = false;
        int i = 0;
        for (j = 0; j < str1.length(); ++j) {
            if (str1.charAt(j) == ' ') continue;
            str1 = str1.substring(j);
            break;
        }
        for (j = 0; j < str2.length(); ++j) {
            if (str2.charAt(j) == ' ') continue;
            str2 = str2.substring(j);
            break;
        }
        while (i < Math.min(str1.length(), str2.length()) && str1.charAt(i) == str2.charAt(i) && str1.charAt(i) != '\n' && str1.charAt(i) != '\t') {
            ++i;
        }
        StringBuilder str1Builder = new StringBuilder();
        StringBuilder str2Builder = new StringBuilder();
        boolean conn = false;
        for (k = 0; k < str1.length(); ++k) {
            if (str1.charAt(k) == ' ') {
                if (conn) continue;
                str1Builder.append(str1.charAt(k));
                conn = true;
                continue;
            }
            str1Builder.append(str1.charAt(k));
            conn = false;
        }
        conn = false;
        for (k = 0; k < str2.length(); ++k) {
            if (str2.charAt(k) == ' ') {
                if (conn) continue;
                str2Builder.append(str2.charAt(k));
                conn = true;
                continue;
            }
            str2Builder.append(str2.charAt(k));
            conn = false;
        }
        str1 = str1Builder.toString();
        int similarity = CompareUtil.getSimilarity(str1, str2 = str2Builder.toString());
        if (similarity <= Math.max(str1.length(), str2.length()) / 2 || i >= 3 && similarity <= Math.max(str1.length(), str2.length()) / 8) {
            result = true;
        }
        return result;
    }

    public static <T> boolean match(T left, T right) {
        boolean result = true;
        if (left instanceof WordTableInfo) {
            WordTableInfo leftTable = (WordTableInfo)left;
            WordTableInfo rightTable = (WordTableInfo)right;
            if (left.equals(right)) {
                return true;
            }
            int count = 0;
            int point2 = 0;
            block0: for (WordRowInfo row : leftTable.getRows()) {
                for (int i = point2; i < rightTable.getRows().size(); ++i) {
                    if (!CompareUtil.match(row, rightTable.getRows().get(i))) continue;
                    ++count;
                    point2 = i + 1;
                    continue block0;
                }
            }
            return count * 2 > leftTable.getRows().size();
        }
        if (left instanceof WordRowInfo) {
            WordRowInfo leftRow = (WordRowInfo)left;
            WordRowInfo rightRow = (WordRowInfo)right;
            if (leftRow.equals(rightRow)) {
                return true;
            }
            int count = 0;
            int point2 = 0;
            block2: for (WordCellInfo cell : leftRow.getCells()) {
                for (int i = point2; i < rightRow.getCells().size(); ++i) {
                    if (!CompareUtil.match(cell, rightRow.getCells().get(i))) continue;
                    ++count;
                    point2 = i + 1;
                    continue block2;
                }
            }
            result = count * 2 > leftRow.getCells().size();
        } else if (left instanceof WordCellInfo) {
            WordCellInfo leftCell = (WordCellInfo)left;
            WordCellInfo rightCell = (WordCellInfo)right;
            if (leftCell.getText().equals(rightCell.getText())) {
                return true;
            }
            result = CompareUtil.matchParagraph(leftCell.getText(), rightCell.getText());
        }
        return result;
    }

    public static int getSimilarity(String str1, String str2) {
        int i;
        int[][] dp = new int[str1.length() + 1][str2.length() + 1];
        for (i = 0; i <= str1.length(); ++i) {
            dp[i][0] = i;
        }
        for (int j = 0; j <= str2.length(); ++j) {
            dp[0][j] = j;
        }
        for (i = 1; i <= str1.length(); ++i) {
            for (int j = 1; j <= str2.length(); ++j) {
                dp[i][j] = str1.charAt(i - 1) == str2.charAt(j - 1) ? dp[i - 1][j - 1] : 1 + Math.min(dp[i - 1][j - 1], Math.min(dp[i][j - 1], dp[i - 1][j]));
            }
        }
        return dp[str1.length()][str2.length()];
    }

    public static <T> List<ContrastResult> compareTable(List<T> leftList, List<T> rightList, DocContrastDto query) {
        ArrayList<ContrastResult> contrastResultList = new ArrayList<ContrastResult>();
        if (leftList.size() == 0 && rightList.size() == 0) {
            return contrastResultList;
        }
        Class<?> clazz = leftList.size() == 0 ? rightList.get(0).getClass() : leftList.get(0).getClass();
        String resultType = clazz == WordTableInfo.class ? "\u8868\u683c" : (clazz == WordRowInfo.class ? "\u884c" : "\u5355\u5143\u683c");
        int rightPoint = 0;
        try {
            block2: for (int i = 0; i < leftList.size(); ++i) {
                for (int j = rightPoint; j < rightPoint + Math.min(5, rightList.size() - rightPoint); ++j) {
                    if (leftList.size() != rightList.size() && !CompareUtil.match(leftList.get(i), rightList.get(j))) continue;
                    if (clazz == WordTableInfo.class) {
                        for (int k = rightPoint; k < j; ++k) {
                            ContrastResult contrastResult = new ContrastResult();
                            contrastResult.setElementType("1");
                            contrastResult.setRightResult("\u7b2c" + (k + 1) + "\u4e2a" + resultType);
                            contrastResult.setLeftLocation(JSON.toJSONString((Object)CompareUtil.dealTLocation(new WordTableInfo(), -2)));
                            contrastResult.setRightLocation(JSON.toJSONString((Object)CompareUtil.dealTLocation(rightList.get(i), k)));
                            contrastResult.setType("0");
                            contrastResultList.add(contrastResult);
                        }
                    }
                    ArrayList<ContrastResult> tempResult = new ArrayList<ContrastResult>();
                    if (!CompareUtil.getPropertyList(leftList.get(i)).isEmpty() && CompareUtil.getPropertyList(leftList.get(i)).get(0) instanceof WordParagraphInfo) {
                        tempResult.addAll(CompareUtil.compareParagraph(CompareUtil.getPropertyList(leftList.get(i)), CompareUtil.getPropertyList(rightList.get(j)), 2, query));
                    } else {
                        tempResult.addAll(CompareUtil.compareTable(CompareUtil.getPropertyList(leftList.get(i)), CompareUtil.getPropertyList(rightList.get(j)), query));
                    }
                    if (!tempResult.isEmpty()) {
                        for (ContrastResult result : tempResult) {
                            WordLocation leftLocation = (WordLocation)JSON.parseObject((String)result.getLeftLocation(), WordLocation.class);
                            WordLocation rightLocation = (WordLocation)JSON.parseObject((String)result.getRightLocation(), WordLocation.class);
                            WordLocation.TableLocation leftTLocation = leftLocation.getTLocation();
                            WordLocation.TableLocation rightTLocation = rightLocation.getTLocation();
                            if (clazz == WordTableInfo.class) {
                                WordTableInfo tempLeftInfo = (WordTableInfo)leftList.get(i);
                                WordTableInfo tempRightInfo = (WordTableInfo)rightList.get(j);
                                leftTLocation.setPIndex(tempLeftInfo.getLastPIndex());
                                leftTLocation.setIndex(i);
                                if (leftTLocation.getType() != 1) {
                                    leftTLocation.setType(0);
                                }
                                rightTLocation.setPIndex(tempRightInfo.getLastPIndex());
                                rightTLocation.setIndex(j);
                                if (rightTLocation.getType() != 1) {
                                    rightTLocation.setType(0);
                                }
                            } else if (clazz == WordRowInfo.class) {
                                leftTLocation.setRowIndex(i);
                                rightTLocation.setRowIndex(j);
                            } else if (clazz == WordCellInfo.class) {
                                leftTLocation.setCellIndex(i);
                                leftTLocation.setType(1);
                                rightTLocation.setCellIndex(j);
                                rightTLocation.setType(1);
                            }
                            result.setLeftLocation(JSON.toJSONString((Object)leftLocation));
                            result.setRightLocation(JSON.toJSONString((Object)rightLocation));
                        }
                        contrastResultList.addAll(tempResult);
                    }
                    rightPoint = j + 1;
                    continue block2;
                }
                ContrastResult contrastResult = new ContrastResult();
                contrastResult.setElementType("3");
                contrastResult.setLeftResult("\u7b2c" + (i + 1) + "\u4e2a" + resultType);
                contrastResult.setLeftLocation(JSON.toJSONString((Object)CompareUtil.dealTLocation(leftList.get(i), i)));
                contrastResult.setRightLocation(JSON.toJSONString((Object)CompareUtil.dealTLocation(new WordTableInfo(), -2)));
                if (clazz == WordTableInfo.class) {
                    contrastResult.setRightLocation(JSON.toJSONString((Object)CompareUtil.dealTLocation(new WordTableInfo(), -2)));
                } else {
                    contrastResult.setRightLocation(JSON.toJSONString((Object)CompareUtil.dealTLocation(rightList.get(Math.max(0, rightPoint - 1)), rightPoint)));
                }
                contrastResult.setType("0");
                contrastResultList.add(contrastResult);
            }
            while (rightPoint < rightList.size()) {
                ContrastResult contrastResult = new ContrastResult();
                contrastResult.setElementType("1");
                WordTableInfo info = new WordTableInfo();
                info.setPIndex(-1);
                contrastResult.setLeftLocation(JSON.toJSONString((Object)CompareUtil.dealTLocation(info, -1)));
                contrastResult.setRightLocation(JSON.toJSONString((Object)CompareUtil.dealTLocation(rightList.get(rightPoint), rightPoint)));
                contrastResult.setRightResult("\u7b2c" + (rightPoint + 1) + "\u4e2a" + resultType);
                contrastResult.setType("0");
                contrastResultList.add(contrastResult);
                ++rightPoint;
            }
        }
        catch (Exception e) {
            log.error(leftList.get(0).getClass() + "\u7c7b\u578b\u904d\u5386\u51fa\u9519\uff01");
        }
        return CompareUtil.dealTableResult(contrastResultList);
    }

    public static List<ContrastResult> compareParagraph(List<WordParagraphInfo> leftParagraphs, List<WordParagraphInfo> rightParagraphs, int type, DocContrastDto query) {
        ArrayList<ContrastResult> contrastResultList = new ArrayList<ContrastResult>();
        Map<String, Integer> leftMenu = CompareUtil.getMenu(leftParagraphs);
        int leftStart = leftMenu.get("start");
        int leftEnd = leftMenu.get("end");
        Map<String, Integer> rightMenu = CompareUtil.getMenu(rightParagraphs);
        int rightStart = rightMenu.get("start");
        int rightEnd = rightMenu.get("end");
        int rightPoint = 0;
        block0: for (int i = 0; i < leftParagraphs.size(); ++i) {
            int j;
            for (j = i; j < leftParagraphs.size() && (leftParagraphs.get(j).getText().isEmpty() || "\r".equals(leftParagraphs.get(j).getText()) || " ".equals(leftParagraphs.get(j).getText()) || "\n".equals(leftParagraphs.get(j).getText())); ++j) {
                ++i;
            }
            for (j = rightPoint; j < rightParagraphs.size() && (rightParagraphs.get(rightPoint).getText().isEmpty() || "\r".equals(rightParagraphs.get(rightPoint).getText()) || " ".equals(rightParagraphs.get(rightPoint).getText()) || "\n".equals(rightParagraphs.get(rightPoint).getText())); ++j) {
                ++rightPoint;
            }
            if (query.isMenu()) {
                if (leftEnd - leftStart > 0) {
                    for (j = i; j < leftParagraphs.size() && leftStart <= leftParagraphs.get(j).getIndex() && leftParagraphs.get(j).getIndex() < leftEnd; ++j) {
                        ++i;
                    }
                }
                if (rightEnd - rightStart > 0) {
                    for (j = rightPoint; j < rightParagraphs.size() && rightStart <= rightParagraphs.get(j).getIndex() && rightParagraphs.get(j).getIndex() < rightEnd; ++j) {
                        ++rightPoint;
                    }
                }
            }
            for (j = i; j < leftParagraphs.size() && (leftParagraphs.get(j).getText().isEmpty() || "\r".equals(leftParagraphs.get(j).getText()) || " ".equals(leftParagraphs.get(j).getText()) || "\n".equals(leftParagraphs.get(j).getText())); ++j) {
                ++i;
            }
            for (j = rightPoint; j < rightParagraphs.size() && (rightParagraphs.get(rightPoint).getText().isEmpty() || "\r".equals(rightParagraphs.get(rightPoint).getText()) || " ".equals(rightParagraphs.get(rightPoint).getText()) || "\n".equals(rightParagraphs.get(rightPoint).getText())); ++j) {
                ++rightPoint;
            }
            if (i == leftParagraphs.size()) break;
            int count = 0;
            for (int j2 = rightPoint; j2 < rightParagraphs.size(); ++j2) {
                if (rightParagraphs.get(j2).getText().isEmpty() || "\r".equals(rightParagraphs.get(j2).getText()) || " ".equals(rightParagraphs.get(j2).getText()) || "\n".equals(rightParagraphs.get(j2).getText())) continue;
                if (++count >= 10) break;
                if (!CompareUtil.matchParagraph(leftParagraphs.get(i).getText(), rightParagraphs.get(j2).getText())) continue;
                for (int k = rightPoint; k < j2; ++k) {
                    if (rightParagraphs.get(k).getText().isEmpty() || "\r".equals(rightParagraphs.get(k).getText()) || " ".equals(rightParagraphs.get(k).getText()) || "\n".equals(rightParagraphs.get(k).getText())) continue;
                    ContrastResult contrastResult = new ContrastResult();
                    contrastResult.setElementType("1");
                    contrastResult.setRightResult(rightParagraphs.get(k).getText());
                    WordLocation leftLocation = new WordLocation();
                    WordLocation rightLocation = new WordLocation();
                    if (type == 1) {
                        WordLocation.ParagraphLocation leftPLocation = leftLocation.newPLocation();
                        leftPLocation.setIndex(leftParagraphs.get(i).getIndex());
                        leftPLocation.setDelFlag(true);
                        leftPLocation.setLeft(true);
                        WordLocation.ParagraphLocation rightPLocation = rightLocation.newPLocation();
                        rightPLocation.setIndex(rightParagraphs.get(k).getIndex());
                        rightPLocation.setDelFlag(false);
                        rightPLocation.setLeft(false);
                        contrastResult.setLeftLocation(JSON.toJSONString((Object)leftLocation));
                        contrastResult.setRightLocation(JSON.toJSONString((Object)rightLocation));
                    } else if (type == 2) {
                        WordLocation.TableLocation leftTLocation = leftLocation.newTLocation();
                        leftTLocation.setCellPIndex(leftParagraphs.get(i).getIndex());
                        WordLocation.TableLocation rightTLocation = rightLocation.newTLocation();
                        rightTLocation.setCellPIndex(rightParagraphs.get(k).getIndex());
                        contrastResult.setLeftLocation(JSON.toJSONString((Object)leftLocation));
                        contrastResult.setRightLocation(JSON.toJSONString((Object)rightLocation));
                    }
                    contrastResult.setType("0");
                    contrastResultList.add(contrastResult);
                }
                List<ContrastResult> textResult = CompareUtil.compareText(leftParagraphs.get(i).getText(), rightParagraphs.get(j2).getText(), leftParagraphs.get(i).getIndex(), rightParagraphs.get(j2).getIndex(), type, query);
                if (textResult.size() == 1 && query.isCompareFlag()) {
                    Matcher matcherLeft;
                    Pattern pattern = Pattern.compile("\\d+\\.\\d+\\.\\d+\\.\\d+|\\d+\\.\\d+\\.\\d+|\\d+\\.\\d|\\d\\.|\u7b2c[\\d|\u4e00-\u5341]\u7ae0");
                    String leftResult = textResult.get(0).getLeftResult();
                    if (leftResult != null && (matcherLeft = pattern.matcher(leftResult)).find()) {
                        textResult = new ArrayList<ContrastResult>();
                    }
                }
                if (!textResult.isEmpty()) {
                    contrastResultList.addAll(textResult);
                }
                rightPoint = j2 + 1;
                continue block0;
            }
            if (leftParagraphs.get(i).getText().isEmpty() || "\r".equals(leftParagraphs.get(i).getText()) || " ".equals(leftParagraphs.get(i).getText()) || "\n".equals(leftParagraphs.get(i).getText()) || CompareUtil.checkSymbol(leftParagraphs.get(i).getText().charAt(0))) continue;
            ContrastResult contrastResult = new ContrastResult();
            contrastResult.setElementType("3");
            contrastResult.setLeftResult(leftParagraphs.get(i).getText());
            contrastResult.setType("0");
            WordLocation leftLocation = new WordLocation();
            WordLocation rightLocation = new WordLocation();
            if (type == 1) {
                WordLocation.ParagraphLocation leftPLocation = leftLocation.newPLocation();
                leftPLocation.setIndex(leftParagraphs.get(i).getIndex());
                leftPLocation.setDelFlag(false);
                leftPLocation.setLeft(true);
                WordLocation.ParagraphLocation rightPLocation = rightLocation.newPLocation();
                if (rightPoint >= rightParagraphs.size()) {
                    rightPLocation.setIndex(-1);
                } else {
                    rightPLocation.setIndex(rightParagraphs.get(rightPoint).getIndex());
                }
                rightPLocation.setDelFlag(true);
                rightPLocation.setLeft(false);
                contrastResult.setLeftLocation(JSON.toJSONString((Object)leftLocation));
                contrastResult.setRightLocation(JSON.toJSONString((Object)rightLocation));
            } else if (type == 2) {
                WordLocation.TableLocation leftTLocation = leftLocation.newTLocation();
                WordLocation.TableLocation rightTLocation = rightLocation.newTLocation();
                leftTLocation.setCellPIndex(leftParagraphs.get(i).getIndex());
                if (i == leftParagraphs.size() - 1) {
                    rightTLocation.setCellPIndex(-1);
                } else {
                    rightTLocation.setCellPIndex(rightParagraphs.get(rightPoint).getIndex());
                }
                contrastResult.setLeftLocation(JSON.toJSONString((Object)leftLocation));
                contrastResult.setRightLocation(JSON.toJSONString((Object)rightLocation));
            }
            contrastResultList.add(contrastResult);
        }
        while (rightPoint < rightParagraphs.size()) {
            if (!(rightParagraphs.get(rightPoint).getText().isEmpty() || "\r".equals(rightParagraphs.get(rightPoint).getText()) || " ".equals(rightParagraphs.get(rightPoint).getText()) || rightParagraphs.get(rightPoint).getText().length() != 1 || CompareUtil.checkSymbol(rightParagraphs.get(rightPoint).getText().charAt(0)) || "\n".equals(rightParagraphs.get(rightPoint).getText()))) {
                ContrastResult contrastResult = new ContrastResult();
                contrastResult.setElementType("1");
                contrastResult.setRightResult(rightParagraphs.get(rightPoint).getText());
                contrastResult.setType("0");
                WordLocation leftLocation = new WordLocation();
                WordLocation rightLocation = new WordLocation();
                if (type == 1) {
                    WordLocation.ParagraphLocation leftPLocation = leftLocation.newPLocation();
                    WordLocation.ParagraphLocation rightPLocation = rightLocation.newPLocation();
                    leftPLocation.setIndex(-1);
                    leftPLocation.setDelFlag(true);
                    rightPLocation.setIndex(rightParagraphs.get(rightPoint).getIndex());
                    rightPLocation.setDelFlag(false);
                    contrastResult.setLeftLocation(JSON.toJSONString((Object)leftLocation));
                    contrastResult.setRightLocation(JSON.toJSONString((Object)rightLocation));
                } else if (type == 2) {
                    WordLocation.TableLocation leftTLocation = leftLocation.newTLocation();
                    WordLocation.TableLocation rightTLocation = rightLocation.newTLocation();
                    leftTLocation.setCellPIndex(-1);
                    rightTLocation.setCellPIndex(rightParagraphs.get(rightPoint).getIndex());
                    contrastResult.setLeftLocation(JSON.toJSONString((Object)leftLocation));
                    contrastResult.setRightLocation(JSON.toJSONString((Object)rightLocation));
                }
                contrastResultList.add(contrastResult);
            }
            ++rightPoint;
        }
        return contrastResultList;
    }

    public static List<ContrastResult> compareText(String str1, String str2, int leftParagraphIndex, int rightParagraphIndex, int type, DocContrastDto query) {
        ArrayList<ContrastResult> result = new ArrayList<ContrastResult>();
        if (str1.equals(str2)) {
            return result;
        }
        HashMap<Integer, String> str1List = new HashMap<Integer, String>();
        HashMap<Integer, String> str2List = new HashMap<Integer, String>();
        String[] str1s = CompareUtil.segMore(str1, true, query.isSymbol());
        int point1 = 0;
        int point2 = 0;
        Pattern pattern = Pattern.compile("\\pP");
        for (int m = 0; m < str1s.length; ++m) {
            int i;
            if (StringUtils.isEmpty(str1s[m])) {
                ++point1;
                continue;
            }
            ArrayList<Integer> indices = new ArrayList<Integer>();
            int index = str2.indexOf(str1s[m], point2);
            while (index != -1) {
                indices.add(index);
                index = str2.indexOf(str1s[m], index + 1);
            }
            if (query.isSymbol() && point1 != str1.indexOf(str1s[m], point1)) {
                if (point2 <= str2.length() - 1) {
                    while (CompareUtil.checkSymbol(str2.charAt(point2))) {
                        if (!str1List.containsKey(point1 - 1) || !((String)str1List.get(point1 - 1)).equals("1")) {
                            ++point2;
                        }
                        if (point2 != str2.length()) continue;
                    }
                }
                point1 = Math.max(str1.indexOf(str1s[m], point1), point1);
            }
            if (indices.size() == 0) {
                for (i = point1; i < point1 + str1s[m].length(); ++i) {
                    str1List.put(i, "3");
                }
                if (point2 == 0) {
                    str2List.put(-1, "5");
                } else {
                    str2List.put(point2 - 1, "5");
                }
                if (m == str1s.length - 1 && point2 < str2.length()) {
                    if (point1 + str1s[m].length() != str1.length() && str2.length() - str1.length() + point1 + str1s[m].length() > 0) {
                        boolean findDif;
                        boolean bl = findDif = str1.charAt(point1 + str1s[m].length()) == str2.charAt(str2.length() - str1.length() + point1 + str1s[m].length());
                        if (findDif && point2 == str2.length() - str1.length() + point1 + str1s[m].length()) {
                            point1 += str1s[m].length();
                            continue;
                        }
                    }
                    str2List.remove(point2 - 1);
                    for (i = point2; i < str2.length(); ++i) {
                        str2List.put(i, "2");
                    }
                    for (int j = point1 + str1s[m].length() - 1; j >= 0 && str1List.containsKey(j); --j) {
                        str1List.put(j, "2");
                    }
                    point2 = str2.length();
                }
            } else if (indices.size() == 1) {
                if (m > 0 && !CompareUtil.checkCorrect(str1s, str2, m, (Integer)indices.get(0), query.isSymbol())) {
                    for (i = point1; i < point1 + str1s[m].length(); ++i) {
                        str1List.put(i, "3");
                    }
                    if (point2 == 0) {
                        str2List.put(point2, "5");
                    } else {
                        str2List.put(point2 - 1, "5");
                    }
                    point1 += str1s[m].length();
                    continue;
                }
                if (point2 == (Integer)indices.get(0)) {
                    point2 += str1s[m].length();
                } else {
                    int tempLength2 = 0;
                    while ((Integer)indices.get(0) - 1 - tempLength2 >= 0 && CompareUtil.checkSymbol(str2.charAt((Integer)indices.get(0) - 1 - tempLength2))) {
                        ++tempLength2;
                    }
                    int tempLength1 = 0;
                    while (point1 - 1 - tempLength1 >= 0 && CompareUtil.checkSymbol(str1.charAt(point1 - 1 - tempLength1)) && tempLength2 > 0) {
                        ++tempLength1;
                    }
                    for (int j = (Integer)indices.get(0) - 1 - tempLength2; j >= point2; --j) {
                        if (str1List.containsKey(point1 - tempLength1 - j + point2 - 1) && ((String)str1List.get(point1 - tempLength1 - j + point2 - 1)).equals("3")) {
                            str2List.remove(point2 - 1);
                            str1List.put(point1 - tempLength1 - j + point2 - 1, "2");
                            str2List.put(point2 + (Integer)indices.get(0) - 1 - tempLength2 - j, "2");
                            continue;
                        }
                        str2List.put(point2 + (Integer)indices.get(0) - 1 - tempLength2 - j, "1");
                        str1List.put(point1 - tempLength1 - 1, "4");
                    }
                    point2 = (Integer)indices.get(0) + str1s[m].length();
                }
            } else {
                int tempPoint = (Integer)indices.get(0);
                int checkSize = 1;
                int symbol = 0;
                while (indices.size() > 1) {
                    Iterator iterator = indices.iterator();
                    while (iterator.hasNext()) {
                        int checkPoint = (Integer)iterator.next();
                        while (point1 + checkSize + symbol < str1.length() - 1 && CompareUtil.checkSymbol(str1.charAt(point1 + checkSize + symbol))) {
                            ++symbol;
                        }
                        if (checkPoint + checkSize + symbol >= str2.length() || point1 + checkSize + symbol >= str1.length()) {
                            iterator.remove();
                            continue;
                        }
                        if (str1.charAt(point1 + checkSize + symbol) == str2.charAt(checkPoint + checkSize + symbol)) continue;
                        iterator.remove();
                    }
                    ++checkSize;
                }
                if (indices.size() == 1) {
                    tempPoint = (Integer)indices.get(0);
                }
                if (point2 == tempPoint) {
                    point2 += str1s[m].length();
                } else {
                    int tempLength2 = 0;
                    while (tempPoint - 1 - tempLength2 >= 0 && CompareUtil.checkSymbol(str2.charAt(tempPoint - 1 - tempLength2))) {
                        ++tempLength2;
                    }
                    int tempLength1 = 0;
                    while (point1 - 1 - tempLength1 >= 0 && CompareUtil.checkSymbol(str1.charAt(point1 - 1 - tempLength1)) && tempLength2 > 0) {
                        ++tempLength1;
                    }
                    for (int j = tempPoint - 1 - tempLength2; j >= point2; --j) {
                        if (str1List.containsKey(point1 - tempLength1 - j + point2 - 1) && ((String)str1List.get(point1 - tempLength1 - j + point2 - 1)).equals("3")) {
                            str2List.remove(point2 - 1);
                            str1List.put(point1 - tempLength1 - j + point2 - 1, "2");
                            str2List.put(point2 + tempPoint - 1 - tempLength2 - j, "2");
                            continue;
                        }
                        str2List.put(point2 + tempPoint - 1 - tempLength2 - j, "1");
                        str1List.put(point1 - tempLength1 - 1, "4");
                    }
                    point2 = tempPoint + str1s[m].length();
                }
            }
            point1 += str1s[m].length();
        }
        for (int i = 1; i < str1.length(); ++i) {
            int length = 0;
            if (i == str1.length() - 1) {
                if (!pattern.matcher(String.valueOf(str1.charAt(i - 1))).find() || !str1List.containsKey(i - 1)) break;
                str1List.put(i, (String)str1List.get(i - 1));
                break;
            }
            while (i + length < str1.length() && pattern.matcher(String.valueOf(str1.charAt(i + length))).find()) {
                ++length;
            }
            if (!str1List.containsKey(i - 1) || !str1List.containsKey(i + length)) continue;
            for (int j = 0; j < length; ++j) {
                str1List.put(i, (String)str1List.get(i - 1));
            }
        }
        while (point2 < str2.length()) {
            int tempPoint;
            for (tempPoint = str2.length() - 1; tempPoint >= 0 && CompareUtil.checkSymbol(str2.charAt(tempPoint)); --tempPoint) {
            }
            if (!CompareUtil.checkSymbol(str2.charAt(point2)) && str2.charAt(point2) != '\u00a0') {
                ContrastResult contrastResult = new ContrastResult();
                contrastResult.setElementType("1");
                contrastResult.setType("0");
                contrastResult.setRightResult(str2.substring(point2, tempPoint + 1));
                int blank2 = CompareUtil.countBlank(str2, tempPoint + 1);
                int blank1 = CompareUtil.countBlank(str1, point1);
                WordLocation leftLocation = new WordLocation();
                WordLocation rightLocation = new WordLocation();
                if (type == 1) {
                    WordLocation.ParagraphLocation leftPLocation = leftLocation.newPLocation();
                    leftPLocation.setIndex(leftParagraphIndex);
                    leftPLocation.setTextIndex(point1 - 1 - blank1);
                    leftPLocation.setTextLength(0);
                    leftPLocation.setDelFlag(true);
                    leftPLocation.setLeft(true);
                    WordLocation.ParagraphLocation rightPLocation = rightLocation.newPLocation();
                    rightPLocation.setIndex(rightParagraphIndex);
                    rightPLocation.setTextIndex(point2 - blank2);
                    rightPLocation.setTextLength(tempPoint - point2 + 1);
                    rightPLocation.setLeft(false);
                    contrastResult.setLeftLocation(JSON.toJSONString((Object)leftLocation));
                    contrastResult.setRightLocation(JSON.toJSONString((Object)rightLocation));
                } else if (type == 2) {
                    WordLocation.TableLocation leftTLocation = leftLocation.newTLocation();
                    WordLocation.TableLocation rightTLocation = rightLocation.newTLocation();
                    leftTLocation.setCellPIndex(leftParagraphIndex);
                    rightTLocation.setCellPIndex(rightParagraphIndex);
                    leftTLocation.setTextIndex(point1 - 1 - blank1);
                    rightTLocation.setTextIndex(point2 - blank2);
                    leftTLocation.setTextLength(0);
                    rightTLocation.setTextLength(tempPoint - point2 + 1);
                    contrastResult.setLeftLocation(JSON.toJSONString((Object)leftLocation));
                    contrastResult.setRightLocation(JSON.toJSONString((Object)rightLocation));
                }
                if (contrastResult.getRightResult().equals("") && contrastResult.getLeftResult().equals(" ") || contrastResult.getRightResult().equals(" ") && contrastResult.getLeftResult().equals("")) break;
                result.add(contrastResult);
                break;
            }
            ++point2;
        }
        result.addAll(CompareUtil.afterHandle(CompareUtil.dealString(str1, str1List, "1", leftParagraphIndex, type, query.isSymbol()), CompareUtil.dealString(str2, str2List, "2", rightParagraphIndex, type, query.isSymbol())));
        return result;
    }

    private static List<ContrastResult> dealString(String str, Map<Integer, String> strList, String side, int paragraph, int type, boolean symbol) {
        int blank = 0;
        boolean next = false;
        ArrayList<ContrastResult> results = new ArrayList<ContrastResult>();
        if (strList.containsKey(-1)) {
            ContrastResult tempResult = new ContrastResult();
            tempResult.setType("0");
            if (strList.get(-1).equals("4")) {
                tempResult.setElementType("1");
            } else if (strList.get(-1).equals("5")) {
                tempResult.setElementType("3");
            }
            WordLocation wordLocation = new WordLocation();
            WordLocation.ParagraphLocation location = wordLocation.newPLocation();
            location.setIndex(paragraph);
            location.setTextIndex(-1);
            location.setTextLength(-1);
            if (side.equals("1")) {
                tempResult.setLeftResult("");
                tempResult.setLeftLocation(JSON.toJSONString((Object)wordLocation));
            } else if (side.equals("2")) {
                tempResult.setRightResult("");
                tempResult.setRightLocation(JSON.toJSONString((Object)wordLocation));
            }
            results.add(tempResult);
        }
        block0: for (int i = 0; i < str.length(); ++i) {
            Object location;
            char temp = str.charAt(i);
            if (str.charAt(i) == ' ' || str.charAt(i) == '\u00a0' || Character.isWhitespace(str.charAt(i))) {
                if (next) {
                    ++blank;
                } else {
                    next = true;
                }
            } else {
                next = false;
            }
            int j = i + 1;
            if (!strList.containsKey(i)) continue;
            ContrastResult tempResult = new ContrastResult();
            tempResult.setType("0");
            WordLocation wordLocation = new WordLocation();
            StringBuilder ans = new StringBuilder();
            if (str.charAt(i) != ' ' && str.charAt(i) != '\u00a0' && !Character.isWhitespace(str.charAt(i))) {
                ans.append(str.charAt(i));
            }
            tempResult.setElementType(strList.get(i));
            int back = i - 1;
            int trashLength = 0;
            while (strList.containsKey(j) && !strList.get(i).equals("4") && !strList.get(i).equals("5")) {
                if (!symbol) {
                    ans.append(str.charAt(j));
                } else if (str.charAt(j) != ' ' && str.charAt(j) != '\u00a0' && !Character.isWhitespace(str.charAt(j))) {
                    ans.append(str.charAt(j));
                }
                if (strList.get(i).equals("2")) {
                    tempResult.setElementType("2");
                }
                ++i;
                ++j;
                while (j - 1 - trashLength >= 0 && CompareUtil.checkSymbol(str.charAt(j - 1 - trashLength))) {
                    ++trashLength;
                }
                if (ans.length() != 1 || !CompareUtil.checkSymbol(ans.charAt(0))) continue;
                continue block0;
            }
            if (type == 1) {
                location = wordLocation.newPLocation();
                ((WordLocation.ParagraphLocation)location).setIndex(paragraph);
                ((WordLocation.ParagraphLocation)location).setTextIndex(back + 1 - blank);
                ((WordLocation.ParagraphLocation)location).setTextLength(ans.length());
                if (tempResult.getElementType().equals("4")) {
                    ans = new StringBuilder("");
                    ((WordLocation.ParagraphLocation)location).setTextLength(0);
                    tempResult.setElementType("1");
                } else if (tempResult.getElementType().equals("5")) {
                    ans = new StringBuilder("");
                    ((WordLocation.ParagraphLocation)location).setTextLength(0);
                    tempResult.setElementType("3");
                }
                if (side.equals("1")) {
                    tempResult.setLeftResult(ans.toString());
                    ((WordLocation.ParagraphLocation)location).setLeft(true);
                    tempResult.setLeftLocation(JSON.toJSONString((Object)wordLocation));
                } else if (side.equals("2")) {
                    tempResult.setRightResult(ans.toString());
                    ((WordLocation.ParagraphLocation)location).setLeft(false);
                    tempResult.setRightLocation(JSON.toJSONString((Object)wordLocation));
                }
            } else if (type == 2) {
                location = wordLocation.newTLocation();
                ((WordLocation.TableLocation)location).setCellPIndex(paragraph);
                ((WordLocation.TableLocation)location).setTextIndex(back + 1 - blank);
                ((WordLocation.TableLocation)location).setTextLength(ans.length());
                if (tempResult.getElementType().equals("4")) {
                    ans = new StringBuilder("");
                    ((WordLocation.TableLocation)location).setTextLength(0);
                    tempResult.setElementType("1");
                } else if (tempResult.getElementType().equals("5")) {
                    ans = new StringBuilder("");
                    ((WordLocation.TableLocation)location).setTextLength(0);
                    tempResult.setElementType("3");
                }
                if (side.equals("1")) {
                    tempResult.setLeftResult(ans.toString());
                    tempResult.setLeftLocation(JSON.toJSONString((Object)wordLocation));
                } else if (side.equals("2")) {
                    tempResult.setRightResult(ans.toString());
                    tempResult.setRightLocation(JSON.toJSONString((Object)wordLocation));
                }
            }
            results.add(tempResult);
        }
        return results;
    }

    private static List<ContrastResult> afterHandle(List<ContrastResult> list1, List<ContrastResult> list2) {
        ArrayList<ContrastResult> results = new ArrayList<ContrastResult>();
        String[] texts = new String[list2.size()];
        String[] rightLocations = new String[list2.size()];
        int point = 0;
        for (ContrastResult tempResult : list2) {
            texts[point] = tempResult.getRightResult();
            rightLocations[point] = tempResult.getRightLocation();
            ++point;
        }
        point = 0;
        for (ContrastResult tempResult : list1) {
            if (point >= texts.length) {
                log.error("\u5bf9\u6bd4\u51fa\u73b0\u5197\u4f59\u6570\u636e" + list1.get(point));
                break;
            }
            tempResult.setRightResult(texts[point]);
            tempResult.setRightLocation(rightLocations[point]);
            if (texts[point].equals("") && tempResult.getLeftResult().equals(" ") || texts[point].equals(" ") && tempResult.getLeftResult().equals("")) {
                ++point;
                continue;
            }
            if (texts[point].equals("") && tempResult.getLeftResult().equals("/") || texts[point].equals("/") && tempResult.getLeftResult().equals("")) {
                ++point;
                continue;
            }
            if (texts[point].equals("") && tempResult.getLeftResult().equals(".") || texts[point].equals(".") && tempResult.getLeftResult().equals("")) {
                ++point;
                continue;
            }
            results.add(tempResult);
            ++point;
        }
        return results;
    }

    public static String[] segMore(String text, boolean useSmart, boolean symbol) {
        int i;
        String[] strings = CompareUtil.segText(text, useSmart).split(" ");
        int tempPoint = 0;
        block0: for (int m = 0; m < strings.length; ++m) {
            for (i = 0; i < strings[m].length(); ++i) {
                if (strings[m].charAt(i) < 'a' || strings[m].charAt(i) > 'z') continue;
                int symbols = tempPoint;
                while (Character.isWhitespace(text.charAt(symbols)) || text.charAt(symbols) == '\u00a0' || text.charAt(symbols) == '\u00a0' || CompareUtil.checkSymbol(text.charAt(symbols))) {
                    ++symbols;
                }
                strings[m] = text.substring(symbols, symbols + strings[m].length());
                tempPoint = symbols + strings[m].length();
                continue block0;
            }
            tempPoint = text.indexOf(strings[m], tempPoint) + strings[m].length();
        }
        if (symbol) {
            block3: for (int j = 0; j < strings.length; ++j) {
                for (i = 0; i < strings[j].length(); ++i) {
                    if (i >= strings[j].length()) {
                        i = strings[j].length() - 1;
                    }
                    if (!CompareUtil.checkSymbol(strings[j].charAt(i))) break;
                    strings[j] = strings[j].replace(String.valueOf(strings[j].charAt(i)), "");
                }
                for (i = strings[j].length() - 1; i >= 0; --i) {
                    if (i >= strings[j].length()) {
                        i = strings[j].length() - 1;
                    }
                    if (!CompareUtil.checkSymbol(strings[j].charAt(i))) continue block3;
                    strings[j] = strings[j].replace(String.valueOf(strings[j].charAt(i)), "");
                }
            }
        } else {
            int point1 = 0;
            StringBuilder tempResult = new StringBuilder();
            for (String t : strings) {
                if (point1 == text.indexOf(t, point1)) {
                    tempResult.append(t).append("&blank_sign");
                    point1 += t.length();
                    continue;
                }
                for (int i2 = point1; i2 < text.indexOf(t, point1); ++i2) {
                    tempResult.append(text.charAt(i2)).append("&blank_sign");
                }
                tempResult.append(t).append("&blank_sign");
                point1 = text.indexOf(t, point1) + t.length();
            }
            strings = tempResult.toString().split("&blank_sign");
        }
        return strings;
    }

    private static String segText(String text, boolean useSmart) {
        StringBuilder result = new StringBuilder();
        IKSegmenter ik = new IKSegmenter((Reader)new StringReader(text), useSmart);
        try {
            Lexeme word;
            while ((word = ik.next()) != null) {
                result.append(word.getLexemeText()).append(" ");
            }
        }
        catch (IOException ex) {
            log.error("\u5206\u8bcd\u5668\u9884\u8bbe\u51fa\u73b0\u95ee\u9898");
        }
        return result.toString();
    }

    public static boolean checkSymbol(char text) {
        List<ContrastSymbol> symbols = SymbolCache.SymbolCache;
        if (text == '\r' || text == '\n' || text == ' ' || text == '\u0001') {
            return true;
        }
        for (ContrastSymbol symbol : symbols) {
            if (symbol.getSymbol().length() <= 0 || text != symbol.getSymbol().charAt(0)) continue;
            return true;
        }
        return false;
    }

    public static int countBlank(String str, int point) {
        boolean con = false;
        int blank = 0;
        for (int i = 0; i < point; ++i) {
            if (str.charAt(i) == ' ') {
                if (con) {
                    ++blank;
                    continue;
                }
                con = true;
                continue;
            }
            con = false;
        }
        return blank;
    }

    public static <T> List<?> getPropertyList(T entity) {
        ArrayList propertyList = new ArrayList();
        Class<?> clazz = entity.getClass();
        if (clazz == WordTableInfo.class) {
            try {
                Field field = clazz.getDeclaredField("rows");
                field.setAccessible(true);
                List text2List = (List)field.get(entity);
                propertyList.addAll(text2List);
            }
            catch (Exception e) {
                log.error("WordTableInfo\u7c7b\u578b\u8f6c\u6362\u9519\u8bef");
            }
        } else if (clazz == WordRowInfo.class) {
            try {
                Field field = clazz.getDeclaredField("cells");
                field.setAccessible(true);
                List stringList = (List)field.get(entity);
                propertyList.addAll(stringList);
            }
            catch (Exception e) {
                log.error("RowInfo\u7c7b\u578b\u8f6c\u6362\u9519\u8bef");
            }
        } else if (clazz == WordCellInfo.class) {
            try {
                Field field = clazz.getDeclaredField("paragraphs");
                field.setAccessible(true);
                List paragraphList = (List)field.get(entity);
                propertyList.addAll(paragraphList);
            }
            catch (Exception e) {
                log.error("CellInfo\u7c7b\u578b\u8f6c\u6362\u9519\u8bef");
            }
        }
        return propertyList;
    }

    public static <T> WordLocation dealTLocation(T info, int Index) {
        Class<?> clazz = info.getClass();
        WordLocation location = new WordLocation();
        WordLocation.TableLocation tableLocation = location.newTLocation();
        if (clazz == WordTableInfo.class) {
            if (Index != -2) {
                WordTableInfo tableInfo = (WordTableInfo)info;
                tableLocation.setPIndex(tableInfo.getLastPIndex());
            }
            tableLocation.setIndex(Index);
            tableLocation.setType(0);
        } else if (clazz == WordRowInfo.class) {
            tableLocation.setRowIndex(Index);
            tableLocation.setType(0);
        } else if (clazz == WordCellInfo.class) {
            tableLocation.setCellIndex(Index);
            tableLocation.setType(1);
        }
        return location;
    }

    public static boolean checkCorrect(String[] str1s, String str2, int point1, int point2, boolean symbol) {
        if (point1 == 0 || point1 == str1s.length - 1) {
            return true;
        }
        boolean result = false;
        if (point1 > 0) {
            String back = str1s[point1 - 1];
            int backPoint2 = point2;
            if (symbol) {
                while (backPoint2 - 1 >= 0 && CompareUtil.checkSymbol(str2.charAt(backPoint2 - 1))) {
                    --backPoint2;
                }
            }
            if (point2 == 0 || str2.startsWith(back, backPoint2 - back.length())) {
                result = true;
            }
        }
        if (point1 < str1s.length - 1) {
            String front = str1s[point1 + 1];
            if (symbol) {
                while (point2 + str1s[point1].length() < str2.length() && CompareUtil.checkSymbol(str2.charAt(point2 + str1s[point1].length()))) {
                    ++point2;
                }
            }
            if (point2 == str2.length() || str2.startsWith(front, point2 + str1s[point1].length())) {
                if (front.endsWith("\u6708") && point1 + 2 < str1s.length) {
                    front = str1s[point1 + 2];
                    if (point2 == str2.length() || str2.startsWith(front, point2 + str1s[point1].length() + str1s[point1 + 1].length())) {
                        result = true;
                    }
                } else {
                    result = true;
                }
            }
        }
        return result;
    }

    public static Map<String, Integer> getMenu(List<WordParagraphInfo> paragraphInfos) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Pattern pattern = Pattern.compile("\\d+\\.\\d+\\.\\d+|\\d+\\.\\d|[\\d|\u4e00-\u5341][\\.|\\\u3001]|\u7b2c[\\d|\u4e00-\u5341]\u7ae0");
        int hasNext = 0;
        String tempStr = "0";
        for (WordParagraphInfo paragraphInfo : paragraphInfos) {
            Matcher matcher;
            if (paragraphInfo.getText().contains("\u76ee") && paragraphInfo.getText().contains("\u5f55")) {
                result.put("start", paragraphInfo.getIndex());
            }
            if ((matcher = pattern.matcher(paragraphInfo.getText().substring(0, Math.min(5, paragraphInfo.getText().length())))).find()) {
                if (matcher.group().substring(0, 1).compareTo(tempStr) >= 0) {
                    tempStr = matcher.group().substring(0, 1);
                    if (hasNext > 5) {
                        if (result.containsKey("start")) continue;
                        result.put("start", paragraphInfo.getIndex() - 1);
                        continue;
                    }
                    ++hasNext;
                    continue;
                }
                if (hasNext > 5) {
                    result.put("end", paragraphInfo.getIndex());
                    break;
                }
                ++hasNext;
                continue;
            }
            if (hasNext > 5) {
                result.put("end", paragraphInfo.getIndex());
                break;
            }
            hasNext = 0;
        }
        if (result.containsKey("start") && result.containsKey("end")) {
            return result;
        }
        result.put("start", 0);
        result.put("end", 0);
        return result;
    }

    public static int searchPIndex(ContrastFileInfoDto fileInfoDto, int index, boolean isLeft) {
        List<WordParagraphInfo> compareParagraphs;
        List<WordParagraphInfo> baseParagraphs;
        int result = -1;
        if (index < 0) {
            return result;
        }
        FileBytesInfo leftFileInfo = fileInfoDto.getLeftFileInfo();
        FileBytesInfo rightFileInfo = fileInfoDto.getRightFileInfo();
        if (isLeft) {
            baseParagraphs = ReadWordUtil.getWordInfo(leftFileInfo).getPInfoList();
            compareParagraphs = ReadWordUtil.getWordInfo(rightFileInfo).getPInfoList();
        } else {
            baseParagraphs = ReadWordUtil.getWordInfo(rightFileInfo).getPInfoList();
            compareParagraphs = ReadWordUtil.getWordInfo(leftFileInfo).getPInfoList();
        }
        for (WordParagraphInfo info : compareParagraphs) {
            if (index >= baseParagraphs.size()) {
                index = baseParagraphs.size() - 1;
                continue;
            }
            if (!CompareUtil.matchParagraph(info.getText(), baseParagraphs.get(index).getText())) continue;
            result = info.getIndex();
        }
        return result;
    }

    public static int relocate(String allText, String targetText, int index) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        int tempIndex = allText.indexOf(targetText);
        while (tempIndex < allText.length() && tempIndex != -1) {
            indices.add(tempIndex);
            tempIndex = allText.indexOf(targetText, tempIndex + 1);
        }
        if (indices.size() < 1) {
            return index;
        }
        if (indices.size() == 1) {
            return (Integer)indices.get(0);
        }
        int result = (Integer)indices.get(0);
        int min = Math.abs((Integer)indices.get(0) - index);
        for (int i = 1; i < indices.size(); ++i) {
            result = min > Math.abs((Integer)indices.get(i) - index) ? result : (Integer)indices.get(i);
        }
        return result;
    }

    public static List<ContrastResult> dealTableResult(List<ContrastResult> contrastResultList) {
        ArrayList results = new ArrayList();
        HashMap locationMap = new HashMap();
        for (int i = 0; i < contrastResultList.size(); ++i) {
            ContrastResult leftResult = contrastResultList.get(i);
        }
        return contrastResultList;
    }
}

