/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.doccontrast.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.user.entity.SysUsersVo;
import com.jxdinfo.idp.common.util.user.UserUtils;
import com.jxdinfo.idp.common.util.uuid.IdUtils;
import com.jxdinfo.idp.icpac.doccontrast.entity.ContrastTask;
import com.jxdinfo.idp.icpac.doccontrast.entity.dto.ContrastTaskDto;
import com.jxdinfo.idp.icpac.doccontrast.entity.query.ContrastTaskQuery;
import com.jxdinfo.idp.icpac.doccontrast.entity.query.DocContrastQuery;
import com.jxdinfo.idp.icpac.doccontrast.mapper.ContrastTaskMapper;
import com.jxdinfo.idp.icpac.doccontrast.service.IContrastTaskService;
import com.jxdinfo.idp.icpac.doccontrast.service.impl.FileInfoServiceImpl;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContrastTaskServiceImpl
extends ServiceImpl<ContrastTaskMapper, ContrastTask>
implements IContrastTaskService {
    @Autowired
    private ContrastTaskMapper mapper;
    @Autowired
    private FileInfoServiceImpl fileInfoService;

    @Override
    public Page<ContrastTaskDto> getPageList(ContrastTaskQuery query) {
        Page<ContrastTaskDto> page = query.getPage(ContrastTaskDto.class);
        if (query.getEndTime() != null) {
            GregorianCalendar endTime = new GregorianCalendar();
            endTime.setTime(query.getEndTime());
            ((Calendar)endTime).add(5, 1);
            query.setEndTime(endTime.getTime());
        }
        SysUsersVo user = UserUtils.getLoginUser();
        String userAccount = "";
        if (user != null && !"kaifa".equals(user.getUserAccount())) {
            userAccount = user.getUserAccount();
        }
        query.setUserAccount(userAccount);
        return this.mapper.getPageList(page, query);
    }

    @Override
    public ContrastTaskDto getById(ContrastTaskQuery query) {
        return this.mapper.getById(query);
    }

    @Override
    public String insert(ContrastTask task) {
        task.setId(IdUtils.simpleUUID());
        SysUsersVo user = UserUtils.getLoginUser();
        if (user != null) {
            task.setCreator(user.getUserAccount());
        }
        task.setCreateTime(LocalDateTime.now());
        this.save(task);
        return task.getId();
    }

    @Override
    public void delete(DocContrastQuery query) throws IOException {
        List<String> ids = Arrays.asList(query.getTaskId().split(","));
        if (ids.isEmpty()) {
            ids.add(query.getTaskId());
        }
        for (String id : ids) {
            ContrastTaskQuery tempQuery = new ContrastTaskQuery();
            tempQuery.setId(id);
            ContrastTaskDto dto = this.mapper.getById(tempQuery);
            this.fileInfoService.remove(dto.getLeftFileId());
            this.fileInfoService.remove(dto.getRightFileId());
        }
        this.mapper.deleteResultById(ids);
        this.mapper.deleteById(ids);
    }
}

