/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.common.util;

import com.jxdinfo.idp.common.util.SpringUtils;
import com.jxdinfo.idp.dio.service.FileService;
import com.jxdinfo.idp.icpac.common.entity.FileBytesInfo;
import com.jxdinfo.idp.icpac.feign.DocContrastFeign;
import com.jxdinfo.idp.interf.DocService;
import com.jxdinfo.idp.interf.FileSystemInterface;
import com.jxdinfo.idp.po.DocFilePo;
import com.jxdinfo.idp.po.FileInfoPo;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.annotation.PostConstruct;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
@DependsOn(value={"SpringUtils1"})
public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);
    private static FileService fileService;
    private static FileSystemInterface fileSystemInterface;
    private static DocService docService;
    private static DocContrastFeign docContrastFeign;

    @PostConstruct
    public void setFactory() {
        fileService = (FileService)SpringUtils.getBean(FileService.class);
    }

    @PostConstruct
    public void setInfoService() {
        fileSystemInterface = (FileSystemInterface)SpringUtils.getBean(FileSystemInterface.class);
    }

    @PostConstruct
    public void setDocService() {
        docService = (DocService)SpringUtils.getBean(DocService.class);
    }

    public void setDocContrastFeign() {
        docContrastFeign = (DocContrastFeign)SpringUtils.getBean(DocContrastFeign.class);
    }

    public static FileBytesInfo getBytesInfo(Long fileId) {
        FileBytesInfo docFileInfo = new FileBytesInfo();
        try {
            FileInfoPo docInfo = (FileInfoPo)docService.getById((Serializable)fileId);
            DocFilePo fileInfo = (DocFilePo)fileSystemInterface.getById((Serializable)fileId);
            docFileInfo.setFileBytes(fileService.download(fileInfo.getContrastPath()));
            docFileInfo.setFileName(fileInfo.getFileName());
            docFileInfo.setFileFormat(docInfo.getFormat());
            docFileInfo.setFilePath(fileInfo.getFilePath());
            docFileInfo.setContrastPath(fileInfo.getContrastPath());
        }
        catch (Exception e) {
            return null;
        }
        return docFileInfo;
    }

    public static byte[] getByPath(String path) throws Exception {
        return fileService.download(path);
    }

    public static String saveFile(MultipartFile file, String path) throws Exception {
        return "1";
    }

    public static String saveFile(String filename, String path) throws Exception {
        return "1";
    }

    public static String copyFile(InputStream file, String fileName, String path) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(path);
        IOUtils.copy((InputStream)file, (OutputStream)outputStream);
        IOUtils.close((Closeable)outputStream);
        return path;
    }
}

