/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.common.ocr.handler.parser;

import cn.hutool.core.util.IdUtil;
import cn.hutool.json.JSONException;
import cn.hutool.json.JSONObject;
import com.jxdinfo.idp.common.enums.ocr.OcrTemplateType;
import com.jxdinfo.idp.icpac.common.entity.PdfOcrResponse;
import com.jxdinfo.idp.icpac.common.entity.po.ExtractElement;
import com.jxdinfo.idp.icpac.common.ocr.entity.config.extract.text.TextConfig;
import com.jxdinfo.idp.icpac.common.ocr.handler.postprocess.impl.TextPostProcessHandler;
import com.jxdinfo.idp.icpac.doccontrast.entity.po.ConfigDocElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextParser {
    private static final Logger log = LoggerFactory.getLogger(TextParser.class);
    private PdfOcrResponse ocrResponse;
    private Long docId;
    private String docFormat;
    private String elementType;

    public TextParser(PdfOcrResponse ocrResponse, String docFormat, String elementType) {
        this.ocrResponse = ocrResponse;
        this.docId = ocrResponse.getDocId();
        this.docFormat = docFormat;
        this.elementType = elementType;
    }

    public List<ExtractElement> parse(List<ConfigDocElement> configDocElements) {
        Map<String, String> textResult = this.ocrResponse.getText();
        String ocrTemplateType = this.ocrResponse.getOcrTemplateType();
        ArrayList<ExtractElement> elementResult = new ArrayList<ExtractElement>();
        if (OcrTemplateType.NORMAL_TYPE.value().equals(ocrTemplateType)) {
            for (Map.Entry<String, String> entry : textResult.entrySet()) {
                ExtractElement extractElement = new ExtractElement();
                extractElement.setId(IdUtil.fastSimpleUUID());
                extractElement.setDocId(this.docId);
                extractElement.setDocFormat(this.docFormat);
                extractElement.setElementType(this.elementType);
                extractElement.setDocElementId(IdUtil.simpleUUID());
                extractElement.setElementText(entry.getValue());
                extractElement.setDocElementId(entry.getKey());
                elementResult.add(extractElement);
            }
        } else {
            ArrayList<TextConfig> textConfig = new ArrayList<TextConfig>();
            for (ConfigDocElement element : configDocElements) {
                if (!element.getElementType().equals("text") && !element.getElementType().equals("number") && !element.getElementType().equals("date")) continue;
                TextConfig textConfigs = new TextConfig();
                textConfigs.setKey(element.getElementName());
                try {
                    JSONObject jsonObject = new JSONObject((Object)element.getExtractRule());
                    textConfigs.setReplace((Boolean)jsonObject.get((Object)"replace"));
                    textConfigs.setText_pattern((List)jsonObject.get((Object)"text_pattern"));
                    textConfigs.setText_process((String)jsonObject.get((Object)"text_process"));
                    textConfig.add(textConfigs);
                }
                catch (JSONException e) {
                    log.error("\u540e\u5904\u7406\u83b7\u53d6\u914d\u7f6e\u5bf9\u8c61\u5931\u8d25");
                }
                catch (NullPointerException e) {
                    log.error("\u540e\u5904\u7406\u83b7\u53d6\u914d\u7f6e\u5bf9\u8c61\u5c5e\u6027\u5931\u8d25");
                }
            }
            for (TextConfig config : textConfig) {
                String key = config.getKey();
                String value = textResult.get(key);
                if (StringUtils.isBlank((CharSequence)value)) continue;
                TextPostProcessHandler handler = config.getPostProcessHandler(value);
                value = handler.process();
                ExtractElement extractElement = new ExtractElement();
                extractElement.setId(IdUtil.fastSimpleUUID());
                extractElement.setDocId(this.docId);
                extractElement.setDocFormat(this.docFormat);
                extractElement.setElementType(this.elementType);
                extractElement.setDocElementId(key);
                extractElement.setElementText(value);
                elementResult.add(extractElement);
            }
        }
        return elementResult;
    }
}

