/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.common.ocr.handler.parser;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.jxdinfo.idp.extract.domain.extractor.ocrconfigxtract.SingleSealInfo;
import com.jxdinfo.idp.icpac.common.entity.PdfOcrResponse;
import com.jxdinfo.idp.icpac.common.entity.po.ExtractElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;

public class SealParser {
    private PdfOcrResponse ocrResponse;
    private Long docId;
    private String docFormat;
    private String elementType;

    public SealParser(PdfOcrResponse ocrResponse, String docFormat, String elementType) {
        this.ocrResponse = ocrResponse;
        this.docId = ocrResponse.getDocId();
        this.docFormat = docFormat;
        this.elementType = elementType;
    }

    public List<ExtractElement> parse() {
        Map<String, SingleSealInfo> seal = this.ocrResponse.getSeal();
        ArrayList<ExtractElement> elementResults = new ArrayList<ExtractElement>();
        for (Map.Entry<String, SingleSealInfo> entry : seal.entrySet()) {
            String key = entry.getKey();
            SingleSealInfo sealInfo = seal.get(key);
            ExtractElement extractElement = new ExtractElement();
            extractElement.setId(IdUtil.fastSimpleUUID());
            extractElement.setDocId(this.docId);
            extractElement.setDocFormat(this.docFormat);
            extractElement.setElementType(this.elementType);
            extractElement.setDocElementId(key);
            extractElement.setElementText(this.getTransElement(sealInfo));
            elementResults.add(extractElement);
        }
        return elementResults;
    }

    private String getTransElement(SingleSealInfo sealInfo) {
        if (ObjectUtils.isEmpty((Object)sealInfo)) {
            return JSON.toJSONString((Object)new SingleSealInfo());
        }
        return JSON.toJSONString((Object)sealInfo);
    }
}

