/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.similaritycompare.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.util.user.UserUtils;
import com.jxdinfo.idp.icpac.similaritycompare.entity.po.SimilarityTask;
import com.jxdinfo.idp.icpac.similaritycompare.entity.query.SimilarityTaskQuery;
import com.jxdinfo.idp.icpac.similaritycompare.entity.vo.SimilarityTaskVO;
import com.jxdinfo.idp.icpac.similaritycompare.mapper.SimilarityTaskMapper;
import com.jxdinfo.idp.icpac.similaritycompare.service.ISimilarityTaskService;
import com.jxdinfo.idp.interf.DocService;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SimilarityTaskServiceImpl
extends ServiceImpl<SimilarityTaskMapper, SimilarityTask>
implements ISimilarityTaskService {
    @Resource
    private SimilarityTaskMapper taskMapper;
    @Autowired
    private DocService iDocService;

    @Override
    public Page<SimilarityTaskVO> getPageList(SimilarityTaskQuery query) {
        Page<SimilarityTaskVO> page = query.getPage(SimilarityTaskVO.class);
        if (query.getEndTime() != null) {
            GregorianCalendar endTime = new GregorianCalendar();
            endTime.setTime(query.getEndTime());
            ((Calendar)endTime).add(5, 1);
            query.setEndTime(endTime.getTime());
        }
        String userAccount = String.valueOf(UserUtils.getLoginUserId());
        query.setUserAccount(userAccount);
        Page<SimilarityTaskVO> page1 = this.taskMapper.getPageList(page, query);
        for (SimilarityTaskVO record : page1.getRecords()) {
            Integer rightSize;
            DecimalFormat decimalFormat = new DecimalFormat("#.##");
            String[] Units2 = new String[]{"BYTE", "KB", "MB", "GB", "TB"};
            Integer leftSize = record.getLeftFileSize();
            if (leftSize != null) {
                Double leftSizeD = (double)leftSize;
                int leftPoint = 0;
                while (leftSizeD / 1024.0 > 1.0) {
                    leftSizeD = leftSizeD / 1024.0;
                    ++leftPoint;
                }
                record.setLeftUnit(Units2[leftPoint]);
                record.setLeftFileSize((int)Double.parseDouble(decimalFormat.format(leftSizeD)));
            }
            if ((rightSize = record.getRightFileSize()) == null) continue;
            Double rightSizeD = (double)rightSize;
            int rightPoint = 0;
            while (rightSizeD / 1024.0 > 1.0) {
                rightSizeD = rightSizeD / 1024.0;
                ++rightPoint;
            }
            record.setRightUnit(Units2[rightPoint]);
            record.setRightFileSize((int)Double.parseDouble(decimalFormat.format(rightSizeD)));
        }
        return page1;
    }

    @Override
    public boolean removeTaskFile(String ids) {
        List<String> taskIds = Arrays.asList(ids.split(","));
        HashSet<String> fileIds = new HashSet<String>();
        if (!taskIds.isEmpty()) {
            List tasks = this.taskMapper.selectBatchIds(taskIds);
            for (SimilarityTask similarityTask : tasks) {
                fileIds.add(similarityTask.getLeftFileId());
                fileIds.add(similarityTask.getRightFileId());
            }
        }
        List<Object> fileIdList = new ArrayList(fileIds);
        fileIdList = fileIdList.stream().filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        for (String string : fileIdList) {
            try {
                this.iDocService.deleteFileInfo(string);
            }
            catch (Exception e) {
                this.log.error("\u6587\u4ef6:" + string + "\u5220\u9664\u5931\u8d25");
            }
        }
        return false;
    }
}

