/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.multisimilaritycompare.utils.structure;

import com.jxdinfo.idp.icpac.common.entity.FileBytesInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordParagraphInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordStructureInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WordStructureUtil {
    private static final Logger log = LoggerFactory.getLogger(WordStructureUtil.class);
    protected static final String TABLE_SPECIAL_CHARACTERS = "[\u0007|\\t|\\n|\u00a0+]";

    public WordStructureInfo getWordInfo(FileBytesInfo fileInfo) {
        return this.getWordInfo(new ByteArrayInputStream(fileInfo.getFileBytes()), fileInfo.getFileName());
    }

    public abstract WordStructureInfo getWordInfo(InputStream var1, String var2);

    protected String handleTitle(String text) {
        return text.trim();
    }

    protected String textInside(Integer beginRow, Integer endRow, Map<Integer, WordParagraphInfo> textMap) {
        if (ObjectUtils.isEmpty(textMap)) {
            return "";
        }
        StringBuilder tmp = new StringBuilder();
        for (int i = beginRow + 1; i < endRow; ++i) {
            WordParagraphInfo pInfo = textMap.get(i);
            if (pInfo == null) continue;
            tmp.append(pInfo.getText());
        }
        return tmp.toString().trim();
    }
}

