/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.multisimilaritycompare.utils.structure;

import cn.hutool.core.collection.CollectionUtil;
import com.jxdinfo.idp.common.enums.DocRegularEnum;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.TablePPos;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordCellInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordChapterInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordFooter;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordHeader;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordParagraphInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordRowInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordStructureInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordTableInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.utils.structure.WordStructureUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.usermodel.CharacterRun;
import org.apache.poi.hwpf.usermodel.HeaderStories;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.hwpf.usermodel.Table;
import org.apache.poi.hwpf.usermodel.TableCell;
import org.apache.poi.hwpf.usermodel.TableIterator;
import org.apache.poi.hwpf.usermodel.TableRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocStructureUtil
extends WordStructureUtil {
    private static final Logger log = LoggerFactory.getLogger(DocStructureUtil.class);

    @Override
    public WordStructureInfo getWordInfo(InputStream is, String fileName) {
        WordStructureInfo result = new WordStructureInfo();
        try (HWPFDocument document = new HWPFDocument(is);){
            ArrayList<WordChapterInfo> chapterInfos = new ArrayList<WordChapterInfo>();
            result.setChapterInfos(chapterInfos);
            ArrayList<WordParagraphInfo> pInfos = new ArrayList<WordParagraphInfo>();
            result.setPInfoList(pInfos);
            result.setTableInfos(this.getTables(document));
            Range range = document.getRange();
            result.setWordHeaders(this.getHeaders(document));
            result.setWordFooters(this.getFooters(document));
            HashMap<Integer, WordParagraphInfo> pMap = new HashMap<Integer, WordParagraphInfo>();
            for (int i = 0; i < range.numParagraphs(); ++i) {
                Paragraph p = range.getParagraph(i);
                int titleLevel = p.getLvl();
                String text = this.getMarkedUnDeleted(p);
                if (p.isInTable()) continue;
                WordParagraphInfo pInfo = new WordParagraphInfo();
                pInfo.setIndex(i);
                text = DocRegularEnum.matchCatalog((String)text);
                pInfo.setText(text);
                pInfos.add(pInfo);
                if (StringUtils.isNotEmpty((CharSequence)text)) {
                    pMap.put(i, pInfo);
                }
                if (titleLevel == 9 || !StringUtils.isNotEmpty((CharSequence)text.trim())) continue;
                WordChapterInfo chapterInfo = new WordChapterInfo();
                chapterInfo.setTitleName(this.handleTitle(text));
                chapterInfo.setTitleLevel(titleLevel);
                chapterInfo.setStartRow(i);
                chapterInfos.add(chapterInfo);
            }
            this.assembleChapter(chapterInfos, pMap, pInfos);
        }
        catch (IOException e) {
            log.error("doc\u6587\u6863+\u3010" + fileName + "\u3011\u52a0\u8f7d\u5f02\u5e38\uff01");
        }
        return result;
    }

    private List<WordTableInfo> getTables(HWPFDocument doc) {
        ArrayList<WordTableInfo> result = new ArrayList<WordTableInfo>();
        Range range = doc.getRange();
        TableIterator iterator = new TableIterator(range);
        List<TablePPos> tablePPos = this.tablePos(range);
        int tableIndex = 0;
        while (iterator.hasNext()) {
            WordTableInfo tableInfo = new WordTableInfo();
            tableInfo.setLastPIndex(tableIndex - 1);
            tableInfo.setNextPIndex(tableIndex + 1);
            tableInfo.setPIndex(tablePPos.get(tableIndex).getTableStartP());
            tableInfo.setIndex(tableIndex++);
            Table table = iterator.next();
            ArrayList<WordRowInfo> rowInfos = new ArrayList<WordRowInfo>();
            tableInfo.setRows(rowInfos);
            result.add(tableInfo);
            for (int i = 0; i < table.numRows(); ++i) {
                WordRowInfo rowInfo = new WordRowInfo();
                rowInfo.setIndex(i);
                ArrayList<WordCellInfo> cellInfos = new ArrayList<WordCellInfo>();
                rowInfo.setCells(cellInfos);
                rowInfos.add(rowInfo);
                TableRow row = table.getRow(i);
                for (int j = 0; j < row.numCells(); ++j) {
                    WordCellInfo cellInfo = new WordCellInfo();
                    cellInfo.setIndex(j);
                    ArrayList<WordParagraphInfo> paragraphInfos = new ArrayList<WordParagraphInfo>();
                    cellInfo.setParagraphs(paragraphInfos);
                    cellInfos.add(cellInfo);
                    TableCell cell = row.getCell(j);
                    cellInfo.setText(cell.text().replaceAll("[\u0007|\\t|\\n|\u00a0+]", "").trim());
                    for (int k = 0; k < cell.numParagraphs(); ++k) {
                        Paragraph paragraph = cell.getParagraph(k);
                        WordParagraphInfo paragraphInfo = new WordParagraphInfo();
                        paragraphInfo.setIndex(k);
                        String text = paragraph.text();
                        paragraphInfo.setText(text.replaceAll("[\u0007|\\t|\\n|\u00a0+]", "").trim());
                        paragraphInfos.add(paragraphInfo);
                    }
                }
            }
        }
        return result;
    }

    private List<WordFooter> getFooters(HWPFDocument doc) {
        ArrayList<WordFooter> result = new ArrayList<WordFooter>();
        HeaderStories headerStories = new HeaderStories(doc);
        Range range = doc.getRange();
        int numSections = range.numSections();
        int pageCount = 0;
        for (int s = 0; s < numSections; ++s) {
            pageCount += range.getSection(s).numParagraphs();
        }
        for (int i = 0; i < pageCount; ++i) {
            WordFooter wordFooter = new WordFooter();
            wordFooter.setIndex(i);
            wordFooter.setText(headerStories.getFooter(i));
            result.add(wordFooter);
        }
        return result;
    }

    private List<WordHeader> getHeaders(HWPFDocument doc) {
        ArrayList<WordHeader> result = new ArrayList<WordHeader>();
        HeaderStories headerStories = new HeaderStories(doc);
        Range range = doc.getRange();
        int numSections = range.numSections();
        int pageCount = 0;
        for (int s = 0; s < numSections; ++s) {
            pageCount += range.getSection(s).numParagraphs();
        }
        for (int i = 0; i < pageCount; ++i) {
            WordHeader wordHeader = new WordHeader();
            wordHeader.setIndex(i);
            wordHeader.setText(headerStories.getHeader(i));
            result.add(wordHeader);
        }
        return result;
    }

    private void assembleChapter(List<WordChapterInfo> chapterInfos, Map<Integer, WordParagraphInfo> levelPMap, List<WordParagraphInfo> paragraphInfos) {
        int PEndRow = paragraphInfos.get(paragraphInfos.size() - 1).getIndex() + 1;
        block0: for (int i = 0; i < chapterInfos.size() - 1; ++i) {
            for (int j = i + 1; j < chapterInfos.size(); ++j) {
                WordChapterInfo current = chapterInfos.get(i);
                WordChapterInfo next = chapterInfos.get(j);
                if (next.getTitleLevel() <= current.getTitleLevel()) {
                    current.setEndRow(next.getStartRow());
                    continue block0;
                }
                if (j != chapterInfos.size() - 1) continue;
                current.setEndRow(PEndRow);
                continue block0;
            }
        }
        if (CollectionUtil.isNotEmpty(chapterInfos)) {
            chapterInfos.get(chapterInfos.size() - 1).setEndRow(PEndRow);
        }
        for (WordChapterInfo content : chapterInfos) {
            content.setPInfoList(new ArrayList<WordParagraphInfo>());
            int end = content.getEndRow();
            for (int i = content.getStartRow().intValue(); i < end; ++i) {
                WordParagraphInfo paragraphInfo = levelPMap.get(i);
                if (paragraphInfo == null) continue;
                content.getPInfoList().add(paragraphInfo);
            }
            content.setText(this.textInside(content.getStartRow(), content.getEndRow(), levelPMap));
        }
    }

    private List<TablePPos> tablePos(Range range) {
        ArrayList<TablePPos> tablePPos = new ArrayList<TablePPos>();
        int index = 0;
        for (int i = 0; i < range.numParagraphs(); ++i) {
            Paragraph paragraph = range.getParagraph(i);
            TablePPos pPos = new TablePPos();
            if (!paragraph.isInTable() || i != 0 && range.getParagraph(i - 1).isInTable()) continue;
            pPos.setTableStartP(i);
            pPos.setTableEndP(i + range.getTable(paragraph).numParagraphs());
            pPos.setTablePos(index);
            ++index;
            tablePPos.add(pPos);
        }
        return tablePPos;
    }

    private List<WordTableInfo> getTablePIndex(Range range) {
        ArrayList<WordTableInfo> tableInfos = new ArrayList<WordTableInfo>();
        boolean index = false;
        for (int i = 0; i < range.numParagraphs(); ++i) {
            Paragraph paragraph = range.getParagraph(i);
            WordTableInfo tableInfo = new WordTableInfo();
            if (paragraph.isInTable() && i != 0 && range.getParagraph(i - 1).isInTable()) continue;
        }
        return tableInfos;
    }

    private String getMarkedUnDeleted(Paragraph p) {
        StringBuilder pText = new StringBuilder();
        for (int i = 0; i < p.numCharacterRuns(); ++i) {
            CharacterRun run = p.getCharacterRun(i);
            if (run.isMarkedDeleted()) continue;
            pText.append(run.text());
        }
        return pText.toString();
    }

    public static void main(String[] args) throws FileNotFoundException {
        FileInputStream inputStream = new FileInputStream("C:\\Users\\linkunpeng\\Desktop\\\u667a\u80fd\u9884\u5ba1\\\u6d4b\u8bd5\u6587\u6863\\bug\u6d4b\u8bd5\u6587\u4ef6\\\u76ee\u5f55\u4e71\u78013.doc");
        DocStructureUtil util = new DocStructureUtil();
        WordStructureInfo wordInfo = util.getWordInfo(inputStream, "\u76ee\u5f55\u4e71\u78013.doc");
        for (WordParagraphInfo pInfo : wordInfo.getPInfoList()) {
            log.info(pInfo.getText());
        }
    }
}

