/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.multisimilaritycompare.utils;

import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.icpac.common.entity.FileBytesInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordStructureInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.utils.structure.DocStructureUtil;
import com.jxdinfo.idp.icpac.multisimilaritycompare.utils.structure.DocxStructureUtil;
import com.jxdinfo.idp.icpac.multisimilaritycompare.utils.structure.WordStructureUtil;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadWordUtil {
    private static final Logger log = LoggerFactory.getLogger(ReadWordUtil.class);

    public static WordStructureInfo getWordInfo(FileBytesInfo fileInfo) {
        WordStructureUtil util;
        if ("doc".equals(fileInfo.getFileFormat()) || "wps".equals(fileInfo.getFileFormat())) {
            util = new DocStructureUtil();
        } else if ("docx".equals(fileInfo.getFileFormat())) {
            util = new DocxStructureUtil();
        } else {
            throw new BusinessException("\u4e0d\u652f\u6301\u6587\u6863\u7c7b\u578b\uff01");
        }
        return util.getWordInfo(fileInfo);
    }

    public static WordStructureInfo getWordInfo(InputStream is, String fileName) {
        WordStructureUtil util;
        if (fileName.endsWith(".doc") || fileName.endsWith(".wps")) {
            util = new DocStructureUtil();
        } else if (fileName.endsWith(".docx")) {
            util = new DocxStructureUtil();
        } else {
            throw new BusinessException("\u4e0d\u652f\u6301\u6587\u6863\u7c7b\u578b\uff01");
        }
        return ((WordStructureUtil)util).getWordInfo(is, fileName);
    }

    public static Boolean isDocx(FileBytesInfo fileInfo) {
        return fileInfo.getFileName().endsWith(".docx");
    }
}

