/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.multisimilaritycompare.utils;

import cn.hutool.core.collection.CollectionUtil;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.icpac.common.entity.FileBytesInfo;
import com.jxdinfo.idp.icpac.common.entity.TabHead;
import com.jxdinfo.idp.icpac.common.entity.TableInfo;
import com.jxdinfo.idp.icpac.common.util.entity.excel.CellData;
import com.jxdinfo.idp.icpac.docexamine.entity.docconfig.extractsetting.ExtractSettings;
import com.jxdinfo.idp.icpac.docexamine.entity.location.SheetContent;
import com.jxdinfo.idp.icpac.docexamine.executor.imp.AbstractExtractor;
import com.jxdinfo.idp.icpac.docexamine.executor.imp.excelelementextractor.ElementExcelExtractorFactory;
import com.monitorjbl.xlsx.StreamingReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class ReadExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(ReadExcelUtil.class);

    public static CellData getCellData(ExtractSettings extractRule, String subtaskId) {
        Map<String, Object> maps;
        CellData resData = null;
        String sheetName = extractRule.getExtractRange();
        List<TabHead> tabHeads = extractRule.getTabHeads();
        String tabName = extractRule.getTabTitle();
        List<Object> cellDatas = new ArrayList();
        if (!StringUtils.isEmpty((String)sheetName)) {
            maps = ElementExcelExtractorFactory.excelSheetDataMaps.get(subtaskId);
            if (maps.get(sheetName) != null) {
                cellDatas = maps.get(sheetName).getCellList();
                for (CellData cellData : cellDatas) {
                    cellData.setSheetName(((SheetContent)maps.get(sheetName)).getSheetName());
                }
            } else {
                log.error("\u8981\u7d20\u3010" + sheetName + "\u3011\u63d0\u53d6\u5f02\u5e38");
            }
        }
        if (StringUtils.isEmpty((String)tabName) || "\u5168\u6587".equals(tabName)) {
            maps = ElementExcelExtractorFactory.excelSheetDataMaps.get(subtaskId);
            if (maps.get(sheetName) != null) {
                cellDatas = ((SheetContent)maps.get(sheetName)).getCellList();
                for (CellData cellData : cellDatas) {
                    cellData.setSheetName(((SheetContent)maps.get(sheetName)).getSheetName());
                }
            } else {
                log.error("\u8981\u7d20\u3010" + sheetName + "\u3011\u63d0\u53d6\u5f02\u5e38");
            }
        } else {
            maps = ElementExcelExtractorFactory.excelTableDataMaps.get(subtaskId);
            for (Map.Entry<String, Object> entry : maps.entrySet()) {
                for (TabHead tabHead : tabHeads) {
                    if (!entry.getKey().equals(tabHead.getHeadName())) continue;
                    CellData dataList = (CellData)entry.getValue();
                    dataList.setSheetName(tabName);
                    cellDatas.add(dataList);
                }
            }
        }
        if (cellDatas.size() == 0) {
            return resData;
        }
        if (extractRule.getMatchStrategy().equals("2")) {
            Collections.reverse(cellDatas);
        }
        if (extractRule.getCondition() != null && extractRule.getTextContent() != null) {
            for (CellData cellData : cellDatas) {
                if ("\u76f8\u7b49".equals(extractRule.getCondition()) && cellData.getCellData().equals(extractRule.getTextContent()) || "\u5305\u542b".equals(extractRule.getCondition()) && cellData.getCellData().contains(extractRule.getTextContent())) {
                    resData = cellData;
                }
                if (resData == null) continue;
                int n = Integer.parseInt(extractRule.getLocation().split(",")[0]);
                int y = Integer.parseInt(extractRule.getLocation().split(",")[1]);
                if (extractRule.getLocation() != null && n != 0 || y != 0) {
                    int i;
                    Integer rowIndex = resData.getRowIndex();
                    Integer lineIndex = resData.getColumnIndex();
                    for (i = 0; i < Math.abs(n); ++i) {
                        if (resData.getIsMerged() != null && resData.getIsMerged().booleanValue()) {
                            if (n > 0) {
                                lineIndex = resData.getMergedRegion().getLastColumn() + 1;
                            } else if (n < 0) {
                                lineIndex = resData.getMergedRegion().getFirstColumn() - 1;
                            }
                        } else {
                            lineIndex = n > 0 ? Integer.valueOf(lineIndex + 1) : Integer.valueOf(lineIndex - 1);
                        }
                        resData = ReadExcelUtil.selectRestData(rowIndex, lineIndex, resData.getSheetName(), cellDatas);
                    }
                    for (i = 0; i < Math.abs(y); ++i) {
                        if (resData.getIsMerged() != null && resData.getIsMerged().booleanValue()) {
                            if (y > 0) {
                                rowIndex = resData.getMergedRegion().getLastRow() + 1;
                            } else if (y < 0) {
                                rowIndex = resData.getMergedRegion().getFirstRow() - 1;
                            }
                        } else {
                            rowIndex = y > 0 ? Integer.valueOf(rowIndex + 1) : Integer.valueOf(rowIndex - 1);
                        }
                        resData = ReadExcelUtil.selectRestData(rowIndex, lineIndex, resData.getSheetName(), cellDatas);
                    }
                }
                if (extractRule.getRegulars().size() == 0) break;
                for (String rule : extractRule.getRegulars()) {
                    Pattern regex = Pattern.compile(rule);
                    Matcher matcher = regex.matcher(resData.getCellData());
                    while (matcher.find()) {
                        if (matcher.groupCount() >= 1) {
                            resData.setCellData(matcher.group(1));
                            continue;
                        }
                        resData.setCellData(matcher.group());
                    }
                }
            }
        }
        if (extractRule.getMatchStrategy().equals("2")) {
            Collections.reverse(cellDatas);
        }
        return resData;
    }

    private static void putCol(Map<Integer, Map<String, String>> colMap, Integer index, String key, String value) {
        Map<String, String> col = colMap.get(index);
        if (CollectionUtil.isEmpty(col)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(key, value);
            colMap.put(index, map);
        } else {
            col.put(key, value);
        }
    }

    public static String ITransformation(Integer integer) {
        int pre;
        int len = 0;
        int power = 1;
        for (pre = 0; pre < integer; pre += (power *= 26)) {
            ++len;
        }
        char[] excelNum = new char[len];
        Integer n = integer = Integer.valueOf(integer - (pre - power));
        Integer n2 = integer = Integer.valueOf(integer - 1);
        for (int i = 0; i < len; ++i) {
            excelNum[i] = (char)(integer / (power /= 26) + 65);
            integer = integer % power;
        }
        return String.valueOf(excelNum);
    }

    public static String CTransformation(String s) {
        char[] chars = s.toUpperCase(Locale.ROOT).toCharArray();
        int i = 0;
        for (char c : chars) {
            i = i * 26 + (c - 65 + 1);
        }
        return String.valueOf(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int sheetIndex(FileBytesInfo entity, String sheetName) {
        ByteArrayInputStream in = new ByteArrayInputStream(entity.getFileBytes());
        String fileName = entity.getFileName();
        Workbook wk = null;
        try {
            int sheetNums;
            if (fileName.contains(".xlsx")) {
                wk = StreamingReader.builder().rowCacheSize(100).bufferSize(4096).open((InputStream)in);
            } else if (fileName.contains(".xls")) {
                wk = new HSSFWorkbook((InputStream)in);
            }
            if (wk != null) {
                sheetNums = wk.getNumberOfSheets();
                for (int i = 0; i < sheetNums; ++i) {
                    String wkSheetName = wk.getSheetName(i);
                    if (!wkSheetName.equals(sheetName)) continue;
                    int n = i;
                    return n;
                }
            }
            sheetNums = -1;
            return sheetNums;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            try {
                if (wk != null) {
                    wk.close();
                }
            }
            catch (IOException e) {
                log.error("excel\u6587\u4ef6\u8bfb\u53d6workbook\u5173\u95ed\u5f02\u5e38\uff1a", (Throwable)e);
            }
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException e) {
                log.error("excel\u6587\u4ef6\u8bfb\u53d6FileInputStream\u5173\u95ed\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
    }

    public static CellData selectRestData(int rowIndex, int lineIndex, String sheetName, List<CellData> cellDatas) {
        CellData resData = new CellData();
        boolean replaceFlag = false;
        for (CellData newCellData : cellDatas) {
            if (!newCellData.getRowIndex().equals(rowIndex) || !newCellData.getColumnIndex().equals(lineIndex) || !newCellData.getSheetName().equals(sheetName)) continue;
            resData = newCellData;
            replaceFlag = true;
            break;
        }
        if (!replaceFlag) {
            CellData blankData = new CellData();
            blankData.setCellData("");
            blankData.setColumnIndex(lineIndex);
            blankData.setRowIndex(rowIndex);
            blankData.setSheetName(sheetName);
            resData = blankData;
        }
        return resData;
    }

    public static TableInfo getExtractDatas(ExtractSettings tableRule, String subtaskId) {
        TableInfo tableInfo = new TableInfo();
        Map<String, SheetContent> map = ElementExcelExtractorFactory.excelSheetDataMaps.get(subtaskId);
        List<CellData> cellDataList = map.get(tableRule.getExtractRange()).getCellList();
        FileBytesInfo docFileInfo = AbstractExtractor.docFileInfoMap.get(subtaskId);
        tableInfo.setIndex(ReadExcelUtil.sheetIndex(docFileInfo, map.get(tableRule.getExtractRange()).getSheetName()));
        if (CollectionUtil.isEmpty(cellDataList)) {
            throw new BusinessException("\u6ca1\u6709\u5339\u914d\u5230\u8868\u683c");
        }
        for (CellData cellData : cellDataList) {
            cellData.setSheetName(tableRule.getExtractRange());
        }
        ArrayList<CellData> cellDatas = new ArrayList<CellData>(cellDataList);
        ArrayList<TabHead> tabHeades = new ArrayList<TabHead>();
        if (cellDatas.size() == 0) {
            return tableInfo;
        }
        ArrayList<CellData> tabHead = new ArrayList<CellData>();
        Integer maxRowIndex = 1;
        for (CellData cellData : cellDatas) {
            for (TabHead tabHead2 : tableRule.getTabHeads()) {
                if (!cellData.getCellData().equals(tabHead2.getHeadName()) || !StringUtils.isEmpty((String)tabHead2.getHeadKey())) continue;
                tabHead.add(cellData);
                tabHead2.setHeadKey(String.valueOf(cellData.getColumnIndex()));
                tabHeades.add(tabHead2);
                tableInfo.setTabHeads(tabHeades);
            }
            if (cellData.getRowIndex() <= maxRowIndex) continue;
            maxRowIndex = cellData.getRowIndex();
        }
        ArrayList<Map<String, String>> tabData = new ArrayList<Map<String, String>>();
        HashMap<Integer, Map<String, String>> colMap = new HashMap<Integer, Map<String, String>>();
        for (CellData cellData : cellDatas) {
            for (CellData tabHeads : tabHead) {
                if (!cellData.getSheetName().equals(tabHeads.getSheetName()) || !Objects.equals(cellData.getColumnIndex(), tabHeads.getColumnIndex()) || cellData.getRowIndex() <= tabHeads.getRowIndex()) continue;
                CellData cellData1 = new CellData();
                BeanUtils.copyProperties((Object)cellData, (Object)cellData1);
                ReadExcelUtil.putCol(colMap, cellData.getRowIndex(), String.valueOf(cellData.getColumnIndex()), cellData.getCellData());
                HashMap<String, CellData> maps = new HashMap<String, CellData>();
                maps.put(tabHeads.getCellData(), cellData1);
                ElementExcelExtractorFactory.excelTableDataMaps.put(subtaskId, maps);
            }
        }
        tableInfo.setTabData(tabData);
        for (Map.Entry entry : colMap.entrySet()) {
            tabData.add((Map<String, String>)entry.getValue());
        }
        return tableInfo;
    }
}

