/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.multisimilaritycompare.system.third.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.entity.dto.DuplicateCheckChapterDto;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.entity.dto.DuplicateCheckChapterHolder;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.entity.po.DuplicateCheckChapter;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.entity.po.DuplicateCheckDoc;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.entity.query.DuplicateCheckDocQuery;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.service.DuplicateCheckChapterService;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.service.DuplicateCheckDocService;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.service.DuplicateCheckExecutorService;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.service.DuplicateCheckResultService;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.service.DuplicateCheckSentenceService;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.third.service.ThirdDuplicateCheckService;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ThirdDuplicateCheckServiceImpl
implements ThirdDuplicateCheckService {
    @Resource
    private DuplicateCheckDocService docService;
    @Resource
    private DuplicateCheckChapterService chapterService;
    @Resource
    private DuplicateCheckResultService resultService;
    @Resource
    private DuplicateCheckSentenceService sentenceService;
    @Resource
    private DuplicateCheckExecutorService executorService;
    @Value(value="${cc.projectId}")
    private String kyProjectId;

    @Override
    public Page<? extends DuplicateCheckDoc> getOptionalDoc(DuplicateCheckDocQuery docQuery) {
        docQuery.setProjectId(this.kyProjectId);
        return this.docService.listInfo(docQuery);
    }

    @Override
    public void updateUserCustomChapter(DuplicateCheckChapterHolder checkChapterHolder) {
        String belongUser = checkChapterHolder.getBelongUser();
        List<DuplicateCheckChapterDto> chapterList = checkChapterHolder.getChapterList();
        String projectId = checkChapterHolder.getProjectId();
        if (CollectionUtils.isEmpty(chapterList)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)projectId)) {
            return;
        }
        for (DuplicateCheckChapterDto chapterDto : chapterList) {
            if (Objects.equals(projectId, this.kyProjectId) || !Objects.equals(chapterDto.getProjectId(), this.kyProjectId)) continue;
            chapterDto.setProjectId(projectId);
            chapterDto.setId(null);
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(DuplicateCheckChapter::getProjectId, (Object)projectId);
        wrapper.and(k -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)k.isNull(DuplicateCheckChapter::getBelongUser)).or(j -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)j.eq(DuplicateCheckChapter::getBelongUser, (Object)"");
            });
        });
        List systemChapterList = this.chapterService.list((Wrapper)wrapper);
        Set idSet = systemChapterList.stream().map(DuplicateCheckChapter::getId).collect(Collectors.toSet());
        Iterator<DuplicateCheckChapterDto> iter = chapterList.iterator();
        while (iter.hasNext()) {
            DuplicateCheckChapterDto chapterDto = iter.next();
            String id = chapterDto.getId();
            if (idSet.contains(id)) {
                iter.remove();
                continue;
            }
            chapterDto.setBelongUser(belongUser);
        }
        this.chapterService.update(chapterList, projectId, belongUser);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void resetCheckDuplicate(DuplicateCheckDocQuery query) throws Exception {
        String id = query.getId();
        if (StringUtils.isEmpty((CharSequence)id)) {
            return;
        }
        this.sentenceService.deleteByDocIds(Collections.singletonList(id));
        this.resultService.deleteByDocIds(Collections.singletonList(id));
        DuplicateCheckDoc doc = new DuplicateCheckDoc();
        doc.setId(id);
        doc.setTaskStatus("0");
        doc.setMaxSimilarity(0.0);
        doc.setDocSimilarity(0.0);
        doc.setCandidateSentenceNum(0);
        doc.setStartTime(LocalDateTime.now());
        doc.setEndTime(null);
        this.docService.updateById(doc);
        this.executorService.asyncCheckDuplicate(query);
    }
}

