/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.multisimilaritycompare.system.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.entity.dto.DuplicateCheckResultDto;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.entity.po.DuplicateCheckResult;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.entity.query.DuplicateCheckResultQuery;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.mapper.DuplicateCheckResultMapper;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.service.DuplicateCheckResultService;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.service.DuplicateCheckSimilarSentenceService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class DuplicateCheckResultServiceImpl
extends ServiceImpl<DuplicateCheckResultMapper, DuplicateCheckResult>
implements DuplicateCheckResultService {
    @Resource
    private DuplicateCheckResultMapper mapper;
    @Resource
    private DuplicateCheckSimilarSentenceService similarSentenceService;

    @Override
    public List<DuplicateCheckResultDto> list(DuplicateCheckResultQuery query) {
        return this.mapper.list(query);
    }

    @Override
    public Map<String, List<DuplicateCheckResultDto>> listByDocIdsForMap(List<String> uploadDocIds) {
        DuplicateCheckResultQuery query = new DuplicateCheckResultQuery();
        query.setUploadDocIds(uploadDocIds);
        List<DuplicateCheckResultDto> resultList = this.list(query);
        HashMap<String, List<DuplicateCheckResultDto>> doResultIdObjMap = new HashMap<String, List<DuplicateCheckResultDto>>();
        for (DuplicateCheckResultDto resultDto : resultList) {
            doResultIdObjMap.computeIfAbsent(resultDto.getUploadDocId(), k -> new ArrayList()).add(resultDto);
        }
        return doResultIdObjMap;
    }

    @Override
    public void saveBatch(List<DuplicateCheckResultDto> resultList) {
        if (CollectionUtils.isEmpty(resultList)) {
            return;
        }
        List<DuplicateCheckResult> needResultList = DuplicateCheckResultDto.toEntity(resultList);
        this.saveBatch(needResultList);
    }

    @Override
    public void deleteByDocIds(List<String> docIds) {
        if (CollectionUtils.isEmpty(docIds)) {
            return;
        }
        DuplicateCheckResultQuery query = new DuplicateCheckResultQuery();
        query.setUploadDocIds(docIds);
        List<DuplicateCheckResultDto> uploadList = this.mapper.list(query);
        query.setSimilarDocIds(docIds);
        query.setUploadDocIds(null);
        List<DuplicateCheckResultDto> similarList = this.mapper.list(query);
        ArrayList<String> ids = new ArrayList<String>();
        ids.addAll(this.getIds(uploadList));
        ids.addAll(this.getIds(similarList));
        this.removeByIds(ids);
        this.cascadeDelete(ids);
    }

    private void cascadeDelete(List<String> ids) {
        this.similarSentenceService.deleteByResultIds(ids);
    }

    private List<String> getIds(List<? extends DuplicateCheckResult> resultList) {
        return resultList.stream().map(DuplicateCheckResult::getId).collect(Collectors.toList());
    }

    @Override
    public List<DuplicateCheckResultDto> getSimilarityDoc(String docId) {
        return this.mapper.getSimilarityDoc(docId);
    }
}

