/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.multisimilaritycompare.system.service.handler.resulthandler;

import com.jxdinfo.idp.icpac.multisimilaritycompare.system.core.entity.DuplicateCheckInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.core.entity.DuplicateCheckResult;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.core.handler.DuplicateCheckResultHandler;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.core.rmi.resp.DuplicateCheckResponse;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.entity.dto.DuplicateCheckDocDto;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.service.DuplicateCheckDocService;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.utils.DuplicateCheckProgress;
import java.time.LocalDateTime;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifyResultHandler
implements DuplicateCheckResultHandler {
    private static final Logger log = LoggerFactory.getLogger(NotifyResultHandler.class);
    private final DuplicateCheckDocService docService;

    public NotifyResultHandler(DuplicateCheckDocService docService) {
        this.docService = docService;
    }

    @Override
    public void handleResult(DuplicateCheckResult checkResult) throws Exception {
        String docId;
        block11: {
            Object executionResult;
            block10: {
                block9: {
                    docId = null;
                    log.info("\u5f00\u59cb\u67e5\u91cd\u7ed3\u679c\u89e3\u6790");
                    DuplicateCheckInfo checkInfo = checkResult.getInfo();
                    docId = checkInfo.getAttachment("docId", String.class);
                    if (!StringUtils.isEmpty((CharSequence)docId)) break block9;
                    log.error("\u5f53\u524d\u5f85\u67e5\u91cd\u7684\u6587\u6863id\u4e3a\u7a7a\u3002\u65e0\u6cd5\u5904\u7406\u7ed3\u679c");
                    DuplicateCheckProgress.setProgress(docId, 100);
                    log.info("\u67e5\u91cd\u7ed3\u679c\u89e3\u6790\u7ed3\u675f");
                    return;
                }
                executionResult = checkResult.getExecutionResult();
                if (!checkResult.isSuccess()) {
                    log.error("\u5f53\u524d\u6267\u884c\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef");
                    this.updateDocInfo(docId, "2");
                    throw checkResult.getError();
                }
                if (executionResult != null) break block10;
                log.error("\u5f53\u524d\u7684\u67e5\u91cd\u7ed3\u679c\u4e3a\u7a7a\u3002\u3002\u3002\u3002\u3002\u3002");
                this.updateDocInfo(docId, "1");
                DuplicateCheckProgress.setProgress(docId, 100);
                log.info("\u67e5\u91cd\u7ed3\u679c\u89e3\u6790\u7ed3\u675f");
                return;
            }
            if (!(executionResult instanceof DuplicateCheckResponse)) {
                this.updateDocInfo(docId, "2");
                throw new RuntimeException("\u5f53\u524d\u7ed9\u5b9a\u7684\u7ed3\u679c\u7c7b\u578b\uff1a" + executionResult.getClass() + ",\u65e0\u6cd5\u8fdb\u884c\u89e3\u6790");
            }
            DuplicateCheckDocDto docInfo = this.docService.detail(docId);
            if (docInfo != null) break block11;
            DuplicateCheckProgress.setProgress(docId, 100);
            log.info("\u67e5\u91cd\u7ed3\u679c\u89e3\u6790\u7ed3\u675f");
            return;
        }
        try {
            this.updateDocInfo(docId, "1");
        }
        catch (Exception e) {
            try {
                this.updateDocInfo(docId, "2");
                throw e;
            }
            catch (Throwable throwable) {
                DuplicateCheckProgress.setProgress(docId, 100);
                log.info("\u67e5\u91cd\u7ed3\u679c\u89e3\u6790\u7ed3\u675f");
                throw throwable;
            }
        }
        DuplicateCheckProgress.setProgress(docId, 100);
        log.info("\u67e5\u91cd\u7ed3\u679c\u89e3\u6790\u7ed3\u675f");
    }

    private void updateDocInfo(String docId, String taskStatus) {
        DuplicateCheckDocDto docDto = new DuplicateCheckDocDto();
        docDto.setId(docId);
        docDto.setTaskStatus(taskStatus);
        docDto.setKyFlag("");
        docDto.setEndTime(LocalDateTime.now());
        this.docService.updateById(docDto);
    }
}

