/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.multisimilaritycompare.system.core.process.impl;

import com.jxdinfo.idp.icpac.multisimilaritycompare.system.core.dochandler.impl.PdfDocumentHandler;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.core.entity.DuplicateCheckCandidateSentence;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.core.entity.DuplicateCheckInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.core.process.AbstractDuplicateCheckDocProcess;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PdfDuplicateCheckProcess
extends AbstractDuplicateCheckDocProcess {
    private static final Logger log = LoggerFactory.getLogger(PdfDuplicateCheckProcess.class);

    @Override
    public boolean support(DuplicateCheckInfo info) {
        MultipartFile file = info.getFile();
        if (file == null) {
            return false;
        }
        String fileSuffix = info.getFormat();
        return Objects.equals(fileSuffix, "pdf");
    }

    @Override
    protected List<DuplicateCheckCandidateSentence> getCandidateSentence(DuplicateCheckInfo checkInfo) throws Exception {
        PdfDocumentHandler wordDocHandler = new PdfDocumentHandler();
        log.info("\u5f00\u59cb\u83b7\u53d6\u6587\u6863\u7684\u5f85\u67e5\u91cd\u7684\u5019\u9009\u53e5\u5b50.........");
        List<DuplicateCheckCandidateSentence> candidateSentenceList = wordDocHandler.handleDoc(checkInfo);
        if (candidateSentenceList == null) {
            log.info("\u6ca1\u6709\u83b7\u53d6\u4efb\u4f55\u7684\u5e26\u5019\u9009\u53e5\u5b50");
        } else {
            log.info("\u83b7\u53d6\u5e26\u5019\u9009\u53e5\u5b50\u7684\u603b\u6761\u6570\u4e3a\uff1a{}", (Object)candidateSentenceList.size());
        }
        return candidateSentenceList;
    }
}

