/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.multisimilaritycompare.system.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordCatalog;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.entity.dto.DuplicateCheckResultDto;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.entity.dto.DuplicateCheckSentenceDto;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.entity.dto.DuplicateCheckSimilarityInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.entity.po.DuplicateCheckSentence;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.entity.po.DuplicateCheckSimilarSentence;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.entity.query.ContrastQuery;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.service.ContrastService;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/icpac/multiSimilarity/contrast"})
public class ContrastController {
    @Resource
    private ContrastService service;

    @PostMapping(value={"/getStream"})
    public void getStream(HttpServletResponse response, @RequestBody ContrastQuery query) throws Exception {
        this.service.getStream(response, query);
    }

    @GetMapping(value={"/downloadCheckDuplicateReport/{docId}"})
    public void downloadCheckDuplicateReport(@PathVariable(value="docId") String docId) throws IOException {
        this.service.downloadCheckDuplicateReport(docId);
    }

    @PostMapping(value={"/getSimilarityInfo"})
    public ApiResponse<DuplicateCheckSimilarityInfo> getSimilarityInfo(@RequestBody ContrastQuery query) {
        DuplicateCheckSimilarityInfo similarityInfo = this.service.getSimilarityInfo(query);
        return ApiResponse.success((Object)similarityInfo);
    }

    @PostMapping(value={"/getAllSentence"})
    public ApiResponse<List<DuplicateCheckSentenceDto>> getAllSentence(@RequestBody ContrastQuery query) {
        List<DuplicateCheckSentenceDto> sentenceDtoList = this.service.getAllSentence(query);
        return ApiResponse.success(sentenceDtoList);
    }

    @PostMapping(value={"/getContrastResult"})
    public ApiResponse<String> getContrastResult(@RequestBody ContrastQuery query) {
        String result = String.valueOf(this.service.getContrastResult(query));
        return ApiResponse.success((String)result);
    }

    @PostMapping(value={"/getSimilaritySentence"})
    public ApiResponse<Page<? extends DuplicateCheckSimilarSentence>> getSimilaritySentence(@RequestBody ContrastQuery query) {
        Page<? extends DuplicateCheckSimilarSentence> page = this.service.getSimilaritySentence(query);
        return ApiResponse.success(page);
    }

    @GetMapping(value={"/getSimilarityDoc/{docId}"})
    public ApiResponse<List<DuplicateCheckResultDto>> getSimilarityDoc(@PathVariable(value="docId") String docId) {
        return ApiResponse.success(this.service.getSimilarityDoc(docId));
    }

    @PostMapping(value={"/getSentence"})
    public ApiResponse<Page<? extends DuplicateCheckSentence>> getSentence(@RequestBody ContrastQuery query) {
        return ApiResponse.success(this.service.getSentence(query));
    }

    @GetMapping(value={"/getWordCatalogDto/{docId}"})
    public ApiResponse<List<WordCatalog>> getWordCatalogDto(@PathVariable String docId) throws Exception {
        List<WordCatalog> catalog = this.service.getWordCatalogDto(docId);
        return ApiResponse.success(catalog);
    }

    @PostMapping(value={"/getCompareSentence"})
    public ApiResponse<Page<? extends DuplicateCheckSentence>> getCompareSentence(@RequestBody ContrastQuery query) {
        Page<? extends DuplicateCheckSentence> page = this.service.getCompareSentence(query);
        return ApiResponse.success(page);
    }
}

