/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.docexamine.progressbar;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CronConCurrentHashMap<K, V> {
    private static final long serialVersionUID = 7249069246763182397L;
    private ConcurrentHashMap<K, V> concurrentHashMap;
    private ConcurrentHashMap<String, Long> concurrentHashMapClock = new ConcurrentHashMap();
    private long cachLiveTime = 120000L;
    private int cacheSize = 400;
    private static final String SUFFIX = "_LiveTime";

    public CronConCurrentHashMap() {
        this.concurrentHashMap = new ConcurrentHashMap();
    }

    public CronConCurrentHashMap(int cleanSize) {
        this.concurrentHashMap = new ConcurrentHashMap();
        this.cacheSize = cleanSize;
    }

    public CronConCurrentHashMap(long liveTime) {
        this.concurrentHashMap = new ConcurrentHashMap();
        this.cachLiveTime = liveTime;
    }

    public CronConCurrentHashMap(long liveTime, int cleanSize) {
        this.concurrentHashMap = new ConcurrentHashMap();
        this.cachLiveTime = liveTime;
        this.cacheSize = cleanSize;
    }

    public CronConCurrentHashMap(int size, long liveTime, int cleanSize) {
        this.concurrentHashMap = new ConcurrentHashMap(size);
        this.cachLiveTime = liveTime;
        this.cacheSize = cleanSize;
    }

    public void put(K cacheName, V obj) {
        this.put(cacheName, obj, this.cachLiveTime);
    }

    public void put(K cacheName, V obj, long holdTime) {
        this.cleanTimeOutCacheLimitSize();
        this.concurrentHashMap.put(cacheName, obj);
        this.concurrentHashMapClock.put(cacheName + SUFFIX, System.currentTimeMillis() + holdTime);
    }

    public V get(K cacheName) {
        if (this.checkSingleCacheName(cacheName)) {
            return this.concurrentHashMap.get(cacheName);
        }
        return null;
    }

    public void removeAll() {
        this.concurrentHashMap.clear();
        this.concurrentHashMapClock.clear();
    }

    public void remove(K cacheName) {
        this.concurrentHashMap.remove(cacheName);
        this.concurrentHashMapClock.remove(cacheName + SUFFIX);
    }

    public boolean containsKey(K key) {
        return this.get(key) != null;
    }

    public boolean checkSingleCacheName(K cacheName) {
        Long cacheLiveTime = this.concurrentHashMapClock.get(cacheName + SUFFIX);
        if (cacheLiveTime == null || cacheLiveTime == 0L) {
            return false;
        }
        if (cacheLiveTime < System.currentTimeMillis()) {
            this.remove(cacheName);
            return false;
        }
        return true;
    }

    public void cleanTimeOutCacheLimitSize() {
        if (this.concurrentHashMap.size() > this.cacheSize) {
            for (Map.Entry<K, V> kvEntry : this.concurrentHashMap.entrySet()) {
                this.checkSingleCacheName(kvEntry.getKey());
            }
        }
    }

    public void cleanTimeOutCache() {
        for (Map.Entry<K, V> kvEntry : this.concurrentHashMap.entrySet()) {
            this.checkSingleCacheName(kvEntry.getKey());
        }
    }

    public ConcurrentHashMap<K, V> getConcurrentHashMap() {
        return this.concurrentHashMap;
    }

    public ConcurrentHashMap<String, Long> getConcurrentHashMapClock() {
        return this.concurrentHashMapClock;
    }

    public long getCachLiveTime() {
        return this.cachLiveTime;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setConcurrentHashMap(ConcurrentHashMap<K, V> concurrentHashMap) {
        this.concurrentHashMap = concurrentHashMap;
    }

    public void setConcurrentHashMapClock(ConcurrentHashMap<String, Long> concurrentHashMapClock) {
        this.concurrentHashMapClock = concurrentHashMapClock;
    }

    public void setCachLiveTime(long cachLiveTime) {
        this.cachLiveTime = cachLiveTime;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CronConCurrentHashMap)) {
            return false;
        }
        CronConCurrentHashMap other = (CronConCurrentHashMap)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCachLiveTime() != other.getCachLiveTime()) {
            return false;
        }
        if (this.getCacheSize() != other.getCacheSize()) {
            return false;
        }
        ConcurrentHashMap<K, V> this$concurrentHashMap = this.getConcurrentHashMap();
        ConcurrentHashMap<K, V> other$concurrentHashMap = other.getConcurrentHashMap();
        if (this$concurrentHashMap == null ? other$concurrentHashMap != null : !((Object)this$concurrentHashMap).equals(other$concurrentHashMap)) {
            return false;
        }
        ConcurrentHashMap<String, Long> this$concurrentHashMapClock = this.getConcurrentHashMapClock();
        ConcurrentHashMap<String, Long> other$concurrentHashMapClock = other.getConcurrentHashMapClock();
        return !(this$concurrentHashMapClock == null ? other$concurrentHashMapClock != null : !((Object)this$concurrentHashMapClock).equals(other$concurrentHashMapClock));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CronConCurrentHashMap;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $cachLiveTime = this.getCachLiveTime();
        result = result * 59 + (int)($cachLiveTime >>> 32 ^ $cachLiveTime);
        result = result * 59 + this.getCacheSize();
        ConcurrentHashMap<K, V> $concurrentHashMap = this.getConcurrentHashMap();
        result = result * 59 + ($concurrentHashMap == null ? 43 : ((Object)$concurrentHashMap).hashCode());
        ConcurrentHashMap<String, Long> $concurrentHashMapClock = this.getConcurrentHashMapClock();
        result = result * 59 + ($concurrentHashMapClock == null ? 43 : ((Object)$concurrentHashMapClock).hashCode());
        return result;
    }

    public String toString() {
        return "CronConCurrentHashMap(concurrentHashMap=" + this.getConcurrentHashMap() + ", concurrentHashMapClock=" + this.getConcurrentHashMapClock() + ", cachLiveTime=" + this.getCachLiveTime() + ", cacheSize=" + this.getCacheSize() + ")";
    }
}

