/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.docexamine.executor.imp.wordelementextractor;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.icpac.common.entity.po.ExtractElement;
import com.jxdinfo.idp.icpac.doccontrast.entity.po.ConfigDocElement;
import com.jxdinfo.idp.icpac.docexamine.entity.docconfig.BasisText;
import com.jxdinfo.idp.icpac.docexamine.entity.docconfig.ExtractRule;
import com.jxdinfo.idp.icpac.docexamine.entity.docconfig.extractsetting.ExtractSettingsChapter;
import com.jxdinfo.idp.icpac.docexamine.entity.dto.ExtractContent;
import com.jxdinfo.idp.icpac.docexamine.entity.location.WordLocation;
import com.jxdinfo.idp.icpac.docexamine.executor.imp.wordelementextractor.AbstractElementWordExtractor;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordChapterInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordStructureInfo;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ChapterElementWordExtractor
extends AbstractElementWordExtractor {
    public ChapterElementWordExtractor() {
        super("chapter");
    }

    @Override
    public ExtractElement extractElement(String subtaskId, ConfigDocElement docElement) {
        ExtractElement extractElement = new ExtractElement();
        ExtractRule extractRule = (ExtractRule)JSON.parseObject((String)docElement.getExtractRule(), ExtractRule.class);
        ExtractSettingsChapter extractSettings = this.getExtractSettings(extractRule.getExtractSettings(), ExtractSettingsChapter.class);
        List<WordChapterInfo> chapterList = ((WordStructureInfo)contentMap.get(subtaskId)).getChapterInfos();
        if (CollectionUtil.isEmpty(chapterList)) {
            throw new BusinessException("\u6ca1\u6709\u5339\u914d\u5230\u7ae0\u8282\u53ca\u5176\u6587\u672c");
        }
        List<BasisText> basisTexts = extractSettings.getBasisTexts();
        String matchStrategy = extractSettings.getMatchStrategy();
        ArrayList<ExtractContent> contents = new ArrayList<ExtractContent>();
        for (WordChapterInfo wordChapterInfo : chapterList) {
            String titleName = wordChapterInfo.getTitleName();
            if (!this.isMatched(basisTexts, titleName)) continue;
            ExtractContent content = new ExtractContent();
            content.setValue(wordChapterInfo.getText());
            WordLocation location = new WordLocation();
            WordLocation.ParagraphLocation pLocation = location.newPLocation();
            pLocation.setIndex(wordChapterInfo.getStartRow());
            content.setWordLocation(location);
            content.setWordChapterInfo(wordChapterInfo);
            contents.add(content);
        }
        ExtractContent resultContent = null;
        if (CollectionUtil.isNotEmpty(contents)) {
            resultContent = "1".equals(matchStrategy) ? (ExtractContent)contents.get(0) : ("2".equals(matchStrategy) ? (ExtractContent)contents.get(contents.size() - 1) : (ExtractContent)contents.get(0));
            extractElement.setElementLocation(JSON.toJSONString((Object)resultContent.getWordLocation()));
            extractElement.setOriginText(resultContent.getValue());
            extractElement.setElementText(resultContent.getValue());
        }
        if (resultContent == null) {
            throw new BusinessException("\u672a\u63d0\u53d6\u5230\u7ae0\u8282\u8981\u7d20\u3010" + docElement.getElementName() + "\u3011");
        }
        this.addCache(subtaskId, docElement.getElementName(), resultContent);
        return extractElement;
    }

    private boolean isMatched(List<BasisText> basisTexts, String titleName) {
        if (CollectionUtil.isEmpty(basisTexts) || titleName == null) {
            return false;
        }
        for (BasisText basisText : basisTexts) {
            if (!titleName.contains(basisText.getText())) continue;
            return true;
        }
        return false;
    }
}

