/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.docexamine.executor.imp.wordelementextractor;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.icpac.common.entity.po.ExtractElement;
import com.jxdinfo.idp.icpac.common.handler.ValueHandler;
import com.jxdinfo.idp.icpac.common.handler.ValueHandlerUtils;
import com.jxdinfo.idp.icpac.common.service.IExtractElementService;
import com.jxdinfo.idp.icpac.doccontrast.entity.po.ConfigDocElement;
import com.jxdinfo.idp.icpac.doccontrast.util.StringUtils;
import com.jxdinfo.idp.icpac.docexamine.entity.docconfig.AfterHandle;
import com.jxdinfo.idp.icpac.docexamine.entity.docconfig.ExtractRule;
import com.jxdinfo.idp.icpac.docexamine.entity.docconfig.extractsetting.ExtractSettings;
import com.jxdinfo.idp.icpac.docexamine.entity.docconfig.extractsetting.TextExtractSettings;
import com.jxdinfo.idp.icpac.docexamine.entity.dto.ExtractContent;
import com.jxdinfo.idp.icpac.docexamine.entity.location.WordLocation;
import com.jxdinfo.idp.icpac.docexamine.executor.IElementWordExtractor;
import com.jxdinfo.idp.icpac.docexamine.executor.imp.wordelementextractor.WordElementExtractFactory;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordCellInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordChapterInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordParagraphInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordRowInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordStructureInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordTableInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractElementWordExtractor
implements IElementWordExtractor {
    private static final Logger log = LoggerFactory.getLogger(AbstractElementWordExtractor.class);
    public static Map<String, WordStructureInfo> contentMap = new ConcurrentHashMap<String, WordStructureInfo>();
    public static Map<String, Map<String, ExtractContent>> extractContentCache = new ConcurrentHashMap<String, Map<String, ExtractContent>>();
    @Autowired
    protected IExtractElementService extractElementService;

    public AbstractElementWordExtractor(String type) {
        WordElementExtractFactory.register(type, this);
    }

    protected ExtractRule getExtractRule(String extractRule) {
        return (ExtractRule)JSON.parseObject((String)extractRule, ExtractRule.class);
    }

    protected <T> T getExtractSettings(ExtractSettings settings, Class<T> tClass) {
        T t = null;
        try {
            t = tClass.newInstance();
            BeanUtils.copyProperties((Object)settings, t);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return t;
    }

    @Override
    public ExtractElement extractElement(String subtaskId, ConfigDocElement docElement) {
        ExtractElement extractElement = new ExtractElement();
        List<WordParagraphInfo> pInfoList = contentMap.get(subtaskId).getPInfoList();
        ExtractRule extractRule = this.getExtractRule(docElement.getExtractRule());
        TextExtractSettings extractSettings = this.getExtractSettings(extractRule.getExtractSettings(), TextExtractSettings.class);
        String extractRange = extractSettings.getExtractRange();
        String fromTabFlag = extractSettings.getFromTabFlag().toString();
        String fromTable = extractSettings.getFromTable();
        String condition = extractSettings.getCondition();
        String textContent = extractSettings.getTextContent();
        String locator = extractSettings.getLocation();
        List<String> regulars = extractSettings.getRegulars();
        String matchStrategy = extractSettings.getMatchStrategy();
        List<ExtractContent> contents = new ArrayList<ExtractContent>();
        if (StringUtils.isEmpty(extractRange) || "\u5168\u6587".equals(extractRange)) {
            if ("1".equals(fromTabFlag)) {
                if (StringUtils.isEmpty(fromTable) || "\u5168\u6587".equals(fromTable)) {
                    contents.addAll(this.getFromAllTable(subtaskId, condition, textContent, locator));
                } else {
                    ExtractContent content = extractContentCache.get(subtaskId).get(fromTable);
                    if (StringUtils.isEmpty(content.getValue())) {
                        throw new BusinessException("\u6307\u5b9a\u8868\u683c\u3010" + fromTable + "\u3011\u4e3a\u7a7a");
                    }
                    WordTableInfo tableInfo = content.getTableInfo();
                    List<ExtractContent> tableContents = this.extractFromTab(tableInfo, condition, textContent, locator);
                    contents.addAll(tableContents);
                }
            } else {
                for (WordParagraphInfo paragraphInfo : pInfoList) {
                    WordLocation location = new WordLocation();
                    WordLocation.ParagraphLocation pLocation = location.newPLocation();
                    pLocation.setIndex(paragraphInfo.getIndex());
                    ExtractContent content = new ExtractContent(paragraphInfo.getText(), location);
                    contents.add(content);
                }
            }
        } else {
            ExtractContent extractContent = extractContentCache.get(subtaskId).get(extractRange);
            if (StringUtils.isEmpty(extractContent.getValue())) {
                throw new BusinessException("\u63d0\u53d6\u8303\u56f4\u3010" + docElement.getElementName() + "\u3011\u4e3a\u7a7a");
            }
            WordChapterInfo chapterInfo = extractContent.getWordChapterInfo();
            for (WordParagraphInfo pInfo : pInfoList) {
                if (pInfo.getIndex() < chapterInfo.getStartRow() || pInfo.getIndex() > chapterInfo.getEndRow()) continue;
                WordLocation location = new WordLocation();
                WordLocation.ParagraphLocation pLocation = location.newPLocation();
                pLocation.setIndex(pInfo.getIndex());
                ExtractContent content = new ExtractContent();
                content.setValue(pInfo.getText());
                content.setWordLocation(location);
                contents.add(content);
            }
        }
        if (StringUtils.isEmpty(contents)) {
            throw new BusinessException("\u8981\u7d20\u3010" + docElement.getElementName() + "\u3011\u63d0\u53d6\u5185\u5bb9\u4e3a\u7a7a");
        }
        contents = this.secondExtract(contents, regulars);
        ExtractContent resultContent = new ExtractContent();
        if (CollectionUtil.isNotEmpty(contents)) {
            resultContent = "1".equals(matchStrategy) ? contents.get(0) : ("2".equals(matchStrategy) ? contents.get(contents.size() - 1) : contents.get(0));
        }
        extractElement.setElementLocation(JSON.toJSONString((Object)resultContent.getWordLocation()));
        extractElement.setOriginText(resultContent.getValue());
        return extractElement;
    }

    private List<ExtractContent> secondExtract(List<ExtractContent> contents, List<String> regulars) {
        if (CollectionUtil.isEmpty(regulars)) {
            return contents;
        }
        ArrayList<ExtractContent> matchedContents = new ArrayList<ExtractContent>();
        block0: for (ExtractContent content : contents) {
            block1: for (String regular : regulars) {
                String value;
                Matcher matcher;
                ExtractContent matchedContent = new ExtractContent();
                Pattern pattern = Pattern.compile(regular);
                WordLocation location = content.getWordLocation();
                WordLocation.ParagraphLocation pLocation = location.getPLocation();
                if (pLocation != null && (matcher = pattern.matcher(value = content.getValue())).find()) {
                    int groupCount = matcher.groupCount();
                    String matchText = groupCount >= 1 ? matcher.group(1) : matcher.group();
                    int textIndex = groupCount >= 1 ? matcher.start(1) : matcher.start();
                    matchText = matchText.trim();
                    int textLength = matchText.length();
                    matchedContent.setValue(matchText);
                    pLocation.setTextIndex(textIndex);
                    pLocation.setTextLength(textLength);
                    matchedContent.setWordLocation(location);
                    matchedContents.add(matchedContent);
                    continue block0;
                }
                WordLocation.TableLocation tLocation = location.getTLocation();
                if (tLocation == null || 1 != tLocation.getType()) continue;
                WordTableInfo tableInfo = content.getTableInfo();
                WordCellInfo cellInfo = tableInfo.getRows().get(tLocation.getRowIndex()).getCells().get(tLocation.getCellIndex());
                List<WordParagraphInfo> paragraphs = cellInfo.getParagraphs();
                for (WordParagraphInfo paragraph : paragraphs) {
                    String pText = paragraph.getText();
                    Matcher matcher2 = pattern.matcher(pText);
                    if (!matcher2.find()) continue;
                    int groupCount = matcher2.groupCount();
                    String matchText = groupCount >= 1 ? matcher2.group(1) : matcher2.group();
                    int textIndex = groupCount >= 1 ? matcher2.start(1) : matcher2.start();
                    matchText = matchText.trim();
                    int textLength = matchText.length();
                    matchedContent.setValue(matchText);
                    tLocation.setCellPIndex(paragraph.getIndex());
                    tLocation.setTextIndex(textIndex);
                    tLocation.setTextLength(textLength);
                    matchedContent.setWordLocation(location);
                    matchedContents.add(matchedContent);
                    continue block1;
                }
            }
        }
        return matchedContents;
    }

    protected void addCache(String subtaskId, String elementName, ExtractContent extractContent) {
        if (extractContentCache.get(subtaskId) == null) {
            HashMap<String, ExtractContent> map = new HashMap<String, ExtractContent>();
            map.put(elementName, extractContent);
            extractContentCache.put(subtaskId, map);
        } else {
            extractContentCache.get(subtaskId).put(elementName, extractContent);
        }
    }

    protected void postHandle(ConfigDocElement element, ExtractElement extractElement) {
        ExtractRule extractRule = this.getExtractRule(element.getExtractRule());
        AfterHandle afterHandle = extractRule.getAfterHandle();
        ValueHandler handler = ValueHandlerUtils.get(afterHandle.getDataProcess());
        String value = handler.value(extractElement.getOriginText()).toString();
        extractElement.setElementText(value);
    }

    private List<ExtractContent> extractFromTab(WordTableInfo table, String condition, String matchText, String offset) {
        List xList;
        int offsetY;
        int offsetX;
        ArrayList<ExtractContent> result = new ArrayList<ExtractContent>();
        HashMap<Integer, List> coordinateMap = new HashMap<Integer, List>();
        String[] offsets = offset.split(",");
        try {
            offsetX = Integer.parseInt(offsets[0]);
        }
        catch (Exception e) {
            offsetX = 0;
        }
        try {
            offsetY = Integer.parseInt(offsets[1]);
        }
        catch (Exception e) {
            offsetY = 0;
        }
        List<WordRowInfo> rows = table.getRows();
        for (WordRowInfo wordRowInfo : rows) {
            List<WordCellInfo> cells = wordRowInfo.getCells();
            for (WordCellInfo cell : cells) {
                if (!this.isMatch(condition, cell.getText(), matchText)) continue;
                xList = coordinateMap.computeIfAbsent(wordRowInfo.getIndex(), k -> new ArrayList());
                xList.add(cell.getIndex());
            }
        }
        for (Map.Entry entry : coordinateMap.entrySet()) {
            int y = (Integer)entry.getKey();
            int targetY = y + offsetY;
            xList = (List)entry.getValue();
            for (Integer x : xList) {
                int targetX = x + offsetX;
                try {
                    ExtractContent content = new ExtractContent();
                    WordCellInfo cellInfo = rows.get(targetY).getCells().get(targetX);
                    WordLocation location = new WordLocation();
                    WordLocation.TableLocation tLocation = location.newTLocation();
                    tLocation.setType(1);
                    tLocation.setIndex(table.getIndex());
                    tLocation.setPIndex(table.getPIndex());
                    tLocation.setRowIndex(targetY);
                    tLocation.setCellIndex(targetX);
                    content.setTableInfo(table);
                    content.setWordLocation(location);
                    content.setValue(cellInfo.getText());
                    result.add(content);
                }
                catch (Exception e) {
                    log.error("\u672a\u5bfb\u627e\u5230\u76ee\u6807\u5355\u5143\u683c", (Throwable)e);
                }
            }
        }
        return result;
    }

    private boolean isMatch(String condition, Object value, String textContent) {
        String valueStr = value.toString().replaceAll("\u0007", "");
        if ("\u76f8\u7b49".equals(condition) && valueStr.equals(textContent)) {
            return true;
        }
        return "\u5305\u542b".equals(condition) && valueStr.contains(textContent);
    }

    private List<ExtractContent> getFromAllTable(String subtaskId, String condition, String matchContent, String coordinate) {
        List xList;
        int offsetY;
        int offsetX;
        HashMap<Integer, Map> tableCoordinateMap = new HashMap<Integer, Map>();
        ArrayList<ExtractContent> result = new ArrayList<ExtractContent>();
        String[] offset = coordinate.split(",");
        try {
            offsetX = Integer.parseInt(offset[0]);
        }
        catch (Exception e) {
            offsetX = 0;
        }
        try {
            offsetY = Integer.parseInt(offset[1]);
        }
        catch (Exception e) {
            offsetY = 0;
        }
        List<WordTableInfo> tableList = contentMap.get(subtaskId).getTableInfos();
        for (WordTableInfo wordTableInfo : tableList) {
            List<WordRowInfo> rows = wordTableInfo.getRows();
            for (WordRowInfo row : rows) {
                List<WordCellInfo> cells = row.getCells();
                for (WordCellInfo cell : cells) {
                    if (!this.isMatch(condition, cell.getText(), matchContent)) continue;
                    Map coordinateMap = tableCoordinateMap.computeIfAbsent(wordTableInfo.getIndex(), k -> new HashMap());
                    xList = coordinateMap.computeIfAbsent(row.getIndex(), k -> new ArrayList());
                    xList.add(cell.getIndex());
                }
            }
        }
        for (Map.Entry entry : tableCoordinateMap.entrySet()) {
            Integer tableIndex = (Integer)entry.getKey();
            Map coordinateMap = (Map)entry.getValue();
            for (Map.Entry coordinateEntry : coordinateMap.entrySet()) {
                int y = (Integer)coordinateEntry.getKey();
                int targetY = y + offsetY;
                xList = (List)coordinateEntry.getValue();
                for (Integer x : xList) {
                    int targetX = x + offsetX;
                    try {
                        ExtractContent content = new ExtractContent();
                        WordTableInfo table = tableList.get(tableIndex);
                        WordCellInfo cellInfo = table.getRows().get(targetY).getCells().get(targetX);
                        WordLocation location = new WordLocation();
                        WordLocation.TableLocation tLocation = location.newTLocation();
                        tLocation.setType(1);
                        tLocation.setIndex(table.getIndex());
                        tLocation.setPIndex(table.getPIndex());
                        tLocation.setRowIndex(targetY);
                        tLocation.setCellIndex(targetX);
                        content.setTableInfo(table);
                        content.setWordLocation(location);
                        content.setValue(cellInfo.getText());
                        result.add(content);
                    }
                    catch (Exception e) {
                        log.error("\u672a\u5bfb\u627e\u5230\u76ee\u6807\u5355\u5143\u683c", (Throwable)e);
                    }
                }
            }
        }
        return result;
    }
}

