/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.docexamine.executor.imp.excelelementextractor;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.idp.icpac.common.entity.FileBytesInfo;
import com.jxdinfo.idp.icpac.common.entity.po.ExtractElement;
import com.jxdinfo.idp.icpac.common.handler.ValueHandler;
import com.jxdinfo.idp.icpac.common.handler.ValueHandlerUtils;
import com.jxdinfo.idp.icpac.common.util.entity.excel.CellData;
import com.jxdinfo.idp.icpac.doccontrast.entity.po.ConfigDocElement;
import com.jxdinfo.idp.icpac.docexamine.entity.docconfig.AfterHandle;
import com.jxdinfo.idp.icpac.docexamine.entity.docconfig.ExtractRule;
import com.jxdinfo.idp.icpac.docexamine.entity.docconfig.extractsetting.TextExtractSettings;
import com.jxdinfo.idp.icpac.docexamine.executor.imp.AbstractExtractor;
import com.jxdinfo.idp.icpac.docexamine.executor.imp.excelelementextractor.ElementExcelExtractorFactory;
import com.jxdinfo.idp.icpac.multisimilaritycompare.utils.ReadExcelUtil;
import java.math.BigDecimal;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NumberElementExcelExtractor
extends ElementExcelExtractorFactory {
    private static final Logger log = LoggerFactory.getLogger(NumberElementExcelExtractor.class);

    public NumberElementExcelExtractor() {
        super("number");
    }

    @Override
    public ExtractElement extractElement(String subtaskId, ConfigDocElement docElement) {
        ExtractElement extractElement = new ExtractElement();
        FileBytesInfo docFileInfo = AbstractExtractor.docFileInfoMap.get(subtaskId);
        ExtractRule extractRule = (ExtractRule)JSON.parseObject((String)docElement.getExtractRule(), ExtractRule.class);
        TextExtractSettings extractSettings = this.getExtractSettings(extractRule.getExtractSettings(), TextExtractSettings.class);
        AfterHandle afterHandle = extractRule.getAfterHandle();
        CellData cellData = ReadExcelUtil.getCellData(extractSettings, subtaskId);
        if (cellData != null) {
            String elementText = this.checkNum(cellData.getCellData()).toPlainString();
            int sheetIndex = ReadExcelUtil.sheetIndex(docFileInfo, cellData.getSheetName());
            String excelDataLocation = cellData.getColumnIndex() + 1 + "," + (cellData.getRowIndex() + 1);
            extractElement.setElementLocation(this.getLocation(sheetIndex, extractSettings.getExtractRange(), excelDataLocation));
            ValueHandler handler = ValueHandlerUtils.get(afterHandle.getDataProcess());
            if (StringUtils.isEmpty((CharSequence)afterHandle.getDataProcess())) {
                afterHandle.setDataProcess("7");
                handler = ValueHandlerUtils.get(afterHandle.getDataProcess());
            }
            extractElement.setElementText(handler.value(elementText).toString());
        }
        return extractElement;
    }

    private BigDecimal checkNum(String str) {
        BigDecimal result;
        if (StringUtils.isEmpty((CharSequence)str)) {
            return new BigDecimal(0);
        }
        Pattern p = Pattern.compile("(\\d+)");
        Matcher m = p.matcher(str);
        if (m.find()) {
            TreeMap<Integer, String> map = new TreeMap<Integer, String>();
            Pattern p2 = Pattern.compile("(\\d+\\.\\d+)");
            m = p2.matcher(str);
            while (m.find()) {
                result = new BigDecimal(m.group(1) == null ? "" : m.group(1));
                int i = str.indexOf(result.toPlainString());
                String s = str.substring(i, i + result.toPlainString().length());
                map.put(i, s);
                str = str.substring(0, i) + str.substring(i + result.toPlainString().length());
            }
            Pattern p3 = Pattern.compile("(\\d+)");
            m = p3.matcher(str);
            while (m.find()) {
                result = new BigDecimal(m.group(1) == null ? "" : m.group(1));
                int i = str.indexOf(result.toPlainString());
                if (i > 0 && ".".equals(String.valueOf(str.charAt(i - 1)))) {
                    str = str.substring(0, i - 1) + str.substring(i + result.toPlainString().length());
                    continue;
                }
                String s = str.substring(i, i + result.toPlainString().length());
                map.put(i, s);
                str = str.substring(0, i) + str.substring(i + result.toPlainString().length());
            }
            result = new BigDecimal(0);
            for (Map.Entry e : map.entrySet()) {
                result = result.add(new BigDecimal((String)e.getValue()));
            }
            if (str.startsWith("-")) {
                return new BigDecimal(0).subtract(result);
            }
        } else {
            result = null;
        }
        return result;
    }
}

