/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.docexamine.executor.imp;

import cn.hutool.core.util.IdUtil;
import com.jxdinfo.idp.icpac.common.entity.FileBytesInfo;
import com.jxdinfo.idp.icpac.common.entity.po.ExtractElement;
import com.jxdinfo.idp.icpac.doccontrast.entity.dto.DocSubtaskDto;
import com.jxdinfo.idp.icpac.doccontrast.entity.po.ConfigDocElement;
import com.jxdinfo.idp.icpac.doccontrast.entity.query.ConfigDocElementQuery;
import com.jxdinfo.idp.icpac.doccontrast.service.IDocSubtaskService;
import com.jxdinfo.idp.icpac.docexamine.executor.IElementWordExtractor;
import com.jxdinfo.idp.icpac.docexamine.executor.IExtractor;
import com.jxdinfo.idp.icpac.docexamine.executor.imp.AbstractExtractor;
import com.jxdinfo.idp.icpac.docexamine.executor.imp.wordelementextractor.AbstractElementWordExtractor;
import com.jxdinfo.idp.icpac.docexamine.executor.imp.wordelementextractor.WordElementExtractFactory;
import com.jxdinfo.idp.icpac.docexamine.progressbar.entity.PollSentProcess;
import com.jxdinfo.idp.icpac.multisimilaritycompare.utils.ReadWordUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WordExtractorImpl
extends AbstractExtractor
implements IExtractor {
    private static final Logger log = LoggerFactory.getLogger(WordExtractorImpl.class);
    @Resource
    private IDocSubtaskService subtaskService;

    protected WordExtractorImpl() {
        super("2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<ExtractElement> extract(DocSubtaskDto subTask) {
        ArrayList<ExtractElement> extractElements = new ArrayList<ExtractElement>();
        FileBytesInfo docFileInfo = this.getFileInfo(subTask);
        try {
            ConfigDocElementQuery totalEleQuery = new ConfigDocElementQuery();
            totalEleQuery.setDocVersionId(subTask.getDocVersionId());
            List<ConfigDocElement> totalElements = this.docElementService.getList(totalEleQuery);
            AbstractElementWordExtractor.contentMap.put(subTask.getId(), ReadWordUtil.getWordInfo(docFileInfo));
            ArrayList<String> tableChapter = new ArrayList<String>(Arrays.asList("chapter", "table"));
            ConfigDocElementQuery elementQuery = new ConfigDocElementQuery(subTask.getDocVersionId(), tableChapter);
            List<ConfigDocElement> preElementList = this.docElementService.getList(elementQuery);
            for (ConfigDocElement element : preElementList) {
                ExtractElement extractElement;
                try {
                    extractElement = this.extractElement(subTask, element);
                }
                catch (Exception e) {
                    extractElement = this.extractEmptyElement(subTask, element);
                    log.error("\u8981\u7d20\u3010" + element.getElementName() + "\u3011\u63d0\u53d6\u5f02\u5e38", (Throwable)e);
                }
                extractElements.add(extractElement);
                Double progress = (double)extractElements.size() / (double)totalElements.size() * 78.0;
                PollSentProcess.put(subTask.getId(), String.format("%.2f", progress));
            }
            ArrayList<String> textNumDate = new ArrayList<String>(Arrays.asList("text", "number", "date"));
            elementQuery.setElementTypes(textNumDate);
            List<ConfigDocElement> postElementList = this.docElementService.getList(elementQuery);
            for (ConfigDocElement element : postElementList) {
                ExtractElement extractElement;
                try {
                    extractElement = this.extractElement(subTask, element);
                }
                catch (Exception e) {
                    extractElement = this.extractEmptyElement(subTask, element);
                    log.error("\u8981\u7d20\u3010" + element.getElementName() + "\u3011\u63d0\u53d6\u5f02\u5e38");
                }
                extractElements.add(extractElement);
                Double progress = (double)extractElements.size() / (double)totalElements.size() * 78.0;
                PollSentProcess.put(subTask.getId(), String.format("%.2f", progress));
            }
            PollSentProcess.put(subTask.getId(), String.valueOf(80.0));
        }
        catch (Exception e) {
            log.error("word\u6587\u6863\u63d0\u53d6\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            PollSentProcess.put(subTask.getId(), String.valueOf(80.0));
            DocSubtaskDto subtask = this.subtaskService.getDetail(subTask.getId());
            subtask.setExecuteStatus(2);
            this.subtaskService.updateById(subtask);
        }
        finally {
            this.removeCache(subTask.getId());
        }
        return extractElements;
    }

    private ExtractElement extractElement(DocSubtaskDto dto, ConfigDocElement element) {
        IElementWordExtractor elementExtractor = WordElementExtractFactory.get(element.getElementType());
        ExtractElement extractElement = elementExtractor.extractElement(dto.getId(), element);
        extractElement.setId(IdUtil.simpleUUID());
        extractElement.setDocId(dto.getDocId());
        extractElement.setDocElementId(element.getId());
        extractElement.setDocFormat(dto.getDocFormat());
        extractElement.setElementType(element.getElementType());
        extractElement.setDocElementId(element.getId());
        return extractElement;
    }

    private void removeCache(String subtaskId) {
        AbstractElementWordExtractor.contentMap.remove(subtaskId);
        docFileInfoMap.remove(subtaskId);
    }
}

