/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.docexamine.executor.imp;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.idp.common.user.entity.SysUsersVo;
import com.jxdinfo.idp.common.util.user.UserUtils;
import com.jxdinfo.idp.common.util.uuid.IdUtils;
import com.jxdinfo.idp.dio.service.FileService;
import com.jxdinfo.idp.icpac.common.entity.PdfOcrResponse;
import com.jxdinfo.idp.icpac.common.entity.po.ExtractElement;
import com.jxdinfo.idp.icpac.common.ocr.entity.po.AbilityOcrExtract;
import com.jxdinfo.idp.icpac.common.ocr.handler.parser.OcrResponseParser;
import com.jxdinfo.idp.icpac.common.ocr.service.AbilityOcrExtractService;
import com.jxdinfo.idp.icpac.doccontrast.entity.dto.DocSubtaskDto;
import com.jxdinfo.idp.icpac.doccontrast.entity.po.ConfigDocElement;
import com.jxdinfo.idp.icpac.doccontrast.entity.po.ConfigDocVersion;
import com.jxdinfo.idp.icpac.doccontrast.service.IConfigDocVersionService;
import com.jxdinfo.idp.icpac.doccontrast.service.IDocSubtaskService;
import com.jxdinfo.idp.icpac.doccontrast.service.OcrService;
import com.jxdinfo.idp.icpac.docexamine.executor.imp.AbstractExtractor;
import com.jxdinfo.idp.icpac.docexamine.progressbar.entity.PollSentProcess;
import com.jxdinfo.idp.interf.FileSystemInterface;
import com.jxdinfo.idp.po.DocFilePo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PdfImgExtractorImp
extends AbstractExtractor {
    private static final Logger log = LoggerFactory.getLogger(PdfImgExtractorImp.class);
    @Autowired
    private OcrService ocrService;
    @Autowired
    private IConfigDocVersionService versionService;
    @Resource
    private AbilityOcrExtractService extractService;
    @Resource
    private FileSystemInterface fileInfoService;
    @Resource
    private FileService fileService;
    @Resource
    private IDocSubtaskService subtaskService;
    private ExecutorService customExecutor = Executors.newFixedThreadPool(10);

    public PdfImgExtractorImp() {
        super("5");
    }

    @Override
    public List<ExtractElement> extract(DocSubtaskDto subTask) {
        DocSubtaskDto subtask = this.subtaskService.getDetail(subTask.getId());
        try {
            PdfOcrResponse pdfOcrResponse;
            ConfigDocVersion docVersion = (ConfigDocVersion)this.versionService.getById(subTask.getDocVersionId());
            Long docId = subTask.getDocId();
            String octExtractId = docVersion.getOcrConfigId();
            AbilityOcrExtract ocrExtract = new AbilityOcrExtract();
            SysUsersVo user = UserUtils.getLoginUser();
            if (user != null) {
                ocrExtract.setCreateBy(user.getUserAccount());
            }
            ocrExtract.setStartTime(new Date());
            ocrExtract.setDocId(subTask.getDocId());
            ocrExtract.setId(IdUtils.simpleUUID());
            DocFilePo fileInfo = (DocFilePo)this.fileInfoService.getById((Serializable)docId);
            byte[] fileBytes = subTask.getFiles();
            if (fileBytes == null || fileBytes.length == 0) {
                fileBytes = this.fileService.download(fileInfo.getFilePath());
            }
            try {
                pdfOcrResponse = this.ocrService.getPdfOcrResponse(octExtractId, docId, "1", fileBytes);
            }
            catch (Exception e) {
                pdfOcrResponse = new PdfOcrResponse();
                pdfOcrResponse.setStatus(0);
            }
            subtask.setExecuteStatus(pdfOcrResponse.getStatus() == 1 ? 1 : 2);
            this.subtaskService.updateById(subtask);
            pdfOcrResponse.setExtractFile(null);
            ocrExtract.setOcrResponseJson(JSON.toJSONString((Object)pdfOcrResponse));
            ocrExtract.setEndTime(new Date());
            ocrExtract.setConfigOcrId(docVersion.getOcrConfigId());
            this.extractService.insert(ocrExtract);
            List<ConfigDocElement> docElements = this.docElementService.elementsByVersion(docVersion.getId());
            OcrResponseParser ocrResponseParser = new OcrResponseParser(pdfOcrResponse);
            List<ExtractElement> elements = ocrResponseParser.parse(docElements);
            List<ExtractElement> extractElements = this.adapterData(elements, docElements, subTask.getId());
            extractElements.addAll(this.extractMapping(docElements, extractElements, docId));
            PollSentProcess.put(subTask.getId(), String.valueOf(80.0));
            return extractElements;
        }
        catch (Exception e) {
            log.error("pdf\u626b\u63cf\u4ef6\u63d0\u53d6\u5f02\u5e38", (Object)e.getMessage(), (Object)e);
            PollSentProcess.put(subTask.getId(), String.valueOf(80.0));
            subtask.setExecuteStatus(2);
            this.subtaskService.updateById(subtask);
            throw new RuntimeException(e);
        }
    }

    private List<ExtractElement> adapterData(List<ExtractElement> elements, List<ConfigDocElement> docElements, String subtaskId) {
        String key;
        HashMap<String, ConfigDocElement> docElementMap = new HashMap<String, ConfigDocElement>();
        for (ConfigDocElement docElement : docElements) {
            key = docElement.getElementType() + "_" + docElement.getElementName();
            docElementMap.put(key, docElement);
        }
        for (ExtractElement element : elements) {
            key = element.getElementType() + "_" + element.getDocElementId();
            ConfigDocElement docElement = docElementMap.getOrDefault(key, new ConfigDocElement());
            element.setDocElementId(docElement.getId());
        }
        return elements;
    }

    private List<ExtractElement> extractMapping(List<ConfigDocElement> docElements, List<ExtractElement> extractElements, Long docId) {
        SysUsersVo user = UserUtils.getLoginUser();
        List extractElementIds = extractElements.stream().map(ExtractElement::getDocElementId).collect(Collectors.toList());
        List lossElements = docElements.stream().filter(item -> !extractElementIds.contains(item.getId())).collect(Collectors.toList());
        ArrayList<ExtractElement> result = new ArrayList<ExtractElement>();
        for (ConfigDocElement element : lossElements) {
            ExtractElement extractElement = new ExtractElement();
            extractElement.setId(IdUtils.simpleUUID());
            extractElement.setDocElementId(element.getId());
            extractElement.setDocFormat("5");
            extractElement.setUpdateTime(new Date());
            if (null == user) {
                extractElement.setEditor("bj");
            } else {
                extractElement.setEditor(String.valueOf(user.getId()));
            }
            extractElement.setDocId(docId);
            extractElement.setElementType(element.getElementType());
            result.add(extractElement);
        }
        return result;
    }

    private Future<Double> sendProgress(String subTaskId, int size) throws Exception {
        return this.customExecutor.submit(() -> {
            double mbSize = (double)size / 1024.0 / 50.0;
            int frequency = 0;
            while (mbSize > 0.0) {
                mbSize -= 1.0;
                ++frequency;
            }
            double progress = 0.0;
            if (frequency > 0) {
                for (int i = 1; i <= frequency && !Thread.currentThread().isInterrupted(); ++i) {
                    Thread.sleep(800L);
                    progress = (double)i / (double)frequency * 78.0;
                    PollSentProcess.put(subTaskId, String.format("%.2f", progress));
                }
            }
            return progress;
        });
    }
}

