/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.docexamine.executor.imp;

import cn.hutool.core.util.IdUtil;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.icpac.common.entity.FileBytesInfo;
import com.jxdinfo.idp.icpac.common.entity.po.ExtractElement;
import com.jxdinfo.idp.icpac.common.util.ReadExcelUtil;
import com.jxdinfo.idp.icpac.doccontrast.entity.dto.DocSubtaskDto;
import com.jxdinfo.idp.icpac.doccontrast.entity.po.ConfigDocElement;
import com.jxdinfo.idp.icpac.doccontrast.entity.query.ConfigDocElementQuery;
import com.jxdinfo.idp.icpac.doccontrast.service.IDocSubtaskService;
import com.jxdinfo.idp.icpac.docexamine.executor.IElementExcelExtractor;
import com.jxdinfo.idp.icpac.docexamine.executor.IExtractor;
import com.jxdinfo.idp.icpac.docexamine.executor.imp.AbstractExtractor;
import com.jxdinfo.idp.icpac.docexamine.executor.imp.excelelementextractor.ElementExcelExtractorFactory;
import com.jxdinfo.idp.icpac.docexamine.progressbar.entity.PollSentProcess;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ExcelExtractorImpl
extends AbstractExtractor
implements IExtractor {
    private static final Logger log = LoggerFactory.getLogger(ExcelExtractorImpl.class);
    @Resource
    private IDocSubtaskService subtaskService;

    public ExcelExtractorImpl() {
        super("3");
    }

    @Override
    public List<ExtractElement> extract(DocSubtaskDto subTask) {
        ArrayList<ExtractElement> extractElements = new ArrayList<ExtractElement>();
        FileBytesInfo docFileInfo = this.getFileInfo(subTask);
        if (docFileInfo == null) {
            throw new BusinessException("\u6ca1\u6709\u67e5\u8be2\u5230\u6587\u6863\u4fe1\u606f\uff01");
        }
        try {
            Double progress;
            ExtractElement extractElement;
            ConfigDocElementQuery totalEleQuery = new ConfigDocElementQuery();
            totalEleQuery.setDocVersionId(subTask.getDocVersionId());
            List<ConfigDocElement> totalElements = this.docElementService.getList(totalEleQuery);
            ElementExcelExtractorFactory.cellDataMapMap.put(subTask.getId(), ReadExcelUtil.structure(docFileInfo));
            ArrayList<String> sheet = new ArrayList<String>(Arrays.asList("sheet", "table"));
            ConfigDocElementQuery elementQuery = new ConfigDocElementQuery(subTask.getDocVersionId(), sheet);
            List<ConfigDocElement> sheetElements = this.docElementService.getList(elementQuery);
            ArrayList<String> exceptSheet = new ArrayList<String>(Arrays.asList("text", "number", "date"));
            elementQuery.setElementTypes(exceptSheet);
            List<ConfigDocElement> contentElements = this.docElementService.getList(elementQuery);
            for (ConfigDocElement element : sheetElements) {
                try {
                    extractElement = this.extractElement(subTask, element);
                }
                catch (Exception e) {
                    extractElement = this.extractEmptyElement(subTask, element);
                    log.error("\u8981\u7d20\u3010" + element.getElementName() + "\u3011\u63d0\u53d6\u5f02\u5e38", (Throwable)e);
                }
                extractElements.add(extractElement);
                progress = (double)extractElements.size() / (double)totalElements.size() * 78.0;
                PollSentProcess.put(subTask.getId(), String.format("%.2f", progress));
            }
            for (ConfigDocElement element : contentElements) {
                try {
                    extractElement = this.extractElement(subTask, element);
                }
                catch (Exception e) {
                    extractElement = this.extractEmptyElement(subTask, element);
                    log.error("\u8981\u7d20\u3010" + element.getElementName() + "\u3011\u63d0\u53d6\u5f02\u5e38", (Throwable)e);
                }
                extractElements.add(extractElement);
                progress = (double)extractElements.size() / (double)totalElements.size() * 78.0;
                PollSentProcess.put(subTask.getId(), String.format("%.2f", progress));
            }
            PollSentProcess.put(subTask.getId(), "80.00");
        }
        catch (Exception e) {
            log.error("excel\u6587\u6863\u63d0\u53d6\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            PollSentProcess.put(subTask.getId(), "80.00");
            DocSubtaskDto subtask = this.subtaskService.getDetail(subTask.getId());
            subtask.setExecuteStatus(2);
            this.subtaskService.updateById(subtask);
            throw new BusinessException("excel\u6587\u6863\u63d0\u53d6\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u540e\u53f0\u65e5\u5fd7");
        }
        finally {
            docFileInfoMap.remove(subTask.getId());
            ElementExcelExtractorFactory.cellDataMapMap.remove(subTask.getId());
            ElementExcelExtractorFactory.excelSheetDataMaps.remove(subTask.getId());
            ElementExcelExtractorFactory.excelTableDataMaps.remove(subTask.getId());
        }
        return extractElements;
    }

    private ExtractElement extractElement(DocSubtaskDto dto, ConfigDocElement element) {
        IElementExcelExtractor elementExtractor = ElementExcelExtractorFactory.get(element.getElementType());
        ExtractElement extractElement = elementExtractor.extractElement(dto.getId(), element);
        extractElement.setId(IdUtil.simpleUUID());
        extractElement.setDocId(dto.getDocId());
        extractElement.setDocElementId(element.getId());
        extractElement.setDocFormat(dto.getDocFormat());
        extractElement.setElementType(element.getElementType());
        extractElement.setDocElementId(element.getId());
        return extractElement;
    }
}

