/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.doccontrast.util.wordpicture;

import com.jxdinfo.idp.common.util.SpringUtils;
import com.jxdinfo.idp.common.util.uuid.IdUtils;
import com.jxdinfo.idp.icpac.doccontrast.entity.po.ZnysImgData;
import com.jxdinfo.idp.icpac.doccontrast.service.IZnysImgDataService;
import com.jxdinfo.idp.icpac.doccontrast.util.ImgTransUtil;
import java.util.Base64;
import javax.annotation.Resource;
import org.apache.poi.hwpf.converter.PicturesManager;
import org.apache.poi.hwpf.usermodel.PictureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

public class PictureManagerImpl
implements PicturesManager {
    private static final Logger log = LoggerFactory.getLogger(PictureManagerImpl.class);
    private String urlPrefix;
    private String newDirName = IdUtils.simpleUUID();
    @Resource
    private IZnysImgDataService znysImgDataService = (IZnysImgDataService)SpringUtils.getBean(IZnysImgDataService.class);

    public PictureManagerImpl(String urlPrefix) {
        this.urlPrefix = urlPrefix;
    }

    public String savePicture(byte[] bytes, PictureType pictureType, String s, float v, float v1) {
        String path = ResourceUtils.getURL((String)"classpath:").getPath() + "static/img/" + this.newDirName + "/";
        String imgName = IdUtils.simpleUUID() + s;
        if (pictureType == PictureType.EMF || pictureType == PictureType.WMF || pictureType == PictureType.UNKNOWN) {
            String lastName = ImgTransUtil.transToPic(bytes, path + imgName, pictureType);
            return "dir=" + this.newDirName + ";fileName=" + lastName;
        }
        ZnysImgData znysImgData = ZnysImgData.builder().objId(IdUtils.simpleUUID()).docId("").imgData(Base64.getEncoder().encodeToString(bytes)).fileName(imgName).belongFlag("0").build();
        this.znysImgDataService.save(znysImgData);
        return "dir=" + this.newDirName + ";fileName=" + imgName;
    }

    public String getImgDirName() {
        return this.newDirName;
    }
}

