/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.doccontrast.util.wordpicture;

import com.jxdinfo.idp.common.util.SpringUtils;
import com.jxdinfo.idp.common.util.uuid.IdUtils;
import com.jxdinfo.idp.icpac.doccontrast.entity.po.ZnysImgData;
import com.jxdinfo.idp.icpac.doccontrast.service.IZnysImgDataService;
import fr.opensagres.poi.xwpf.converter.core.ImageManager;
import java.util.Base64;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

public class ImageManagerImpl
extends ImageManager {
    private static final Logger log = LoggerFactory.getLogger(ImageManagerImpl.class);
    private String suffix;
    private String urlPrefix;
    private String newDirName = IdUtils.simpleUUID();
    @Resource
    private IZnysImgDataService znysImgDataService = (IZnysImgDataService)SpringUtils.getBean(IZnysImgDataService.class);

    public ImageManagerImpl(String urlPrefix) {
        super(null, "img");
        this.urlPrefix = urlPrefix;
    }

    public void extract(String imagePath, byte[] imageData) {
        String path = ResourceUtils.getURL((String)"classpath:").getPath() + "static/img/" + this.newDirName + "/";
        String[] imgTypeUri = imagePath.split("/");
        this.suffix = IdUtils.simpleUUID() + imgTypeUri[imgTypeUri.length - 1];
        try {
            ZnysImgData znysImgData = ZnysImgData.builder().objId(IdUtils.simpleUUID()).docId("").imgData(Base64.getEncoder().encodeToString(imageData)).fileName(this.suffix).belongFlag("0").build();
            this.znysImgDataService.save(znysImgData);
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u56fe\u7247\u5931\u8d25", (Object)e.getMessage());
        }
    }

    public String resolve(String uri) {
        return "dir=" + this.newDirName + ";fileName=" + this.suffix;
    }

    public String getImgDirName() {
        return this.newDirName;
    }
}

