/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.doccontrast.util;

import cn.hutool.core.collection.CollectionUtil;
import com.jxdinfo.idp.common.enums.DocRegularEnum;
import com.jxdinfo.idp.icpac.common.entity.FileBytesInfo;
import com.jxdinfo.idp.icpac.doccontrast.util.wordpicture.ImageManagerImpl;
import com.jxdinfo.idp.icpac.doccontrast.util.wordpicture.ImgUrlReplaceUtil;
import com.jxdinfo.idp.icpac.doccontrast.util.wordpicture.PictureManagerImpl;
import com.jxdinfo.idp.icpac.docexamine.entity.location.WordLocation;
import com.jxdinfo.idp.icpac.multisimilaritycompare.utils.SignUtil;
import fr.opensagres.poi.xwpf.converter.core.ImageManager;
import fr.opensagres.poi.xwpf.converter.core.Options;
import fr.opensagres.poi.xwpf.converter.xhtml.XHTMLConverter;
import fr.opensagres.poi.xwpf.converter.xhtml.XHTMLOptions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.HWPFDocumentCore;
import org.apache.poi.hwpf.converter.PicturesManager;
import org.apache.poi.hwpf.converter.WordToHtmlConverter;
import org.apache.poi.hwpf.usermodel.CharacterRun;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.hwpf.usermodel.Table;
import org.apache.poi.hwpf.usermodel.TableCell;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class Word2HtmlUtil {
    private static final Logger log = LoggerFactory.getLogger(Word2HtmlUtil.class);
    private static final String KEY_HTML = "htmlStr";
    @Value(value="${img.url-prefix}")
    private String url_prefix;
    private static String urlPrefix;

    @PostConstruct
    public void setUrlPrefix() {
        urlPrefix = this.url_prefix;
    }

    public static String getUrlPrefix() {
        return urlPrefix;
    }

    public static Map<String, Object> wordToHtml(FileBytesInfo fileInfo, Map<String, WordLocation.ParagraphLocation> pLocationMap, Map<String, WordLocation.TableLocation> tLocationMap) throws ParserConfigurationException, IOException, TransformerException {
        String fileName = fileInfo.getFileName() + "." + fileInfo.getFileFormat();
        Map<Object, Object> html = new HashMap();
        try {
            if (fileName.endsWith(".doc") || fileName.endsWith(".wps")) {
                html = Word2HtmlUtil.docToHtml(fileInfo, pLocationMap, tLocationMap);
            } else if (fileName.endsWith("docx")) {
                html = Word2HtmlUtil.docxToHtml(fileInfo, pLocationMap, tLocationMap);
            } else {
                String htmlText = "<html><head><title>" + fileName + "</title>" + "</head>" + "<body>" + "<h1>\u4e0d\u652f\u6301\u6587\u6863\u7c7b\u578b\uff01</h1>" + "<p>\u652f\u6301\u6587\u6863\u7c7b\u578b\uff1adoc\u3001docx\u3001wps</p>" + "</body>" + "</html>";
                html.put(KEY_HTML, htmlText);
            }
            return ImgUrlReplaceUtil.transTagAttr(html);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            HashMap<String, Object> result = new HashMap<String, Object>();
            String htmlText = "<html><head><title>" + fileName + "</title>" + "</head>" + "<body>" + "<h1>\u6587\u4ef6\u5f02\u5e38</h1>" + "<p>\u65e0\u6cd5\u89e3\u6790\u6587\u4ef6\u3010" + fileName + "\u3011\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u5408\u89c4\uff01</p>" + "</body>" + "</html>";
            result.put(KEY_HTML, htmlText);
            return result;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Map<String, Object> docToHtml(FileBytesInfo fileInfo, Map<String, WordLocation.ParagraphLocation> pLocationMap, Map<String, WordLocation.TableLocation> tLocationMap) throws TransformerException, ParserConfigurationException, IOException {
        HashMap<String, Object> htmlInfo = new HashMap<String, Object>();
        try (HWPFDocument document = new HWPFDocument((InputStream)new ByteArrayInputStream(fileInfo.getFileBytes()));){
            String htmlStr;
            void var9_21;
            Range r = document.getRange();
            for (int i = 0; i < r.numParagraphs(); ++i) {
                String pureText;
                Paragraph paragraph = r.getParagraph(i);
                String text = paragraph.text();
                if (Objects.equals(text, pureText = DocRegularEnum.matchCatalog((String)text))) continue;
                paragraph.replaceText(pureText, false);
            }
            try {
                if (CollectionUtil.isNotEmpty(pLocationMap)) {
                    for (Map.Entry<String, WordLocation.ParagraphLocation> entry : pLocationMap.entrySet()) {
                        WordLocation.ParagraphLocation pLocation = entry.getValue();
                        Integer pIndex = pLocation.getIndex();
                        Paragraph paragraph = r.getParagraph(pIndex == -1 ? r.numParagraphs() - 1 : pIndex);
                        String text = paragraph.text();
                        String newText = null == pLocation.getTextIndex() ? (pLocation.isDelFlag() ? (pLocation.getIndex() != -1 ? SignUtil.markSignPDel(entry.getKey(), "up") : SignUtil.markSignPDel(entry.getKey(), "down")) : SignUtil.markSignP(entry.getKey())) : SignUtil.markSignSpan(entry.getKey(), pLocation.getTextIndex(), pLocation.getTextLength(), pLocation.getTextType());
                        newText = newText + text;
                        paragraph.replaceText(newText, false);
                    }
                }
            }
            catch (Exception e) {
                log.error("\u6bb5\u843d\u6807\u8bb0\u5f02\u5e38");
            }
            try {
                if (CollectionUtil.isNotEmpty(tLocationMap)) {
                    for (Map.Entry<String, WordLocation.TableLocation> entry : tLocationMap.entrySet()) {
                        String newText;
                        WordLocation.TableLocation tLocation = entry.getValue();
                        Integer type = tLocation.getType();
                        Integer pIndex = tLocation.getPIndex();
                        Paragraph tParagraph = r.getParagraph(pIndex.intValue());
                        if (type == 1) {
                            Paragraph cellP;
                            Integer rowIndex = tLocation.getRowIndex();
                            Integer cellIndex = tLocation.getCellIndex();
                            Integer cellPIndex = tLocation.getCellPIndex();
                            Integer textIndex = tLocation.getTextIndex();
                            Integer textLength = tLocation.getTextLength();
                            Table table = r.getTable(tParagraph);
                            TableCell cell = table.getRow(rowIndex.intValue()).getCell(cellIndex.intValue());
                            if (cellPIndex != null && textIndex != null && textLength != null) {
                                cellP = cell.getParagraph(cellPIndex.intValue());
                                newText = SignUtil.markSignSpan(entry.getKey(), textIndex, textLength, 1) + cellP.text();
                                cellP.replaceText(newText, false);
                                continue;
                            }
                            cellP = cell.getParagraph(0);
                            newText = SignUtil.markCell(entry.getKey()) + cellP.text();
                            cellP.replaceText(newText, false);
                            continue;
                        }
                        if (type == 2) {
                            if (pIndex != -1) {
                                newText = SignUtil.markSignPDel(entry.getKey(), "down");
                            } else {
                                newText = SignUtil.markSignPDel(entry.getKey(), "up");
                                pIndex = 0;
                            }
                            Paragraph paragraph = r.getParagraph(pIndex.intValue());
                            newText = newText + paragraph.text();
                            paragraph.replaceText(newText, false);
                            continue;
                        }
                        newText = SignUtil.markTable(entry.getKey()) + tParagraph.text();
                        tParagraph.replaceText(newText, false);
                    }
                }
            }
            catch (Exception e) {
                log.error("\u8868\u683c\u6807\u8bb0\u5f02\u5e38\uff01");
            }
            Range range = document.getRange();
            boolean bl = false;
            while (var9_21 < range.numParagraphs()) {
                Paragraph paragraph = range.getParagraph((int)var9_21);
                for (int j = 0; j < paragraph.numCharacterRuns(); ++j) {
                    CharacterRun run = paragraph.getCharacterRun(j);
                    if (!run.isMarkedDeleted()) continue;
                    run.delete();
                }
                ++var9_21;
            }
            WordToHtmlConverter wordToHtmlConverter = new WordToHtmlConverter(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument());
            PictureManagerImpl pictureManager = new PictureManagerImpl(Word2HtmlUtil.getUrlPrefix());
            wordToHtmlConverter.setPicturesManager((PicturesManager)pictureManager);
            wordToHtmlConverter.processDocument((HWPFDocumentCore)document);
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            serializer.setOutputProperty("encoding", "utf-8");
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("method", "html");
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                serializer.transform(new DOMSource(wordToHtmlConverter.getDocument()), new StreamResult(byteArrayOutputStream));
                htmlStr = byteArrayOutputStream.toString();
            }
            htmlInfo.put(KEY_HTML, htmlStr);
            htmlInfo.put("imgDirName", pictureManager.getImgDirName());
        }
        return htmlInfo;
    }

    private static Map<String, Object> docxToHtml(FileBytesInfo fileInfo, Map<String, WordLocation.ParagraphLocation> pLocationMap, Map<String, WordLocation.TableLocation> tLocationMap) throws IOException {
        HashMap<String, Object> htmlInfo = new HashMap<String, Object>();
        ZipSecureFile.setMinInflateRatio((double)0.0);
        try (XWPFDocument document = new XWPFDocument((InputStream)new ByteArrayInputStream(fileInfo.getFileBytes()));){
            String htmlStr;
            try {
                if (CollectionUtil.isNotEmpty(pLocationMap)) {
                    for (Map.Entry<String, WordLocation.ParagraphLocation> entry : pLocationMap.entrySet()) {
                        WordLocation.ParagraphLocation pLocation = entry.getValue();
                        Integer pIndex = pLocation.getIndex();
                        List paragraphs = document.getParagraphs();
                        XWPFParagraph paragraph = (XWPFParagraph)paragraphs.get(pIndex == -1 ? paragraphs.size() - 1 : pIndex);
                        XWPFRun run = paragraph.getRuns().size() == 0 ? paragraph.createRun() : (XWPFRun)paragraph.getRuns().get(0);
                        String newText = null == pLocation.getTextIndex() ? (pLocation.isDelFlag() ? (pLocation.getIndex() != -1 ? SignUtil.markSignPDel(entry.getKey(), "up") : SignUtil.markSignPDel(entry.getKey(), "down")) : SignUtil.markSignP(entry.getKey())) : SignUtil.markSignSpan(entry.getKey(), pLocation.getTextIndex(), pLocation.getTextLength(), pLocation.getTextType());
                        run.setText(newText + run.text(), 0);
                    }
                }
            }
            catch (Exception e) {
                log.error("\u6bb5\u843d\u6807\u8bb0\u5f02\u5e38", (Throwable)e);
            }
            try {
                if (CollectionUtil.isNotEmpty(tLocationMap)) {
                    for (Map.Entry<String, WordLocation.TableLocation> entry : tLocationMap.entrySet()) {
                        String newText;
                        WordLocation.TableLocation tLocation = entry.getValue();
                        Integer type = tLocation.getType();
                        Integer index = tLocation.getIndex();
                        Integer pIndex = tLocation.getPIndex();
                        XWPFTable table = document.getTableArray(index.intValue());
                        if (type == 1) {
                            XWPFParagraph cellP;
                            Integer rowIndex = tLocation.getRowIndex();
                            Integer cellIndex = tLocation.getCellIndex();
                            Integer cellPIndex = tLocation.getCellPIndex();
                            Integer textIndex = tLocation.getTextIndex();
                            Integer textLength = tLocation.getTextLength();
                            XWPFTableCell cell = table.getRow(rowIndex.intValue()).getCell(cellIndex.intValue());
                            if (cellPIndex != null && textIndex != null && textLength != null) {
                                cellP = cell.getParagraphArray(cellPIndex.intValue());
                                XWPFRun run = (XWPFRun)cellP.getRuns().get(0);
                                newText = SignUtil.markSignSpan(entry.getKey(), textIndex, textLength, 1) + run.text();
                                run.setText(newText, 0);
                                continue;
                            }
                            cellP = cell.getParagraphArray(0);
                            List runs = cellP.getRuns();
                            XWPFRun run = CollectionUtil.isEmpty((Collection)runs) ? cellP.createRun() : (XWPFRun)runs.get(0);
                            newText = SignUtil.markCell(entry.getKey()) + run.text();
                            run.setText(newText, 0);
                            continue;
                        }
                        if (type == 2) {
                            XWPFParagraph paragraph;
                            if (pIndex != -1) {
                                newText = SignUtil.markSignPDel(entry.getKey(), "down");
                            } else {
                                newText = SignUtil.markSignPDel(entry.getKey(), "up");
                                pIndex = 0;
                            }
                            if ((paragraph = document.getParagraphArray(pIndex.intValue())) == null) continue;
                            XWPFRun run = paragraph.getRuns().size() == 0 ? paragraph.createRun() : (XWPFRun)paragraph.getRuns().get(0);
                            newText = newText + run.text();
                            run.setText(newText, 0);
                            continue;
                        }
                        XWPFParagraph cellP = table.getRow(0).getCell(0).getParagraphArray(0);
                        List runs = cellP.getRuns();
                        XWPFRun run = CollectionUtil.isEmpty((Collection)runs) ? cellP.createRun() : (XWPFRun)runs.get(0);
                        newText = SignUtil.markTable(entry.getKey()) + run.text();
                        run.setText(newText, 0);
                    }
                }
            }
            catch (Exception e) {
                log.error("\u8868\u683c\u6807\u8bb0\u5f02\u5e38\uff01", (Throwable)e);
            }
            Throwable throwable = null;
            try (ByteArrayOutputStream afterOutputStream = new ByteArrayOutputStream();){
                document.write((OutputStream)afterOutputStream);
                fileInfo.setFileBytes(afterOutputStream.toByteArray());
            }
            catch (Throwable tLocation) {
                Throwable throwable2 = tLocation;
                throw tLocation;
            }
            XHTMLOptions options = XHTMLOptions.create();
            ImageManagerImpl imageManagerImpl = new ImageManagerImpl(Word2HtmlUtil.getUrlPrefix());
            options.setImageManager((ImageManager)imageManagerImpl);
            options.setIgnoreStylesIfUnused(false);
            options.setFragment(true);
            try (ByteArrayOutputStream byteOut = new ByteArrayOutputStream();){
                XHTMLConverter.getInstance().convert(document, (OutputStream)byteOut, (Options)options);
                htmlStr = byteOut.toString();
            }
            htmlInfo.put(KEY_HTML, htmlStr);
            htmlInfo.put("imgDirName", imageManagerImpl.getImgDirName());
        }
        return htmlInfo;
    }

    public static String docxToHtml(XWPFDocument document) {
        String htmlStr;
        XHTMLOptions options = XHTMLOptions.create();
        ImageManagerImpl imageManager = new ImageManagerImpl(Word2HtmlUtil.getUrlPrefix());
        options.setImageManager((ImageManager)imageManager);
        options.setIgnoreStylesIfUnused(false);
        options.setFragment(true);
        try (ByteArrayOutputStream byteOut = new ByteArrayOutputStream();){
            XHTMLConverter.getInstance().convert(document, (OutputStream)byteOut, (Options)options);
            htmlStr = byteOut.toString();
        }
        catch (IOException e) {
            log.error("docx\u8f6chtml\u5f02\u5e38\uff01");
            throw new RuntimeException(e);
        }
        return htmlStr;
    }
}

