/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.doccontrast.util;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.imageio.ImageIO;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.poi.hemf.usermodel.HemfPicture;
import org.apache.poi.hwpf.usermodel.PictureType;
import org.apache.poi.util.Units;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class ImgTransUtil {
    private static final Logger log = LoggerFactory.getLogger(ImgTransUtil.class);

    private ImgTransUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static String transToPic(byte[] bytes, String outPath, PictureType pictureType) {
        String lastPicName = "";
        switch (pictureType) {
            case EMF: {
                lastPicName = ImgTransUtil.emfToPng(bytes, outPath);
                break;
            }
            case WMF: {
                lastPicName = ImgTransUtil.wmfToSvg(bytes, outPath);
                break;
            }
            case UNKNOWN: {
                lastPicName = ImgTransUtil.unKnowType(bytes, outPath);
                break;
            }
        }
        return lastPicName;
    }

    /*
     * Exception decompiling
     */
    private static String wmfToSvg(byte[] bytes, String outPath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void output(Document doc, OutputStream out) throws Exception {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("doctype-public", "-//W3C//DTD SVG 1.0//EN");
        transformer.setOutputProperty("doctype-system", "http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd");
        transformer.transform(new DOMSource(doc), new StreamResult(out));
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            transformer.transform(new DOMSource(doc), new StreamResult(bos));
            out.flush();
        }
    }

    private static String emfToPng(byte[] bytes, String outPath) {
        outPath = outPath.replace("emf", "PNG");
        try {
            File imgFile = new File(outPath);
            if (!imgFile.getParentFile().exists()) {
                imgFile.getParentFile().mkdirs();
            }
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u7236\u76ee\u5f55\u5931\u8d25" + e);
        }
        try {
            ByteArrayInputStream byteIn = new ByteArrayInputStream(bytes);
            HemfPicture emf = new HemfPicture((InputStream)byteIn);
            Dimension2D dim = emf.getSize();
            int width = Units.pointsToPixel((double)dim.getWidth());
            int height = Units.pointsToPixel((double)dim.getHeight());
            double max = Math.max(width, height);
            BigDecimal maxDecimal = BigDecimal.valueOf(max);
            BigDecimal baseDecimal = new BigDecimal(1500);
            if (max > 1500.0) {
                width *= baseDecimal.divide(maxDecimal, 2, RoundingMode.HALF_UP).intValue();
                height *= baseDecimal.divide(maxDecimal, 2, RoundingMode.HALF_UP).intValue();
            }
            BufferedImage bufImg = new BufferedImage(width, height, 2);
            Graphics2D g = bufImg.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            emf.draw(g, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, width, height));
            g.dispose();
            File file = new File(outPath);
            ImageIO.write((RenderedImage)bufImg, "PNG", file);
            byteIn.close();
            return file.getName();
        }
        catch (IOException e) {
            log.info("emf\u8f6cpng\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
            return "";
        }
    }

    private static String unKnowType(byte[] data, String outPath) {
        return "";
    }
}

