/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.doccontrast.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import com.jxdinfo.idp.common.util.uuid.IdUtils;
import com.jxdinfo.idp.dio.service.FileService;
import com.jxdinfo.idp.icpac.common.entity.FileBytesInfo;
import com.jxdinfo.idp.icpac.common.entity.dto.ExtractElementDto;
import com.jxdinfo.idp.icpac.common.service.IExtractElementService;
import com.jxdinfo.idp.icpac.common.util.FileUtils;
import com.jxdinfo.idp.icpac.doccontrast.entity.ContrastResult;
import com.jxdinfo.idp.icpac.doccontrast.entity.ContrastTask;
import com.jxdinfo.idp.icpac.doccontrast.entity.dto.ContrastFileInfoDto;
import com.jxdinfo.idp.icpac.doccontrast.entity.dto.ContrastTaskDto;
import com.jxdinfo.idp.icpac.doccontrast.entity.dto.DocContrastDto;
import com.jxdinfo.idp.icpac.doccontrast.entity.po.DocSubtask;
import com.jxdinfo.idp.icpac.doccontrast.entity.query.ContrastResultQuery;
import com.jxdinfo.idp.icpac.doccontrast.entity.query.ContrastTaskQuery;
import com.jxdinfo.idp.icpac.doccontrast.entity.query.DocContrastQuery;
import com.jxdinfo.idp.icpac.doccontrast.entity.request.PDFContrastRequest;
import com.jxdinfo.idp.icpac.doccontrast.service.IContrastResultService;
import com.jxdinfo.idp.icpac.doccontrast.service.IContrastTaskService;
import com.jxdinfo.idp.icpac.doccontrast.service.IDocContrastService;
import com.jxdinfo.idp.icpac.doccontrast.service.IDocExamineService;
import com.jxdinfo.idp.icpac.doccontrast.service.IDocSubtaskService;
import com.jxdinfo.idp.icpac.doccontrast.util.CompareUtil;
import com.jxdinfo.idp.icpac.doccontrast.util.ReadPdfUtil;
import com.jxdinfo.idp.icpac.doccontrast.util.SignUtil;
import com.jxdinfo.idp.icpac.doccontrast.util.StringUtils;
import com.jxdinfo.idp.icpac.doccontrast.util.Word2HtmlUtil;
import com.jxdinfo.idp.icpac.docexamine.entity.location.WordLocation;
import com.jxdinfo.idp.icpac.feign.DocContrastFeign;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.WordElementInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordParagraphInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordStructureInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordTableInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.utils.ReadWordUtil;
import com.jxdinfo.idp.icpac.stream.impl.FileParserFactory;
import com.jxdinfo.idp.interf.DocService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DocContrastServiceImpl
implements IDocContrastService {
    private static final Logger log = LoggerFactory.getLogger(DocContrastServiceImpl.class);
    public static Map<String, String> filePathCache = new HashMap<String, String>();
    @Autowired
    private IContrastTaskService taskService;
    @Autowired
    private IContrastResultService resultService;
    @Autowired
    private IDocSubtaskService subtaskService;
    @Autowired
    private IDocExamineService examineService;
    @Autowired
    private DocService docService;
    @Autowired
    private DocContrastFeign docContrastFeign;
    @Autowired
    private IExtractElementService extractElementService;
    @Autowired
    private FileService fileService;
    @Value(value="${zyns.file.compareFlag}")
    private boolean compareFlag;

    @Override
    public Page<ContrastTaskDto> getTaskList(ContrastTaskQuery query) {
        return this.taskService.getPageList(query);
    }

    @Override
    public void deleteTask(DocContrastQuery query) throws JSchException, SftpException, IOException {
        this.taskService.delete(query);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String contrast(DocContrastDto dto) throws Exception {
        ContrastTask contrastTask = new ContrastTask();
        contrastTask.setDocVersionId(dto.getDocVersionId());
        Long leftFileId = dto.getLeftFileId();
        contrastTask.setLeftFileId(leftFileId);
        if (filePathCache.containsKey(leftFileId)) {
            contrastTask.setLeftAnnexPath(filePathCache.get(leftFileId));
        }
        Long rightFileId = dto.getRightFileId();
        contrastTask.setRightFileId(rightFileId);
        if (filePathCache.containsKey(rightFileId)) {
            contrastTask.setRightAnnexPath(filePathCache.get(rightFileId));
        }
        contrastTask.setLeftFileSize(dto.getLeftSize());
        contrastTask.setRightFileSize(dto.getRightSize());
        String result = this.taskService.insert(contrastTask);
        this.contrast(contrastTask, dto);
        filePathCache.remove(leftFileId);
        filePathCache.remove(rightFileId);
        return result;
    }

    @Override
    public List<ContrastResult> getResultList(ContrastResultQuery query) {
        return this.resultService.getList(query);
    }

    @Override
    public void getStream(HttpServletResponse response, DocContrastQuery query) throws Exception {
        FileBytesInfo fileInfo = FileUtils.getBytesInfo(query.getFileId());
        ContrastTask contrastTask = (ContrastTask)this.taskService.getById((Serializable)((Object)query.getTaskId()));
        String filename = fileInfo.getFileName();
        String flag = "right";
        if (query.getFileId().equals(contrastTask.getLeftFileId())) {
            flag = "left";
        }
        if ("docx".equals(fileInfo.getFileFormat()) || "doc".equals(fileInfo.getFileFormat()) || "wps".equals(fileInfo.getFileFormat())) {
            this.getHtmlStream(response, query.getFileId(), query.getTaskId(), flag, "");
        } else if ("pdf".equals(fileInfo.getFileFormat())) {
            if (flag.equals("left")) {
                System.out.println("======================\u9884\u89c8\u8def\u5f84" + fileInfo.getContrastPath());
                this.getHtmlStream(response, query.getFileId(), query.getTaskId(), flag, fileInfo.getContrastPath());
            } else {
                this.getHtmlStream(response, query.getFileId(), query.getTaskId(), flag, fileInfo.getContrastPath());
            }
        } else {
            FileParserFactory.get("common").download(response, query.getFileId(), null, null);
        }
    }

    private void getHtmlStream(HttpServletResponse response, Long fileId, String taskId, String flag, String path) throws Exception {
        Document doc;
        Map<String, Object> htmlInfo;
        FileBytesInfo docFileInfo;
        block53: {
            String contentType;
            docFileInfo = FileUtils.getBytesInfo(fileId);
            if (docFileInfo != null && "pdf".equals(docFileInfo.getFileFormat())) {
                docFileInfo.setFileFormat("docx");
                if (path == null) {
                    FileBytesInfo fileBytesInfo = new FileBytesInfo();
                    fileBytesInfo.setFileBytes(docFileInfo.getFileBytes());
                    fileBytesInfo.setFileName(docFileInfo.getFileName());
                    fileBytesInfo.setFileFormat(docFileInfo.getFileFormat());
                    this.turnPDFToDocx(fileBytesInfo);
                    docFileInfo.setFileBytes(fileBytesInfo.getFileBytes());
                } else {
                    docFileInfo.setFileBytes(FileUtils.getByPath(path));
                }
            }
            LinkedHashMap<String, WordLocation.ParagraphLocation> pLocationMap = new LinkedHashMap<String, WordLocation.ParagraphLocation>();
            LinkedHashMap<String, WordLocation.TableLocation> tLocationMap = new LinkedHashMap<String, WordLocation.TableLocation>();
            HashMap<String, String> matchTextMap = new HashMap<String, String>();
            HashMap<String, String> eTypeMap = new HashMap<String, String>();
            List<ContrastResult> contrastResultList = this.resultService.getList(taskId);
            HashMap<String, String> typeMap = new HashMap<String, String>();
            Collections.reverse(contrastResultList);
            String string = contentType = "left".equals(flag) ? "0" : "1";
            if (CollectionUtil.isNotEmpty(contrastResultList)) {
                for (ContrastResult contrastResult : contrastResultList) {
                    Object tLocation;
                    WordLocation wordLocation;
                    if ("left".equals(flag)) {
                        matchTextMap.put(String.valueOf(contrastResult.getId()), contrastResult.getLeftResult());
                        wordLocation = (WordLocation)JSON.parseObject((String)contrastResult.getLeftLocation(), WordLocation.class);
                    } else {
                        matchTextMap.put(String.valueOf(contrastResult.getId()), contrastResult.getRightResult());
                        wordLocation = (WordLocation)JSON.parseObject((String)contrastResult.getRightLocation(), WordLocation.class);
                    }
                    if (wordLocation == null) continue;
                    WordLocation.ParagraphLocation pLocation = wordLocation.getPLocation();
                    if (null != pLocation) {
                        wordLocation.getPLocation().setTextType(Integer.parseInt(contrastResult.getType()));
                        pLocationMap.put(String.valueOf(contrastResult.getId()), pLocation);
                    }
                    if ((tLocation = wordLocation.getTLocation()) != null) {
                        tLocationMap.put(String.valueOf(contrastResult.getId()), (WordLocation.TableLocation)tLocation);
                    }
                    eTypeMap.put(String.valueOf(contrastResult.getId()), contrastResult.getElementType());
                    if (typeMap.get(contrastResult.getId()) == null) {
                        typeMap.put(String.valueOf(contrastResult.getId()), contrastResult.getType());
                        continue;
                    }
                    typeMap.put(String.valueOf(contrastResult.getId()), "-1");
                }
            }
            htmlInfo = Word2HtmlUtil.wordToHtml(docFileInfo, pLocationMap, tLocationMap);
            String htmlStr = (String)htmlInfo.get("htmlStr");
            doc = Jsoup.parse((String)htmlStr);
            Elements pList = doc.getElementsByTag("p");
            try {
                Matcher matcher;
                for (Iterator element : pList) {
                    String signClass;
                    String signId;
                    List<String> signs;
                    String signText = element.text();
                    if (StringUtils.isEmpty(signText) || !signText.contains("sign_")) continue;
                    List<Element> elementList = com.jxdinfo.idp.icpac.multisimilaritycompare.utils.SignUtil.findTextElements((Element)element);
                    String allText = this.getAllText(elementList);
                    if (signText.contains("sign_p_del") && StringUtils.isNotEmpty(signs = com.jxdinfo.idp.icpac.multisimilaritycompare.utils.SignUtil.matchSignPDel(signText))) {
                        for (String sign : signs) {
                            Matcher matcher2 = com.jxdinfo.idp.icpac.multisimilaritycompare.utils.SignUtil.matchSignPDelProp(sign);
                            if (matcher2 == null) continue;
                            String signId2 = matcher2.group(1);
                            String position = matcher2.group(2);
                            Element affixElement = new Element("p");
                            affixElement.attr("data-id", "content" + (String)signId2);
                            affixElement.attr("class", SignUtil.getEClass((String)eTypeMap.get(signId2)));
                            affixElement.attr("data-type", contentType);
                            affixElement.addClass("border-left" + (String)eTypeMap.get(signId2)).addClass("border-right" + (String)eTypeMap.get(signId2));
                            if ("up".equals(position)) {
                                Element clone = element.clone();
                                element.empty();
                                element.appendChild((Node)affixElement);
                                element.appendChildren((Collection)clone.children());
                            }
                            if (!"down".equals(position)) continue;
                            element.appendChild((Node)affixElement);
                        }
                    }
                    if (signText.contains("sign_p") && (matcher = com.jxdinfo.idp.icpac.multisimilaritycompare.utils.SignUtil.matchSignPProp(signText)) != null) {
                        signId = matcher.group(1);
                        element.attr("data-id", "content" + signId);
                        signClass = (String)eTypeMap.get(signId);
                        element.attr("data-type", contentType);
                        element.addClass(SignUtil.getEClass(signClass)).addClass("border-left" + signClass).addClass("border-right" + signClass);
                    }
                    if (signText.contains("sign_span")) {
                        TreeSet<Integer> indexSet = new TreeSet<Integer>();
                        HashMap<Integer, Element> eCache = new HashMap<Integer, Element>();
                        HashMap<Integer, Element> delECache = new HashMap<Integer, Element>();
                        List<String> signs2 = com.jxdinfo.idp.icpac.multisimilaritycompare.utils.SignUtil.matchSignSpan(signText);
                        if (CollectionUtil.isNotEmpty(signs2)) {
                            for (String sign : signs2) {
                                Matcher matcher3 = com.jxdinfo.idp.icpac.multisimilaritycompare.utils.SignUtil.matchSignSpanProp(sign);
                                if (matcher3 == null) continue;
                                String signId3 = matcher3.group(1);
                                String matchText = (String)matchTextMap.get(signId3);
                                int eIndex = Integer.parseInt(matcher3.group(2));
                                int eLength = Integer.parseInt(matcher3.group(3));
                                int eEndIndex = Math.min(eIndex + eLength, allText.length());
                                if (matchText != null && eIndex != -1) {
                                    if (eIndex >= allText.length()) {
                                        int index2 = CompareUtil.relocate(allText, matchText, eIndex);
                                        if (index2 != -1) {
                                            eIndex = index2;
                                        }
                                    } else {
                                        int index3;
                                        String targetText = allText.substring(eIndex, eEndIndex);
                                        if (!targetText.contains(matchText) && (index3 = CompareUtil.relocate(allText, matchText, eIndex)) != -1) {
                                            eIndex = index3;
                                        }
                                    }
                                }
                                eEndIndex = Math.min(eIndex + eLength, allText.length());
                                if (eLength == 0 || eLength == -1) {
                                    Element span = delECache.computeIfAbsent(eIndex, k -> new Element("span"));
                                    span.attr("data-type", contentType);
                                    span.attr("data-id", "content" + signId3);
                                    span.addClass(SignUtil.getEClass((String)eTypeMap.get(signId3))).attr("length", String.valueOf(eLength)).addClass("border-left" + (String)eTypeMap.get(signId3)).addClass("border-right" + (String)eTypeMap.get(signId3));
                                    indexSet.add(eIndex);
                                }
                                for (int i = eIndex; i < eEndIndex && i < allText.length(); ++i) {
                                    Element span = (Element)eCache.get(i);
                                    if (null == span) {
                                        span = new Element("span");
                                        eCache.put(i, span);
                                        indexSet.add(i);
                                    }
                                    span.text(String.valueOf(allText.charAt(i)));
                                    String eType = (String)eTypeMap.get(signId3);
                                    span.addClass(SignUtil.getEClass(eType));
                                    if (i == eIndex) {
                                        span.addClass("border-left" + eType);
                                    }
                                    if (i == eEndIndex - 1) {
                                        span.addClass("border-right" + eType);
                                    }
                                    span.attr("data-type", contentType);
                                    String type = (String)typeMap.get(signId3);
                                    if ("-1".equals(type) || "1".equals(type)) {
                                        span.attr("name", signId3);
                                    }
                                    if (!"-1".equals(type) && !"0".equals(type)) continue;
                                    span.attr("data-id", "content" + signId3);
                                }
                            }
                        }
                        int textLength = allText.length();
                        indexSet.removeIf(index -> index >= textLength);
                        List indexList = indexSet.stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList());
                        int currentStartIndex = -1;
                        int currentEIndex = 0;
                        Element current = elementList.get(currentEIndex);
                        String currentText = com.jxdinfo.idp.icpac.multisimilaritycompare.utils.SignUtil.text(current.toString());
                        int beforeTextLength = currentText.length();
                        boolean handleFlag = true;
                        for (Integer index4 : indexList) {
                            Element delElement;
                            while (index4 >= beforeTextLength && ++currentEIndex < elementList.size()) {
                                if (currentStartIndex != -1 && currentStartIndex < currentText.length() - 1) {
                                    current.appendText(currentText.substring(currentStartIndex + 1));
                                }
                                current = elementList.get(currentEIndex);
                                currentText = com.jxdinfo.idp.icpac.multisimilaritycompare.utils.SignUtil.text(current.toString());
                                beforeTextLength += currentText.length();
                                currentStartIndex = -1;
                                handleFlag = true;
                            }
                            int currentIndex = index4 - beforeTextLength + currentText.length();
                            if (handleFlag) {
                                current.text("");
                                handleFlag = false;
                            }
                            if (currentIndex - currentStartIndex > 1) {
                                String commonText = currentText.substring(currentStartIndex + 1, currentIndex);
                                current.appendText(commonText);
                            }
                            if (eCache.get(index4) != null) {
                                current.appendChild((Node)eCache.get(index4));
                            }
                            if ((delElement = (Element)delECache.get(index4)) != null) {
                                String length = delElement.attr("length");
                                if ("-1".equals(length)) {
                                    current.appendChild((Node)delElement);
                                }
                                if (eCache.get(index4) == null) {
                                    current.appendText(String.valueOf(allText.charAt(Math.max(0, index4))));
                                }
                                if ("0".equals(length)) {
                                    current.appendChild((Node)delElement);
                                }
                            }
                            currentStartIndex = currentIndex;
                        }
                        if (currentStartIndex != -1 && currentStartIndex < currentText.length() - 1) {
                            current.appendText(currentText.substring(currentStartIndex + 1));
                        }
                    }
                    if (signText.contains("sign_cell") && (matcher = SignUtil.matchSignCellProp(signText)) != null) {
                        signId = matcher.group(1);
                        Element parent = element.parent();
                        Element div = new Element("div");
                        div.attr("style", "width:100%; min-height:32px");
                        if (parent != null) {
                            div.appendChildren((Collection)parent.childNodes());
                        }
                        parent.children().remove();
                        parent.appendChild((Node)div);
                        String type = (String)typeMap.get(signId);
                        if ("-1".equals(type) || "1".equals(type)) {
                            div.attr("name", signId);
                        }
                        if ("-1".equals(type) || "0".equals(type)) {
                            div.attr("data-id", "content" + signId);
                        }
                        String signClass2 = (String)eTypeMap.get(signId);
                        div.attr("data-type", contentType);
                        div.addClass(SignUtil.getEClass(signClass2));
                    }
                    if (!signText.contains("sign_table") || (matcher = SignUtil.matchSignTableProp(signText)) == null) continue;
                    String singId = matcher.group(1);
                    signClass = (String)eTypeMap.get(singId);
                    Element table = this.getTable((Element)element);
                    String type = (String)typeMap.get(singId);
                    if ("-1".equals(type) || "1".equals(type)) {
                        table.attr("name", singId);
                    }
                    if ("-1".equals(type) || "0".equals(type)) {
                        table.attr("data-id", "content" + singId);
                    }
                    if (table == null) continue;
                    table.attr("data-id", "content" + singId).attr("data-type", contentType).addClass(SignUtil.getEClass(signClass));
                }
                if (!docFileInfo.getFileName().endsWith(".docx")) break block53;
                Elements divList = doc.getElementsByTag("div");
                for (Element element : divList) {
                    String style = element.attr("style");
                    Pattern pattern = Pattern.compile("(width.*?;)");
                    matcher = pattern.matcher(style);
                    if (matcher.find()) {
                        style = style.replace(matcher.group(), "");
                    }
                    element.attr("style", style);
                }
            }
            catch (Exception e) {
                log.error("html\u521b\u5efa\u6807\u7b7e\u5f02\u5e38", (Throwable)e);
                for (Element element : pList) {
                    if (!element.text().contains("sign_")) continue;
                    SignUtil.findTextElements(element);
                }
            }
        }
        Element imgDirName = new Element("div");
        imgDirName.attr("display", "none").addClass("iamge-dir-name").attr("name", (String)htmlInfo.get("imgDirName"));
        doc.appendChild((Node)imgDirName);
        response.reset();
        response.setContentType("text/html;charset=UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + docFileInfo.getFileName());
        ServletOutputStream outputStream = response.getOutputStream();
        if (docFileInfo.getFileFormat().equals("doc")) {
            Document document = Document.createShell((String)"");
            Element div = new Element("div");
            div.attr("style", "margin-bottom:72.0pt;margin-top:72.0pt;margin-left:90.0pt;margin-right:90.0pt;");
            div.appendChild((Node)doc.body().clone());
            document.body().appendChild((Node)div);
            outputStream.write(document.html().getBytes(StandardCharsets.UTF_8));
        } else {
            outputStream.write(doc.html().getBytes(StandardCharsets.UTF_8));
        }
        outputStream.flush();
    }

    @Override
    public ContrastTaskDto getTaskById(ContrastTaskQuery query) {
        ContrastTaskDto result = this.taskService.getById(query);
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        String[] Units = new String[]{"BYTE", "KB", "MB", "GB", "TB"};
        Double leftSize = result.getLeftFileSize();
        if (leftSize == null) {
            return result;
        }
        int leftPoint = 0;
        while (leftSize / 1024.0 > 1.0) {
            leftSize = leftSize / 1024.0;
            ++leftPoint;
        }
        result.setLeftUnit(Units[leftPoint]);
        result.setLeftFileSize(Double.parseDouble(decimalFormat.format(leftSize)));
        Double rightSize = result.getRightFileSize();
        int rightPoint = 0;
        while (rightSize / 1024.0 > 1.0) {
            rightSize = rightSize / 1024.0;
            ++rightPoint;
        }
        result.setRightUnit(Units[rightPoint]);
        result.setRightFileSize(Double.parseDouble(decimalFormat.format(rightSize)));
        return result;
    }

    private void contrast(ContrastTask contrastTask, DocContrastDto dto) throws Exception {
        dto.setCompareFlag(this.compareFlag);
        ArrayList<ContrastResult> contrastResultList = new ArrayList<ContrastResult>(this.allInfoContrast(contrastTask, dto));
        for (ContrastResult contrastResult : contrastResultList) {
            WordLocation wordLeftLocation = (WordLocation)JSON.parseObject((String)contrastResult.getLeftLocation(), WordLocation.class);
            WordLocation wordRightLocation = (WordLocation)JSON.parseObject((String)contrastResult.getLeftLocation(), WordLocation.class);
            if (wordLeftLocation == null) continue;
            WordLocation.ParagraphLocation leftPLocation = wordLeftLocation.getPLocation();
            WordLocation.ParagraphLocation rightPLocation = wordRightLocation.getPLocation();
            WordLocation.TableLocation leftTLocation = wordLeftLocation.getTLocation();
            WordLocation.TableLocation rightTLocation = wordRightLocation.getTLocation();
            if (leftPLocation != null) {
                if (leftPLocation.getIndex() == -1) {
                    contrastResult.setParagraphIndex(10000.0 + (double)rightPLocation.getIndex().intValue());
                    continue;
                }
                if (rightPLocation.getTextIndex() != null) {
                    contrastResult.setParagraphIndex((double)leftPLocation.getIndex().intValue() + (double)rightPLocation.getIndex().intValue() / 100.0 + (double)rightPLocation.getTextIndex().intValue() / 1000000.0);
                    continue;
                }
                contrastResult.setParagraphIndex((double)leftPLocation.getIndex().intValue() + (double)rightPLocation.getIndex().intValue() / 100.0);
                continue;
            }
            if (leftTLocation.getPIndex() != null && leftTLocation.getPIndex() == -1) {
                contrastResult.setParagraphIndex(10000.0 + (double)rightTLocation.getPIndex().intValue());
                continue;
            }
            if (leftTLocation.getPIndex() != null && rightTLocation.getPIndex() != null) {
                contrastResult.setParagraphIndex((double)leftTLocation.getPIndex().intValue() + (double)rightTLocation.getPIndex().intValue() / 100.0);
                if (rightTLocation.getRowIndex() == null) continue;
                contrastResult.setParagraphIndex(contrastResult.getParagraphIndex() + (double)rightTLocation.getRowIndex().intValue() / 10000.0);
                if (rightTLocation.getCellIndex() == null) continue;
                contrastResult.setParagraphIndex(contrastResult.getParagraphIndex() + (double)rightTLocation.getCellIndex().intValue() / 1000000.0);
                if (rightTLocation.getTextIndex() == null) continue;
                contrastResult.setParagraphIndex(contrastResult.getParagraphIndex() + (double)rightTLocation.getTextIndex().intValue() / 1.0E8);
                continue;
            }
            contrastResult.setParagraphIndex(0.0);
        }
        if (contrastTask.getDocVersionId() != null) {
            contrastResultList.addAll(this.keyInfoContrast(contrastTask));
        }
        this.resultService.saveBatch(contrastResultList);
    }

    private String saveSubtask(Long fileId, Long docVersionId, String taskId) {
        DocSubtask subtask = new DocSubtask();
        subtask.setId(IdUtils.simpleUUID());
        subtask.setDocId(fileId);
        subtask.setDocVersionId(docVersionId);
        subtask.setTaskId(taskId);
        this.subtaskService.save(subtask);
        return subtask.getId();
    }

    public void turnPDFToDocx(FileBytesInfo FileInfo) throws Exception {
        PDDocument document = Loader.loadPDF((byte[])FileInfo.getFileBytes());
        ReadPdfUtil.removeTextWatermark(document);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        document.save((OutputStream)outputStream);
        FileInfo.setFileBytes(outputStream.toByteArray());
        PDFContrastRequest request = new PDFContrastRequest();
        request.setFilePath(FileInfo.getFilePath());
        request.setFile_type("PDF");
        request.setFilter_header_footer("1");
        request.setMerge_cross_paraph("1");
        ResponseEntity<byte[]> entity = this.docContrastFeign.turnPDFToWord(request);
        FileInfo.setFileBytes((byte[])entity.getBody());
        FileInfo.setFileFormat("docx");
    }

    private String getAllText(List<Element> elements) {
        StringBuilder buffer = new StringBuilder();
        for (Element element : elements) {
            buffer.append(com.jxdinfo.idp.icpac.multisimilaritycompare.utils.SignUtil.text(element.toString()));
        }
        return buffer.toString();
    }

    private Element getTable(Element element) {
        Element parent = element.parent();
        if (parent != null) {
            if ("table".equals(parent.tagName())) {
                return parent;
            }
            return this.getTable(parent);
        }
        return null;
    }

    private List<ContrastResult> allInfoContrast(ContrastTask contrastTask, DocContrastDto query) throws Exception {
        FileBytesInfo rightFileInfo;
        FileBytesInfo leftFileInfo = FileUtils.getBytesInfo(contrastTask.getLeftFileId());
        if (leftFileInfo != null && "pdf".equals(leftFileInfo.getFileFormat())) {
            if (leftFileInfo.getFileBytes() == null) {
                leftFileInfo.setFileBytes(this.fileService.download(leftFileInfo.getFilePath()));
                this.turnPDFToDocx(leftFileInfo);
                MockMultipartFile multipartFile = new MockMultipartFile(leftFileInfo.getFileName(), leftFileInfo.getFileBytes());
                String docxPath = FileUtils.copyFile(multipartFile.getInputStream(), multipartFile.getName(), leftFileInfo.getContrastPath());
            }
            leftFileInfo.setFileFormat("docx");
        }
        if ((rightFileInfo = FileUtils.getBytesInfo(contrastTask.getRightFileId())) != null && "pdf".equals(rightFileInfo.getFileFormat())) {
            if (rightFileInfo.getFileBytes() == null) {
                rightFileInfo.setFileBytes(this.fileService.download(rightFileInfo.getFilePath()));
                this.turnPDFToDocx(rightFileInfo);
                MockMultipartFile multipartFile = new MockMultipartFile(rightFileInfo.getFileName(), rightFileInfo.getFileBytes());
                String docxPath = FileUtils.copyFile(multipartFile.getInputStream(), multipartFile.getName(), rightFileInfo.getContrastPath());
            }
            rightFileInfo.setFileFormat("docx");
        }
        ContrastFileInfoDto fileInfoDto = new ContrastFileInfoDto();
        fileInfoDto.setLeftFileInfo(leftFileInfo);
        fileInfoDto.setRightFileInfo(rightFileInfo);
        fileInfoDto.setId(contrastTask.getId());
        List<ContrastResult> paragraphContrast = this.ParagraphContrast(fileInfoDto, query);
        ArrayList<ContrastResult> results = new ArrayList<ContrastResult>(paragraphContrast);
        if (!query.isTableCompare()) {
            results.addAll(this.TableContrast(fileInfoDto, query));
        }
        return results;
    }

    private List<ContrastResult> TableContrast(ContrastFileInfoDto fileInfoDto, DocContrastDto query) throws Exception {
        WordStructureInfo rightWordStructureInfo;
        List<WordTableInfo> rightTables;
        WordStructureInfo leftWordStructureInfo = ReadWordUtil.getWordInfo(fileInfoDto.getLeftFileInfo());
        List<WordTableInfo> leftTables = leftWordStructureInfo.getTableInfos();
        List<ContrastResult> contrastResultList = CompareUtil.compareTable(leftTables, rightTables = (rightWordStructureInfo = ReadWordUtil.getWordInfo(fileInfoDto.getRightFileInfo())).getTableInfos(), query);
        if (!contrastResultList.isEmpty()) {
            for (ContrastResult result : contrastResultList) {
                int i;
                result.setTaskId(fileInfoDto.getId());
                WordLocation leftLocation = (WordLocation)JSON.parseObject((String)result.getLeftLocation(), WordLocation.class);
                WordLocation rightLocation = (WordLocation)JSON.parseObject((String)result.getRightLocation(), WordLocation.class);
                WordLocation.TableLocation leftTLocation = leftLocation.getTLocation();
                WordLocation.TableLocation rightTLocation = rightLocation.getTLocation();
                if (leftTLocation.getIndex() == -2) {
                    i = 0;
                    while (rightTLocation.getPIndex() - i >= 0 && CompareUtil.searchPIndex(fileInfoDto, rightTLocation.getPIndex() - i, true) == -1) {
                        ++i;
                    }
                    leftTLocation.setPIndex(CompareUtil.searchPIndex(fileInfoDto, rightTLocation.getPIndex() - i, true));
                    leftTLocation.setType(2);
                    result.setLeftLocation(JSON.toJSONString((Object)leftLocation));
                    result.setRightLocation(JSON.toJSONString((Object)rightLocation));
                    continue;
                }
                if (rightTLocation.getIndex() != -2) continue;
                i = 0;
                while (leftTLocation.getPIndex() - i >= 0 && CompareUtil.searchPIndex(fileInfoDto, leftTLocation.getPIndex() - i, false) == -1) {
                    ++i;
                }
                rightTLocation.setPIndex(CompareUtil.searchPIndex(fileInfoDto, leftTLocation.getPIndex() - i, false));
                rightTLocation.setType(2);
                result.setLeftLocation(JSON.toJSONString((Object)leftLocation));
                result.setRightLocation(JSON.toJSONString((Object)rightLocation));
            }
        }
        return contrastResultList;
    }

    private List<ContrastResult> keyInfoContrast(ContrastTask contrastTask) {
        String leftSubtaskId = this.saveSubtask(contrastTask.getLeftFileId(), contrastTask.getDocVersionId(), contrastTask.getId());
        String rightSubtaskId = this.saveSubtask(contrastTask.getRightFileId(), contrastTask.getDocVersionId(), contrastTask.getId());
        this.examineService.extract(leftSubtaskId, null);
        this.examineService.extract(rightSubtaskId, null);
        List<ExtractElementDto> leftElementList = this.extractElementService.getSimpleList(contrastTask.getLeftFileId());
        List<ExtractElementDto> rightElementList = this.extractElementService.getSimpleList(contrastTask.getRightFileId());
        ArrayList<ContrastResult> contrastResultList = new ArrayList<ContrastResult>();
        for (ExtractElementDto leftElementDto : leftElementList) {
            String elementName = leftElementDto.getElementName();
            ExtractElementDto rightElementDto = new ExtractElementDto();
            for (ExtractElementDto tempDto : rightElementList) {
                if (!tempDto.getElementName().equals(elementName)) continue;
                rightElementDto = tempDto;
            }
            String type = "2";
            if (leftElementDto.getOriginText() == null && rightElementDto.getOriginText() == null) continue;
            if (leftElementDto.getOriginText().equals(rightElementDto.getElementText())) {
                type = "4";
            }
            ContrastResult contrastResult = ContrastResult.builder().type("1").elementType(type).elementName(leftElementDto.getElementName()).taskId(contrastTask.getId()).leftResult(leftElementDto.getOriginText()).leftLocation(leftElementDto.getElementLocation()).rightResult(rightElementDto.getOriginText()).rightLocation(rightElementDto.getElementLocation()).build();
            contrastResultList.add(contrastResult);
        }
        return contrastResultList;
    }

    private List<ContrastResult> ParagraphContrast(ContrastFileInfoDto fileInfoDto, DocContrastDto query) throws Exception {
        WordStructureInfo leftWordStructureInfo = ReadWordUtil.getWordInfo(fileInfoDto.getLeftFileInfo());
        ArrayList<WordParagraphInfo> leftParagraphs = new ArrayList<WordParagraphInfo>();
        for (WordElementInfo leftPara : leftWordStructureInfo.getElementInfosByType("para")) {
            WordParagraphInfo paragraphInfo = (WordParagraphInfo)leftPara;
            leftParagraphs.add(paragraphInfo);
        }
        WordStructureInfo rightWordStructureInfo = ReadWordUtil.getWordInfo(fileInfoDto.getRightFileInfo());
        ArrayList<WordParagraphInfo> rightParagraphs = new ArrayList<WordParagraphInfo>();
        for (WordElementInfo rightPara : rightWordStructureInfo.getElementInfosByType("para")) {
            WordParagraphInfo paragraphInfo = (WordParagraphInfo)rightPara;
            rightParagraphs.add(paragraphInfo);
        }
        List<ContrastResult> contrastResultList = CompareUtil.compareParagraph(leftParagraphs, rightParagraphs, 1, query);
        if (!contrastResultList.isEmpty()) {
            for (ContrastResult result : contrastResultList) {
                result.setTaskId(fileInfoDto.getId());
            }
        }
        return contrastResultList;
    }
}

