/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.doccontrast.service.impl;

import cn.hutool.json.JSONObject;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.dio.service.FileService;
import com.jxdinfo.idp.extract.domain.extractor.ocrconfigxtract.SingleSealInfo;
import com.jxdinfo.idp.extract.domain.extractor.ocrconfigxtract.SingleSignInfo;
import com.jxdinfo.idp.extract.domain.extractor.ocrconfigxtract.SingleWriteDataInfo;
import com.jxdinfo.idp.icpac.common.config.OverAllVarConfig;
import com.jxdinfo.idp.icpac.common.entity.PdfOcrResponse;
import com.jxdinfo.idp.icpac.common.entity.TabHead;
import com.jxdinfo.idp.icpac.common.entity.TableInfo;
import com.jxdinfo.idp.icpac.common.entity.po.ConfigOcrExtract;
import com.jxdinfo.idp.icpac.common.ocr.entity.config.extract.table.TableConfig;
import com.jxdinfo.idp.icpac.common.ocr.service.ConfigOcrExtractService;
import com.jxdinfo.idp.icpac.doccontrast.entity.po.ConfigDocElement;
import com.jxdinfo.idp.icpac.doccontrast.service.IConfigDocElementService;
import com.jxdinfo.idp.icpac.doccontrast.service.OcrService;
import com.jxdinfo.idp.icpac.doccontrast.util.StringUtils;
import com.jxdinfo.idp.icpac.feign.OcrFeign;
import com.jxdinfo.idp.interf.DocService;
import com.jxdinfo.idp.interf.FileSystemInterface;
import com.jxdinfo.idp.po.DocFilePo;
import com.jxdinfo.idp.po.FileInfoPo;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;

@Service
public class DefaultOcrServiceImpl
implements OcrService {
    private static final Logger log = LoggerFactory.getLogger(DefaultOcrServiceImpl.class);
    @Autowired
    private ConfigOcrExtractService extractService;
    @Autowired
    private OcrFeign feign;
    @Resource
    private FileSystemInterface fileInfoService;
    @Resource
    private DocService docService;
    @Resource
    private FileService fileService;
    @Resource
    private IConfigDocElementService configDocElementService;
    @Resource
    private OverAllVarConfig allVarConfig;

    @Override
    public PdfOcrResponse getPdfOcrResponse(String ocrExtractId, Long docId, String type, byte[] fileBytes) throws SftpException, JSchException, IOException {
        ConfigOcrExtract ocrConfig = this.extractService.ocrDetail(ocrExtractId);
        HashMap ocrConfigMap = new HashMap();
        String identifyJson = ocrConfig.getIdentifyJson();
        com.alibaba.fastjson.JSONObject identifyMap = JSON.parseObject((String)identifyJson);
        ocrConfigMap.putAll(identifyMap);
        String extractJson = ocrConfig.getExtractJson();
        com.alibaba.fastjson.JSONObject extractMap = JSON.parseObject((String)extractJson);
        ocrConfigMap.putAll(extractMap);
        DocFilePo fileInfo = (DocFilePo)this.fileInfoService.getById((Serializable)docId);
        FileInfoPo fileInfoPo = (FileInfoPo)this.docService.getById((Serializable)docId);
        if (fileBytes == null) {
            fileBytes = this.fileService.download(fileInfo.getFilePath());
        }
        String attachmentType = "pdf".equalsIgnoreCase(fileInfoPo.getFormat()) ? "pdf" : "img";
        ApiResponse<String> ocrResponseJson = null;
        log.info("\u6a21\u677f:{} " + JSON.toJSONString(ocrConfigMap), (Object)ocrConfig.getOcrName());
        PdfOcrResponse ocrResponse = new PdfOcrResponse();
        try {
            ocrResponseJson = this.feign.ocr(JSON.toJSONString(ocrConfigMap), attachmentType, fileBytes);
        }
        catch (Exception e) {
            ocrResponse.setStatus(0);
            throw new BusinessException("OCR\u8bc6\u522b\u5f02\u5e38");
        }
        try {
            if (StringUtils.isNotEmpty((String)ocrResponseJson.getData())) {
                ocrResponse = (PdfOcrResponse)JSON.parseObject((String)((String)ocrResponseJson.getData()), PdfOcrResponse.class);
                log.info((String)ocrResponseJson.getData());
            }
        }
        catch (JSONException e) {
            log.error("OCR\u7ed3\u679c\u8f6c\u5316\u4e3a\u5bf9\u8c61\u5931\u8d25", (Throwable)e);
            ocrResponse.setStatus(0);
        }
        List<ConfigDocElement> configDocElements = this.configDocElementService.getOcrTableElement(ocrExtractId);
        HashMap<String, List<TableInfo>> tableInfo = new HashMap();
        if (!ocrResponse.getTable().isEmpty()) {
            tableInfo = this.reSetAllTable(ocrResponse, configDocElements);
        }
        String ocrPackingOcrResponseJson = this.packingOcrResponseJson(ocrResponse, ocrResponse.getTable());
        ocrResponse.setTableInfo(tableInfo);
        ocrResponse.setOcrResponseJson(ocrPackingOcrResponseJson);
        ocrResponse.setAttachmentType(attachmentType);
        ocrResponse.setDocId(docId);
        ocrResponse.setExtractFile(fileBytes);
        ocrResponse.setFilename(fileInfo.getFileName());
        return ocrResponse;
    }

    public String packingOcrResponseJson(PdfOcrResponse ocrResponse, LinkedMultiValueMap<String, List<String>> table) throws JsonProcessingException {
        Map<String, SingleSealInfo> seal = ocrResponse.getSeal();
        Map<String, SingleSignInfo> sign = ocrResponse.getSign();
        Map<String, SingleWriteDataInfo> writData = ocrResponse.getWritedate();
        Map<String, String> text = ocrResponse.getText();
        Map<String, String> number = ocrResponse.getNumber();
        Map<String, String> date = ocrResponse.getDate();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("seal", gson.toJsonTree(seal));
        jsonObject.add("sign", gson.toJsonTree(sign));
        jsonObject.add("writedata", gson.toJsonTree(writData));
        jsonObject.add("text", gson.toJsonTree(text));
        jsonObject.add("date", gson.toJsonTree(date));
        jsonObject.add("number", gson.toJsonTree(number));
        jsonObject.add("table", gson.toJsonTree(table));
        return gson.toJson((JsonElement)jsonObject);
    }

    private Map<String, List<TableInfo>> reSetAllTable(PdfOcrResponse ocrResponse, List<ConfigDocElement> configDocElements) {
        LinkedMultiValueMap<String, List<String>> tables = ocrResponse.getTable();
        HashMap<String, List<TableInfo>> map = new HashMap<String, List<TableInfo>>();
        for (Map.Entry stringListEntry : tables.entrySet()) {
            ArrayList<TableInfo> tableInfos = new ArrayList<TableInfo>();
            for (ConfigDocElement element : configDocElements) {
                TableConfig tableConfig = new TableConfig();
                JSONObject jsonObject = new JSONObject((Object)element.getExtractRule());
                String transPose = (String)jsonObject.get((Object)"lineDirection");
                tableInfos.add(this.reSetOneTable((List)stringListEntry.getValue(), (String)stringListEntry.getKey(), transPose));
                map.put((String)stringListEntry.getKey(), (List<TableInfo>)tableInfos);
            }
        }
        return map;
    }

    private TableInfo reSetOneTable(List<List<String>> table, String tableName, String transPose) {
        int i;
        if ("1".equals(transPose)) {
            table = this.transposeList(table);
        }
        TableInfo tableInfo = new TableInfo();
        if (table == null) {
            return tableInfo;
        }
        ArrayList<TabHead> tabHeads = new ArrayList<TabHead>();
        ArrayList<Map<String, String>> tableData = new ArrayList<Map<String, String>>();
        for (i = 0; i < table.get(0).size(); ++i) {
            TabHead tabHead = new TabHead();
            tabHead.setDataType("");
            tabHead.setHeadName(table.get(0).get(i));
            tabHead.setHeadKey(String.valueOf(i));
            tabHeads.add(tabHead);
        }
        for (i = 1; i < table.size(); ++i) {
            HashMap<String, String> datamap = new HashMap<String, String>();
            for (int i1 = 0; i1 < table.get(i).size(); ++i1) {
                datamap.put(String.valueOf(i1), table.get(i).get(i1));
            }
            tableData.add(datamap);
        }
        tableInfo.setTabHeads(tabHeads);
        tableInfo.setTabData(tableData);
        return tableInfo;
    }

    private List<List<String>> transposeList(List<List<String>> table) {
        if (table == null || table.isEmpty()) {
            return new ArrayList<List<String>>();
        }
        int rows = table.size();
        int cols = table.get(0).size();
        ArrayList<List<String>> transposedTable = new ArrayList<List<String>>(cols);
        for (int j = 0; j < cols; ++j) {
            ArrayList<String> column = new ArrayList<String>(rows);
            for (int i = 0; i < rows; ++i) {
                column.add(table.get(i).get(j));
            }
            transposedTable.add(column);
        }
        return transposedTable;
    }
}

