/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.doccontrast.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.icpac.doccontrast.entity.po.ConfigDocElement;
import com.jxdinfo.idp.icpac.doccontrast.entity.query.ConfigDocElementQuery;
import com.jxdinfo.idp.icpac.doccontrast.mapper.ConfigDocElementMapper;
import com.jxdinfo.idp.icpac.doccontrast.service.IConfigDocElementService;
import com.jxdinfo.idp.icpac.doccontrast.util.StringUtils;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class ConfigDocElementServiceImpl
extends ServiceImpl<ConfigDocElementMapper, ConfigDocElement>
implements IConfigDocElementService {
    @Override
    public List<ConfigDocElement> getOcrTableElement(String id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ConfigDocElement::getDocVersionId, (Object)id);
        queryWrapper.eq(ConfigDocElement::getElementType, (Object)"table");
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ConfigDocElement> elementsByVersion(String versionId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ConfigDocElement::getDocVersionId, (Object)versionId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ConfigDocElement> getList(ConfigDocElementQuery query) {
        if (query.getDocVersionId() == null) {
            throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7248\u672c\u53f7\u5931\u8d25");
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ConfigDocElement::getDocVersionId, (Object)query.getDocVersionId());
        wrapper.eq(StringUtils.isNotEmpty(query.getElementType()), ConfigDocElement::getElementType, (Object)query.getElementType());
        wrapper.in(CollectionUtil.isNotEmpty(query.getElementTypes()), ConfigDocElement::getElementType, query.getElementTypes());
        List docElements = this.list((Wrapper)wrapper);
        if (docElements != null && !docElements.isEmpty()) {
            docElements = docElements.stream().sorted(Comparator.comparing(ConfigDocElement::getSortedBy)).collect(Collectors.toList());
        }
        return docElements;
    }
}

