/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.common.utils;

import cn.hutool.core.collection.CollUtil;
import com.jxdinfo.idp.extract.domain.util.word.TableIndex;
import com.jxdinfo.idp.icpac.common.document.location.WordLocation;
import com.jxdinfo.idp.icpac.common.document.location.word.ParaLocation;
import com.jxdinfo.idp.icpac.common.document.location.word.TableLocation;
import com.jxdinfo.idp.icpac.common.entity.FileBytesInfo;
import com.jxdinfo.idp.icpac.common.utils.Sign2Util;
import com.jxdinfo.idp.icpac.doccontrast.util.wordpicture.ImageManagerImpl;
import com.jxdinfo.idp.icpac.doccontrast.util.wordpicture.ImgUrlReplaceUtil;
import com.jxdinfo.idp.icpac.doccontrast.util.wordpicture.PictureManagerImpl;
import fr.opensagres.poi.xwpf.converter.core.ImageManager;
import fr.opensagres.poi.xwpf.converter.core.Options;
import fr.opensagres.poi.xwpf.converter.xhtml.XHTMLConverter;
import fr.opensagres.poi.xwpf.converter.xhtml.XHTMLOptions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.HWPFDocumentCore;
import org.apache.poi.hwpf.converter.PicturesManager;
import org.apache.poi.hwpf.converter.WordToHtmlConverter;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.hwpf.usermodel.Table;
import org.apache.poi.hwpf.usermodel.TableCell;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class WordHtmlUtilNew {
    private static final Logger log = LoggerFactory.getLogger(WordHtmlUtilNew.class);
    private static final String KEY_HTML = "htmlStr";
    @Value(value="${img.url-prefix}")
    private String url_prefix;
    @Value(value="${img.save-type}")
    private String pic_save_type;
    private static String urlPrefix;
    private static String picSaveType;

    @PostConstruct
    public void setUrlPrefix() {
        urlPrefix = this.url_prefix;
    }

    @PostConstruct
    public void setPicSaveType() {
        picSaveType = this.pic_save_type;
    }

    public static String getUrlPrefix() {
        return urlPrefix;
    }

    public static String getPicSaveType() {
        return picSaveType;
    }

    public static Map<String, Object> word2html(FileBytesInfo bytesInfo, Map<String, WordLocation> locationMap) {
        HashMap<String, Object> html = new HashMap();
        try (HWPFDocument document = new HWPFDocument((InputStream)new ByteArrayInputStream(bytesInfo.getFileBytes()));){
            html = WordHtmlUtilNew.doc2html(bytesInfo, document, locationMap);
        }
        catch (Exception e) {
            try (XWPFDocument document2 = new XWPFDocument((InputStream)new ByteArrayInputStream(bytesInfo.getFileBytes()));){
                html = WordHtmlUtilNew.docx2html(bytesInfo, document2, locationMap);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                String htmlText = "<html><head><title>" + bytesInfo.getFileName() + "</title>" + "</head>" + "<body>" + "<h1>\u6587\u4ef6\u5f02\u5e38</h1>" + "<p>\u65e0\u6cd5\u89e3\u6790\u6587\u4ef6\u3010" + bytesInfo.getFileName() + "\u3011\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u5408\u89c4\uff01</p>" + "</body>" + "</html>";
                html.put(KEY_HTML, htmlText);
            }
        }
        return ImgUrlReplaceUtil.transTagAttr(html);
    }

    public static Map<String, Object> doc2html(FileBytesInfo bytesInfo, HWPFDocument document, Map<String, WordLocation> locationMap) throws Exception {
        Transformer serializer;
        PictureManagerImpl pictureManager;
        WordToHtmlConverter wordToHtmlConverter;
        if (CollUtil.isNotEmpty(locationMap)) {
            Range range = document.getRange();
            for (Map.Entry<String, WordLocation> entry : locationMap.entrySet()) {
                WordLocation location = entry.getValue();
                try {
                    String newText;
                    if ("para".equals(location.getType())) {
                        ParaLocation pLocation = (ParaLocation)location;
                        String newText2 = pLocation.getTextIndex() == null ? Sign2Util.markPara(entry.getKey(), pLocation.getDelFlag(), pLocation.getPoiIndex()) : Sign2Util.markText(entry.getKey(), pLocation.getTextIndex(), pLocation.getTextLength());
                        Paragraph paragraph = range.getParagraph(pLocation.getPoiIndex() == -1 ? 0 : pLocation.getPoiIndex());
                        newText2 = newText2 + paragraph.text();
                        paragraph.replaceText(newText2, false);
                        continue;
                    }
                    if (!"table".equals(location.getType())) continue;
                    TableLocation tLocation = (TableLocation)location;
                    Paragraph paragraph = range.getParagraph(tLocation.getPPoiIndex().intValue());
                    Table table = range.getTable(paragraph);
                    if (tLocation.getRowIndex() == null) {
                        newText = Sign2Util.markTable(entry.getKey(), tLocation.getDelFlag(), tLocation.getPoiIndex()) + paragraph.text();
                    } else if (tLocation.getPPoiIndex() == null) {
                        TableCell cell = table.getRow(tLocation.getRowIndex().intValue()).getCell(tLocation.getCellIndex().intValue());
                        paragraph = cell.getParagraph(0);
                        newText = Sign2Util.markCell(entry.getKey(), "") + paragraph.text();
                    } else {
                        paragraph = range.getParagraph(tLocation.getPPoiIndex().intValue());
                        newText = Sign2Util.markPara(entry.getKey(), tLocation.getPDelFlag(), tLocation.getPPoiIndex()) + paragraph.text();
                    }
                    paragraph.replaceText(newText, false);
                }
                catch (Exception e) {
                    log.error("\u539f\u6587\u6863\u6807\u8bb0\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        try {
            wordToHtmlConverter = new WordToHtmlConverter(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument());
            pictureManager = new PictureManagerImpl(WordHtmlUtilNew.getPicSaveType());
            wordToHtmlConverter.setPicturesManager((PicturesManager)pictureManager);
            wordToHtmlConverter.processDocument((HWPFDocumentCore)document);
            serializer = TransformerFactory.newInstance().newTransformer();
            serializer.setOutputProperty("encoding", "utf-8");
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("method", "html");
        }
        catch (Exception e) {
            log.error("error occurred when doc trans to html");
            return null;
        }
        HashMap<String, Object> htmlInfo = new HashMap<String, Object>();
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
             ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();){
            document.write((OutputStream)byteOutputStream);
            bytesInfo.setFileBytes(byteOutputStream.toByteArray());
            try {
                serializer.transform(new DOMSource(wordToHtmlConverter.getDocument()), new StreamResult(byteArrayOutputStream));
            }
            catch (TransformerException e) {
                log.error("doc\u683c\u5f0f\u6587\u4ef6\u8f6chtml\u5f02\u5e38\uff01");
                throw e;
            }
            htmlInfo.put(KEY_HTML, byteArrayOutputStream.toString());
        }
        htmlInfo.put("imgDirName", pictureManager.getImgDirName());
        return htmlInfo;
    }

    public static Map<String, Object> docx2html(FileBytesInfo bytesInfo, XWPFDocument document, Map<String, WordLocation> locationMap) {
        if (CollUtil.isNotEmpty(locationMap)) {
            for (Map.Entry<String, WordLocation> entry : locationMap.entrySet()) {
                WordLocation location = entry.getValue();
                try {
                    XWPFParagraph paragraph;
                    String newText;
                    if ("para".equals(location.getType())) {
                        ParaLocation pLocation = (ParaLocation)location;
                        String newText2 = pLocation.getTextIndex() == null ? Sign2Util.markPara(entry.getKey(), pLocation.getDelFlag(), pLocation.getPoiIndex()) : Sign2Util.markText(entry.getKey(), pLocation.getTextIndex(), pLocation.getTextLength());
                        XWPFParagraph paragraph2 = document.getParagraphArray(pLocation.getPoiIndex() == -1 ? 0 : pLocation.getPoiIndex());
                        XWPFRun run = paragraph2.getRuns().size() == 0 ? paragraph2.createRun() : (XWPFRun)paragraph2.getRuns().get(0);
                        newText2 = newText2 + run.text();
                        run.setText(newText2, 0);
                        continue;
                    }
                    if (!"table".equals(location.getType())) continue;
                    TableLocation tLocation = (TableLocation)location;
                    LinkedList<TableIndex> poiIndexList = tLocation.getPoiIndexList();
                    TableIndex root = poiIndexList.getFirst();
                    XWPFTable table = document.getTableArray(root.getPoiIndex().intValue());
                    XWPFTableCell cell = null;
                    for (int i = 0; i < poiIndexList.size(); ++i) {
                        TableIndex tableIndex = poiIndexList.get(i);
                        if (i > 0) {
                            table = cell.getTableArray(tableIndex.getRowIndex().intValue());
                        }
                        if (tableIndex.getCellIndex() == null) continue;
                        cell = table.getRow(tableIndex.getRowIndex().intValue()).getCell(tableIndex.getCellIndex().intValue());
                    }
                    if (tLocation.getRowIndex() == null) {
                        newText = Sign2Util.markTable(entry.getKey(), tLocation.getDelFlag(), tLocation.getPoiIndex());
                        paragraph = table.getRow(0).getCell(0).getParagraphArray(0);
                    } else {
                        cell = table.getRow(tLocation.getRowIndex().intValue()).getCell(tLocation.getCellIndex().intValue());
                        if (tLocation.getPPoiIndex() == null) {
                            paragraph = cell.getParagraphArray(0);
                            newText = Sign2Util.markCell(entry.getKey(), StringUtils.isEmpty((CharSequence)tLocation.getCellPosition()) ? "" : tLocation.getCellPosition());
                        } else {
                            paragraph = cell.getParagraphArray(tLocation.getPPoiIndex().intValue());
                            newText = tLocation.getPTextIndex() == null ? Sign2Util.markPara(entry.getKey(), tLocation.getPDelFlag(), tLocation.getPPoiIndex()) : Sign2Util.markText(entry.getKey(), tLocation.getPTextIndex(), tLocation.getPTextLength());
                        }
                    }
                    XWPFRun run = paragraph.getRuns().size() == 0 ? paragraph.createRun() : (XWPFRun)paragraph.getRuns().get(0);
                    newText = newText + run.text();
                    run.setText(newText, 0);
                }
                catch (Exception e) {
                    log.error("\u539f\u6587\u6863\u6807\u8bb0\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        XHTMLOptions options = XHTMLOptions.create();
        ImageManagerImpl imageManager = new ImageManagerImpl(WordHtmlUtilNew.getPicSaveType());
        options.setImageManager((ImageManager)imageManager);
        options.setIgnoreStylesIfUnused(false);
        options.setFragment(true);
        HashMap<String, Object> htmlInfo = new HashMap<String, Object>();
        try (ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
             ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();){
            document.write((OutputStream)byteOutputStream);
            bytesInfo.setFileBytes(byteOutputStream.toByteArray());
            XHTMLConverter.getInstance().convert(document, (OutputStream)byteOut, (Options)options);
            htmlInfo.put(KEY_HTML, byteOut.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        htmlInfo.put("imgDirName", imageManager.getImgDirName());
        return htmlInfo;
    }
}

