/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.common.util;

import com.jxdinfo.idp.icpac.common.entity.FileBytesInfo;
import com.jxdinfo.idp.icpac.common.util.entity.excel.CellData;
import com.jxdinfo.idp.icpac.common.util.entity.excel.MergedRegion;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(ReadExcelUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedHashMap<String, List<CellData>> structure(FileBytesInfo entity) {
        LinkedHashMap<String, List<CellData>> mapData = new LinkedHashMap<String, List<CellData>>();
        XSSFWorkbook wk = null;
        try {
            if (entity.getFileName().endsWith(".xlsx")) {
                wk = new XSSFWorkbook((InputStream)new ByteArrayInputStream(entity.getFileBytes()));
            } else if (entity.getFileName().contains("xls")) {
                wk = new HSSFWorkbook((InputStream)new ByteArrayInputStream(entity.getFileBytes()));
            }
            int sheetNums = 0;
            if (wk != null) {
                sheetNums = wk.getNumberOfSheets();
            }
            for (int i = 0; i < sheetNums; ++i) {
                Sheet sheet = wk.getSheetAt(i);
                String sheetName = wk.getSheetName(i);
                sheetName = sheetName.replaceAll("\\s+", "");
                ArrayList<CellData> callDatas = new ArrayList<CellData>();
                for (Row row : sheet) {
                    for (Cell cell : row) {
                        String cellValue = null;
                        switch (cell.getCellType()) {
                            case NUMERIC: {
                                short dataFormat = cell.getCellStyle().getDataFormat();
                                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                    SimpleDateFormat sdf;
                                    switch (dataFormat) {
                                        case 14: {
                                            sdf = new SimpleDateFormat("yyyy-MM-dd");
                                            break;
                                        }
                                        case 20: {
                                            sdf = new SimpleDateFormat("HH:mm");
                                            break;
                                        }
                                        case 21: {
                                            sdf = new SimpleDateFormat("HH:mm:ss");
                                            break;
                                        }
                                        case 22: {
                                            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                            break;
                                        }
                                        case 31: {
                                            sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
                                            break;
                                        }
                                        case 32: {
                                            sdf = new SimpleDateFormat("HH\u65f6mm\u5206");
                                            break;
                                        }
                                        case 33: {
                                            sdf = new SimpleDateFormat("HH\u65f6mm\u5206mm\u79d2");
                                            break;
                                        }
                                        case 57: {
                                            sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708");
                                            break;
                                        }
                                        case 58: {
                                            sdf = new SimpleDateFormat("MM\u6708dd\u65e5");
                                            break;
                                        }
                                        case 176: {
                                            sdf = new SimpleDateFormat("yyyy-MM-dd");
                                            break;
                                        }
                                        case 177: {
                                            sdf = new SimpleDateFormat("yyyy-MM-dd");
                                            break;
                                        }
                                        case 178: {
                                            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                            break;
                                        }
                                        default: {
                                            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                        }
                                    }
                                    if (sdf != null) {
                                        Date date = cell.getDateCellValue();
                                        assert (sdf != null);
                                        cellValue = sdf.format(date);
                                        if (!cellValue.endsWith("00:00:00")) break;
                                        cellValue = cellValue.substring(0, cellValue.length() - 9);
                                        break;
                                    }
                                    cellValue = String.valueOf(cell.getDateCellValue());
                                    break;
                                }
                                if (dataFormat != 0) break;
                                Double val = cell.getNumericCellValue();
                                if (Double.compare(val % 1.0, 0.0) != 0) {
                                    cellValue = String.valueOf(new BigDecimal(((Object)val).toString()));
                                    break;
                                }
                                cellValue = new DecimalFormat("0").format(val);
                                break;
                            }
                            case STRING: {
                                cellValue = cell.getStringCellValue();
                                break;
                            }
                            case BOOLEAN: {
                                boolean booleanCellValue = cell.getBooleanCellValue();
                                cellValue = Boolean.toString(booleanCellValue);
                                break;
                            }
                            case FORMULA: {
                                cellValue = cell.getCellFormula();
                                break;
                            }
                            case ERROR: {
                                byte errorCellValue = cell.getErrorCellValue();
                                cellValue = Byte.toString(errorCellValue);
                                break;
                            }
                        }
                        if (!StringUtils.isNotEmpty(cellValue)) continue;
                        CellData cellData = new CellData();
                        cellData.setCellData(cellValue);
                        cellData.setCellKey(cell.getColumnIndex() + 1 + "," + (cell.getRowIndex() + 1));
                        cellData.setColumnIndex(cell.getColumnIndex());
                        cellData.setRowIndex(cell.getRowIndex());
                        ReadExcelUtil.isMergedRegion(sheet, cellData);
                        callDatas.add(cellData);
                    }
                }
                mapData.put(sheetName, callDatas);
            }
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6excel\u6587\u4ef6\u5f02\u5e38\uff1a", (Throwable)e);
        }
        finally {
            try {
                if (wk != null) {
                    wk.close();
                }
            }
            catch (IOException e) {
                log.error("\u5173\u95edexcel\u6587\u4ef6workbook\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        return mapData;
    }

    private static CellData isMergedRegion(Sheet sheet, CellData cellData) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress range = sheet.getMergedRegion(i);
            int firstColumn = range.getFirstColumn();
            int lastColumn = range.getLastColumn();
            int firstRow = range.getFirstRow();
            int lastRow = range.getLastRow();
            if (cellData.getRowIndex() < firstRow || cellData.getRowIndex() > lastRow) continue;
            if (cellData.getColumnIndex() >= firstColumn && cellData.getColumnIndex() <= lastColumn) {
                cellData.setIsMerged(true);
                MergedRegion mergedRegion = new MergedRegion();
                mergedRegion.setFirstColumn(firstColumn);
                mergedRegion.setLastColumn(lastColumn);
                mergedRegion.setFirstRow(firstRow);
                mergedRegion.setLastRow(lastRow);
                cellData.setMergedRegion(mergedRegion);
                break;
            }
            cellData.setIsMerged(false);
        }
        return cellData;
    }
}

