/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.common.ocr.handler.parser;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.jxdinfo.idp.extract.domain.extractor.ocrconfigxtract.SingleWriteDataInfo;
import com.jxdinfo.idp.icpac.common.entity.PdfOcrResponse;
import com.jxdinfo.idp.icpac.common.entity.po.ExtractElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;

public class WriteDataParse {
    private PdfOcrResponse ocrResponse;
    private Long docId;
    private String docFormat;
    private String elementType;

    public WriteDataParse(PdfOcrResponse ocrResponse, String docFormat, String elementType) {
        this.ocrResponse = ocrResponse;
        this.docId = ocrResponse.getDocId();
        this.docFormat = docFormat;
        this.elementType = elementType;
    }

    public List<ExtractElement> parse() {
        Map<String, SingleWriteDataInfo> data = this.ocrResponse.getWritedate();
        ArrayList<ExtractElement> elementResults = new ArrayList<ExtractElement>();
        for (Map.Entry<String, SingleWriteDataInfo> entry : data.entrySet()) {
            SingleWriteDataInfo dataInfo = entry.getValue();
            ExtractElement extractElement = new ExtractElement();
            extractElement.setId(IdUtil.fastSimpleUUID());
            extractElement.setDocId(this.docId);
            extractElement.setDocFormat(this.docFormat);
            extractElement.setElementType(this.elementType);
            extractElement.setDocElementId(IdUtil.simpleUUID());
            extractElement.setElementText(this.getTransElement(dataInfo));
            extractElement.setDocElementId(entry.getKey());
            elementResults.add(extractElement);
        }
        return elementResults;
    }

    private String getTransElement(SingleWriteDataInfo dataInfo) {
        if (ObjectUtils.isEmpty((Object)dataInfo)) {
            return JSON.toJSONString((Object)new SingleWriteDataInfo());
        }
        return JSON.toJSONString((Object)dataInfo);
    }
}

