/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.common.ocr.handler.parser;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.jxdinfo.idp.icpac.common.entity.PdfOcrResponse;
import com.jxdinfo.idp.icpac.common.entity.TableInfo;
import com.jxdinfo.idp.icpac.common.entity.po.ExtractElement;
import com.jxdinfo.idp.icpac.doccontrast.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TableParser {
    private PdfOcrResponse ocrResponse;
    private Long docId;
    private String docFormat;
    private String elementType;

    public TableParser(PdfOcrResponse ocrResponse, String docFormat, String elementType) {
        this.ocrResponse = ocrResponse;
        this.docId = ocrResponse.getDocId();
        this.docFormat = docFormat;
        this.elementType = elementType;
    }

    public List<ExtractElement> parse() {
        Map<String, List<TableInfo>> infos = this.ocrResponse.getTableInfo();
        ArrayList<ExtractElement> elementResult = new ArrayList<ExtractElement>();
        if (StringUtils.isEmpty(infos)) {
            return elementResult;
        }
        for (Map.Entry<String, List<TableInfo>> entry : infos.entrySet()) {
            List<TableInfo> tableInfoList = entry.getValue();
            for (TableInfo tableInfo : tableInfoList) {
                ExtractElement extractElement = new ExtractElement();
                extractElement.setId(IdUtil.fastSimpleUUID());
                extractElement.setDocId(this.docId);
                extractElement.setDocFormat(this.docFormat);
                extractElement.setElementType(this.elementType);
                extractElement.setDocElementId(entry.getKey());
                extractElement.setElementText(JSON.toJSONString((Object)tableInfo));
                elementResult.add(extractElement);
            }
        }
        return elementResult;
    }
}

