/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.common.ocr.entity.config.global;

import com.jxdinfo.idp.icpac.common.ocr.entity.config.global.BinaryConfig;
import com.jxdinfo.idp.icpac.common.ocr.entity.config.global.GlobalConfig;
import com.jxdinfo.idp.icpac.common.ocr.entity.config.global.OcrConfig;
import com.jxdinfo.idp.icpac.common.ocr.entity.config.global.ProcessConfig;
import com.jxdinfo.idp.icpac.common.ocr.entity.config.global.SealConfig;
import com.jxdinfo.idp.icpac.common.ocr.entity.config.global.SignConfig;
import com.jxdinfo.idp.icpac.common.ocr.entity.config.global.SignCreateDTO;
import com.jxdinfo.idp.icpac.common.ocr.entity.config.global.WriteDataConfig;
import java.util.List;
import java.util.regex.Pattern;

public class WebGlobalConfig {
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^\\d+$");
    private boolean flag = true;
    private int thresh;
    private String binary_type = "cv2.THRESH_BINARY";
    private double line_merge_coincidence_rate = 0.6;
    private int horizontal_distance = 5;
    private boolean detect;
    private boolean remove;
    private String seal_type;
    private List<Integer> sealDetectPage;
    private double sealDetectThresh;
    private String sealMatchMethod = "text+table+position+keyword_position";
    private double sealExtendRate;
    private double sealIosThresh;
    private double sealMatchThresh;
    private boolean sealMergeItems;
    private Object pdf_num;
    private String recognitionRange;
    private boolean signDetect;
    private List<Integer> detectPage;
    private double detectThresh;
    private String matchMethod = "text+table+position+keyword_position";
    private boolean mergeItems;
    private double matchThresh;
    private double extendRate;
    private double iosThresh;
    private boolean continuousPageNumber;

    public GlobalConfig toGlobalConfig(List<SignCreateDTO> createDTOS) {
        ProcessConfig processConfig = new ProcessConfig();
        processConfig.setContinuous_page_number(this.continuousPageNumber);
        BinaryConfig binaryConfig = new BinaryConfig();
        binaryConfig.setFlag(this.flag);
        binaryConfig.setThresh(this.thresh);
        binaryConfig.setType(this.binary_type);
        for (SignCreateDTO createDTO : createDTOS) {
            SignConfig config = createDTO.getSignConfig();
            config.setIndex(createDTO.getIndex());
            config.setMatch_items(createDTO.getMatchItems());
            config.setPosition(createDTO.getPosition());
            config.setResult(createDTO.getResult());
            config.setKeyword_position(createDTO.getDirections());
            config.setDetect_page(createDTO.getDetectPage());
            if (config instanceof SealConfig) {
                processConfig.setSeal((SealConfig)this.signOrSealCreate(createDTO.getSignConfig(), 1));
                continue;
            }
            if (config instanceof WriteDataConfig) {
                processConfig.setWriteData((WriteDataConfig)this.signOrSealCreate(createDTO.getSignConfig(), 3));
                continue;
            }
            processConfig.setSign(this.signOrSealCreate(createDTO.getSignConfig(), 2));
        }
        processConfig.setBinary(binaryConfig);
        if (this.pdf_num != null && NUMBER_PATTERN.matcher(this.pdf_num.toString()).matches()) {
            this.pdf_num = Integer.parseInt(this.pdf_num.toString());
        }
        processConfig.setPdf_num(this.pdf_num);
        processConfig.setRecognitionRange(this.recognitionRange);
        OcrConfig ocrConfig = new OcrConfig();
        ocrConfig.setHorizontal_distance(this.horizontal_distance);
        ocrConfig.setLine_merge_coincidence_rate(this.line_merge_coincidence_rate);
        GlobalConfig globalConfig = new GlobalConfig();
        globalConfig.setOcr(ocrConfig);
        globalConfig.setProcess(processConfig);
        return globalConfig;
    }

    private SignConfig signOrSealCreate(SignConfig config, Integer type) {
        if (1 == type) {
            SealConfig sealConfig = (SealConfig)config;
            sealConfig.setType(this.seal_type);
            sealConfig.setDetect(this.detect);
            sealConfig.setRemove(this.remove);
            sealConfig.setDetect_thresh(this.sealDetectThresh);
            sealConfig.setMatch_method(this.sealMatchMethod);
            sealConfig.setMatch_thresh(this.sealMatchThresh);
            sealConfig.setExtend_rate(this.sealExtendRate);
            sealConfig.setIos_thresh(this.sealIosThresh);
            sealConfig.setMerge_items(this.sealMergeItems);
            return sealConfig;
        }
        if (2 == type) {
            config.setDetect(this.signDetect);
            config.setDetect_thresh(this.detectThresh);
            config.setExtend_rate(this.extendRate);
            config.setIos_thresh(this.iosThresh);
            config.setMatch_method(this.matchMethod);
            config.setMatch_thresh(this.matchThresh);
            config.setMerge_items(this.mergeItems);
            return config;
        }
        config.setDetect(true);
        config.setDetect_thresh(this.detectThresh);
        config.setExtend_rate(this.extendRate);
        config.setIos_thresh(this.iosThresh);
        config.setMatch_method(this.matchMethod);
        config.setMatch_thresh(this.matchThresh);
        config.setMerge_items(this.mergeItems);
        return config;
    }

    public boolean isFlag() {
        return this.flag;
    }

    public int getThresh() {
        return this.thresh;
    }

    public String getBinary_type() {
        return this.binary_type;
    }

    public double getLine_merge_coincidence_rate() {
        return this.line_merge_coincidence_rate;
    }

    public int getHorizontal_distance() {
        return this.horizontal_distance;
    }

    public boolean isDetect() {
        return this.detect;
    }

    public boolean isRemove() {
        return this.remove;
    }

    public String getSeal_type() {
        return this.seal_type;
    }

    public List<Integer> getSealDetectPage() {
        return this.sealDetectPage;
    }

    public double getSealDetectThresh() {
        return this.sealDetectThresh;
    }

    public String getSealMatchMethod() {
        return this.sealMatchMethod;
    }

    public double getSealExtendRate() {
        return this.sealExtendRate;
    }

    public double getSealIosThresh() {
        return this.sealIosThresh;
    }

    public double getSealMatchThresh() {
        return this.sealMatchThresh;
    }

    public boolean isSealMergeItems() {
        return this.sealMergeItems;
    }

    public Object getPdf_num() {
        return this.pdf_num;
    }

    public String getRecognitionRange() {
        return this.recognitionRange;
    }

    public boolean isSignDetect() {
        return this.signDetect;
    }

    public List<Integer> getDetectPage() {
        return this.detectPage;
    }

    public double getDetectThresh() {
        return this.detectThresh;
    }

    public String getMatchMethod() {
        return this.matchMethod;
    }

    public boolean isMergeItems() {
        return this.mergeItems;
    }

    public double getMatchThresh() {
        return this.matchThresh;
    }

    public double getExtendRate() {
        return this.extendRate;
    }

    public double getIosThresh() {
        return this.iosThresh;
    }

    public boolean isContinuousPageNumber() {
        return this.continuousPageNumber;
    }

    public void setFlag(boolean flag) {
        this.flag = flag;
    }

    public void setThresh(int thresh) {
        this.thresh = thresh;
    }

    public void setBinary_type(String binary_type) {
        this.binary_type = binary_type;
    }

    public void setLine_merge_coincidence_rate(double line_merge_coincidence_rate) {
        this.line_merge_coincidence_rate = line_merge_coincidence_rate;
    }

    public void setHorizontal_distance(int horizontal_distance) {
        this.horizontal_distance = horizontal_distance;
    }

    public void setDetect(boolean detect) {
        this.detect = detect;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    public void setSeal_type(String seal_type) {
        this.seal_type = seal_type;
    }

    public void setSealDetectPage(List<Integer> sealDetectPage) {
        this.sealDetectPage = sealDetectPage;
    }

    public void setSealDetectThresh(double sealDetectThresh) {
        this.sealDetectThresh = sealDetectThresh;
    }

    public void setSealMatchMethod(String sealMatchMethod) {
        this.sealMatchMethod = sealMatchMethod;
    }

    public void setSealExtendRate(double sealExtendRate) {
        this.sealExtendRate = sealExtendRate;
    }

    public void setSealIosThresh(double sealIosThresh) {
        this.sealIosThresh = sealIosThresh;
    }

    public void setSealMatchThresh(double sealMatchThresh) {
        this.sealMatchThresh = sealMatchThresh;
    }

    public void setSealMergeItems(boolean sealMergeItems) {
        this.sealMergeItems = sealMergeItems;
    }

    public void setPdf_num(Object pdf_num) {
        this.pdf_num = pdf_num;
    }

    public void setRecognitionRange(String recognitionRange) {
        this.recognitionRange = recognitionRange;
    }

    public void setSignDetect(boolean signDetect) {
        this.signDetect = signDetect;
    }

    public void setDetectPage(List<Integer> detectPage) {
        this.detectPage = detectPage;
    }

    public void setDetectThresh(double detectThresh) {
        this.detectThresh = detectThresh;
    }

    public void setMatchMethod(String matchMethod) {
        this.matchMethod = matchMethod;
    }

    public void setMergeItems(boolean mergeItems) {
        this.mergeItems = mergeItems;
    }

    public void setMatchThresh(double matchThresh) {
        this.matchThresh = matchThresh;
    }

    public void setExtendRate(double extendRate) {
        this.extendRate = extendRate;
    }

    public void setIosThresh(double iosThresh) {
        this.iosThresh = iosThresh;
    }

    public void setContinuousPageNumber(boolean continuousPageNumber) {
        this.continuousPageNumber = continuousPageNumber;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebGlobalConfig)) {
            return false;
        }
        WebGlobalConfig other = (WebGlobalConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFlag() != other.isFlag()) {
            return false;
        }
        if (this.getThresh() != other.getThresh()) {
            return false;
        }
        if (Double.compare(this.getLine_merge_coincidence_rate(), other.getLine_merge_coincidence_rate()) != 0) {
            return false;
        }
        if (this.getHorizontal_distance() != other.getHorizontal_distance()) {
            return false;
        }
        if (this.isDetect() != other.isDetect()) {
            return false;
        }
        if (this.isRemove() != other.isRemove()) {
            return false;
        }
        if (Double.compare(this.getSealDetectThresh(), other.getSealDetectThresh()) != 0) {
            return false;
        }
        if (Double.compare(this.getSealExtendRate(), other.getSealExtendRate()) != 0) {
            return false;
        }
        if (Double.compare(this.getSealIosThresh(), other.getSealIosThresh()) != 0) {
            return false;
        }
        if (Double.compare(this.getSealMatchThresh(), other.getSealMatchThresh()) != 0) {
            return false;
        }
        if (this.isSealMergeItems() != other.isSealMergeItems()) {
            return false;
        }
        if (this.isSignDetect() != other.isSignDetect()) {
            return false;
        }
        if (Double.compare(this.getDetectThresh(), other.getDetectThresh()) != 0) {
            return false;
        }
        if (this.isMergeItems() != other.isMergeItems()) {
            return false;
        }
        if (Double.compare(this.getMatchThresh(), other.getMatchThresh()) != 0) {
            return false;
        }
        if (Double.compare(this.getExtendRate(), other.getExtendRate()) != 0) {
            return false;
        }
        if (Double.compare(this.getIosThresh(), other.getIosThresh()) != 0) {
            return false;
        }
        if (this.isContinuousPageNumber() != other.isContinuousPageNumber()) {
            return false;
        }
        String this$binary_type = this.getBinary_type();
        String other$binary_type = other.getBinary_type();
        if (this$binary_type == null ? other$binary_type != null : !this$binary_type.equals(other$binary_type)) {
            return false;
        }
        String this$seal_type = this.getSeal_type();
        String other$seal_type = other.getSeal_type();
        if (this$seal_type == null ? other$seal_type != null : !this$seal_type.equals(other$seal_type)) {
            return false;
        }
        List<Integer> this$sealDetectPage = this.getSealDetectPage();
        List<Integer> other$sealDetectPage = other.getSealDetectPage();
        if (this$sealDetectPage == null ? other$sealDetectPage != null : !((Object)this$sealDetectPage).equals(other$sealDetectPage)) {
            return false;
        }
        String this$sealMatchMethod = this.getSealMatchMethod();
        String other$sealMatchMethod = other.getSealMatchMethod();
        if (this$sealMatchMethod == null ? other$sealMatchMethod != null : !this$sealMatchMethod.equals(other$sealMatchMethod)) {
            return false;
        }
        Object this$pdf_num = this.getPdf_num();
        Object other$pdf_num = other.getPdf_num();
        if (this$pdf_num == null ? other$pdf_num != null : !this$pdf_num.equals(other$pdf_num)) {
            return false;
        }
        String this$recognitionRange = this.getRecognitionRange();
        String other$recognitionRange = other.getRecognitionRange();
        if (this$recognitionRange == null ? other$recognitionRange != null : !this$recognitionRange.equals(other$recognitionRange)) {
            return false;
        }
        List<Integer> this$detectPage = this.getDetectPage();
        List<Integer> other$detectPage = other.getDetectPage();
        if (this$detectPage == null ? other$detectPage != null : !((Object)this$detectPage).equals(other$detectPage)) {
            return false;
        }
        String this$matchMethod = this.getMatchMethod();
        String other$matchMethod = other.getMatchMethod();
        return !(this$matchMethod == null ? other$matchMethod != null : !this$matchMethod.equals(other$matchMethod));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WebGlobalConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFlag() ? 79 : 97);
        result = result * 59 + this.getThresh();
        long $line_merge_coincidence_rate = Double.doubleToLongBits(this.getLine_merge_coincidence_rate());
        result = result * 59 + (int)($line_merge_coincidence_rate >>> 32 ^ $line_merge_coincidence_rate);
        result = result * 59 + this.getHorizontal_distance();
        result = result * 59 + (this.isDetect() ? 79 : 97);
        result = result * 59 + (this.isRemove() ? 79 : 97);
        long $sealDetectThresh = Double.doubleToLongBits(this.getSealDetectThresh());
        result = result * 59 + (int)($sealDetectThresh >>> 32 ^ $sealDetectThresh);
        long $sealExtendRate = Double.doubleToLongBits(this.getSealExtendRate());
        result = result * 59 + (int)($sealExtendRate >>> 32 ^ $sealExtendRate);
        long $sealIosThresh = Double.doubleToLongBits(this.getSealIosThresh());
        result = result * 59 + (int)($sealIosThresh >>> 32 ^ $sealIosThresh);
        long $sealMatchThresh = Double.doubleToLongBits(this.getSealMatchThresh());
        result = result * 59 + (int)($sealMatchThresh >>> 32 ^ $sealMatchThresh);
        result = result * 59 + (this.isSealMergeItems() ? 79 : 97);
        result = result * 59 + (this.isSignDetect() ? 79 : 97);
        long $detectThresh = Double.doubleToLongBits(this.getDetectThresh());
        result = result * 59 + (int)($detectThresh >>> 32 ^ $detectThresh);
        result = result * 59 + (this.isMergeItems() ? 79 : 97);
        long $matchThresh = Double.doubleToLongBits(this.getMatchThresh());
        result = result * 59 + (int)($matchThresh >>> 32 ^ $matchThresh);
        long $extendRate = Double.doubleToLongBits(this.getExtendRate());
        result = result * 59 + (int)($extendRate >>> 32 ^ $extendRate);
        long $iosThresh = Double.doubleToLongBits(this.getIosThresh());
        result = result * 59 + (int)($iosThresh >>> 32 ^ $iosThresh);
        result = result * 59 + (this.isContinuousPageNumber() ? 79 : 97);
        String $binary_type = this.getBinary_type();
        result = result * 59 + ($binary_type == null ? 43 : $binary_type.hashCode());
        String $seal_type = this.getSeal_type();
        result = result * 59 + ($seal_type == null ? 43 : $seal_type.hashCode());
        List<Integer> $sealDetectPage = this.getSealDetectPage();
        result = result * 59 + ($sealDetectPage == null ? 43 : ((Object)$sealDetectPage).hashCode());
        String $sealMatchMethod = this.getSealMatchMethod();
        result = result * 59 + ($sealMatchMethod == null ? 43 : $sealMatchMethod.hashCode());
        Object $pdf_num = this.getPdf_num();
        result = result * 59 + ($pdf_num == null ? 43 : $pdf_num.hashCode());
        String $recognitionRange = this.getRecognitionRange();
        result = result * 59 + ($recognitionRange == null ? 43 : $recognitionRange.hashCode());
        List<Integer> $detectPage = this.getDetectPage();
        result = result * 59 + ($detectPage == null ? 43 : ((Object)$detectPage).hashCode());
        String $matchMethod = this.getMatchMethod();
        result = result * 59 + ($matchMethod == null ? 43 : $matchMethod.hashCode());
        return result;
    }

    public String toString() {
        return "WebGlobalConfig(flag=" + this.isFlag() + ", thresh=" + this.getThresh() + ", binary_type=" + this.getBinary_type() + ", line_merge_coincidence_rate=" + this.getLine_merge_coincidence_rate() + ", horizontal_distance=" + this.getHorizontal_distance() + ", detect=" + this.isDetect() + ", remove=" + this.isRemove() + ", seal_type=" + this.getSeal_type() + ", sealDetectPage=" + this.getSealDetectPage() + ", sealDetectThresh=" + this.getSealDetectThresh() + ", sealMatchMethod=" + this.getSealMatchMethod() + ", sealExtendRate=" + this.getSealExtendRate() + ", sealIosThresh=" + this.getSealIosThresh() + ", sealMatchThresh=" + this.getSealMatchThresh() + ", sealMergeItems=" + this.isSealMergeItems() + ", pdf_num=" + this.getPdf_num() + ", recognitionRange=" + this.getRecognitionRange() + ", signDetect=" + this.isSignDetect() + ", detectPage=" + this.getDetectPage() + ", detectThresh=" + this.getDetectThresh() + ", matchMethod=" + this.getMatchMethod() + ", mergeItems=" + this.isMergeItems() + ", matchThresh=" + this.getMatchThresh() + ", extendRate=" + this.getExtendRate() + ", iosThresh=" + this.getIosThresh() + ", continuousPageNumber=" + this.isContinuousPageNumber() + ")";
    }
}

