/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.common.ocr.entity.config.global;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.idp.icpac.common.ocr.entity.config.global.BinaryConfig;
import com.jxdinfo.idp.icpac.common.ocr.entity.config.global.OcrConfig;
import com.jxdinfo.idp.icpac.common.ocr.entity.config.global.ProcessConfig;
import com.jxdinfo.idp.icpac.common.ocr.entity.config.global.SealConfig;
import com.jxdinfo.idp.icpac.common.ocr.entity.config.global.SignConfig;
import com.jxdinfo.idp.icpac.common.ocr.entity.config.global.WebGlobalConfig;
import com.jxdinfo.idp.icpac.common.ocr.entity.config.global.WriteDataConfig;

public class GlobalConfig {
    private ProcessConfig process;
    private OcrConfig ocr;

    public static String toGlobalStr(GlobalConfig globalConfig) {
        return JSON.toJSONString((Object)globalConfig);
    }

    public static GlobalConfig toGlobalConfig(String ocrGlobalStr) {
        return (GlobalConfig)JSON.parseObject((String)ocrGlobalStr, GlobalConfig.class);
    }

    public WebGlobalConfig toWebGlobalConfig() {
        WebGlobalConfig webGlobalConfig = new WebGlobalConfig();
        if (this.process != null) {
            WriteDataConfig writeData;
            SignConfig sign;
            BinaryConfig binary;
            webGlobalConfig.setContinuousPageNumber(this.process.isContinuous_page_number());
            webGlobalConfig.setPdf_num(this.process.getPdf_num());
            webGlobalConfig.setRecognitionRange(this.process.getRecognitionRange());
            SealConfig seal = this.process.getSeal();
            if (seal != null) {
                webGlobalConfig.setDetect(seal.isDetect());
                webGlobalConfig.setSeal_type(seal.getType());
                webGlobalConfig.setRemove(seal.isRemove());
                webGlobalConfig.setSealDetectPage(seal.getDetect_page());
                webGlobalConfig.setSealDetectThresh(seal.getDetect_thresh());
                webGlobalConfig.setSealMatchMethod(seal.getMatch_method());
                webGlobalConfig.setSealExtendRate(seal.getExtend_rate());
                webGlobalConfig.setSealIosThresh(seal.getIos_thresh());
                webGlobalConfig.setSealMergeItems(seal.isMerge_items());
                webGlobalConfig.setSealMatchThresh(seal.getMatch_thresh());
            }
            if ((binary = this.process.getBinary()) != null) {
                webGlobalConfig.setBinary_type(binary.getType());
                webGlobalConfig.setFlag(binary.isFlag());
                webGlobalConfig.setThresh(binary.getThresh());
            }
            if ((sign = this.process.getSign()) != null) {
                webGlobalConfig.setSignDetect(sign.isDetect());
                webGlobalConfig.setDetectPage(sign.getDetect_page());
                webGlobalConfig.setDetectThresh(sign.getDetect_thresh());
                webGlobalConfig.setMatchMethod(sign.getMatch_method());
                webGlobalConfig.setMergeItems(sign.isMerge_items());
                webGlobalConfig.setMatchThresh(sign.getMatch_thresh());
                webGlobalConfig.setExtendRate(sign.getExtend_rate());
                webGlobalConfig.setIosThresh(sign.getIos_thresh());
            }
            if ((writeData = this.process.getWriteData()) != null) {
                // empty if block
            }
        }
        if (this.ocr != null) {
            webGlobalConfig.setHorizontal_distance(this.ocr.getHorizontal_distance());
            webGlobalConfig.setLine_merge_coincidence_rate(this.ocr.getLine_merge_coincidence_rate());
        }
        return webGlobalConfig;
    }

    public ProcessConfig getProcess() {
        return this.process;
    }

    public OcrConfig getOcr() {
        return this.ocr;
    }

    public void setProcess(ProcessConfig process) {
        this.process = process;
    }

    public void setOcr(OcrConfig ocr) {
        this.ocr = ocr;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlobalConfig)) {
            return false;
        }
        GlobalConfig other = (GlobalConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ProcessConfig this$process = this.getProcess();
        ProcessConfig other$process = other.getProcess();
        if (this$process == null ? other$process != null : !((Object)this$process).equals(other$process)) {
            return false;
        }
        OcrConfig this$ocr = this.getOcr();
        OcrConfig other$ocr = other.getOcr();
        return !(this$ocr == null ? other$ocr != null : !((Object)this$ocr).equals(other$ocr));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GlobalConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProcessConfig $process = this.getProcess();
        result = result * 59 + ($process == null ? 43 : ((Object)$process).hashCode());
        OcrConfig $ocr = this.getOcr();
        result = result * 59 + ($ocr == null ? 43 : ((Object)$ocr).hashCode());
        return result;
    }

    public String toString() {
        return "GlobalConfig(process=" + this.getProcess() + ", ocr=" + this.getOcr() + ")";
    }
}

