/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.slice.entity;

import com.jxdinfo.idp.icpac.slice.entity.FileSlice;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

public class FileSliceCollection {
    private String id;
    private long startTime;
    private FileSlice[] fileSlices;
    private String filename;
    private int allBlockNum;
    private AtomicInteger competedBlockNum;
    private String projectId;
    private String kyFlag;

    public FileSliceCollection(String projectId, String id, int allBlockNum, String filename) {
        if (allBlockNum < 1) {
            throw new IllegalArgumentException("\u7ed9\u5b9a\u7684\u603b\u5757\u6570\u4e0d\u6b63\u786e\uff0c\u603b\u5feb\u6570\u4e3a\uff1a" + allBlockNum);
        }
        this.projectId = projectId;
        this.id = id;
        this.startTime = System.currentTimeMillis();
        this.filename = filename;
        this.competedBlockNum = new AtomicInteger(0);
        this.allBlockNum = allBlockNum;
        this.fileSlices = new FileSlice[allBlockNum];
        this.kyFlag = this.kyFlag;
    }

    public int addFileSlice(FileSlice fileSlice) {
        int oldBlockNum;
        boolean b;
        int seqBlockNum = fileSlice.getSeqBlockNum();
        this.fileSlices[seqBlockNum] = fileSlice;
        int newBlockNum = -1;
        while (!(b = this.competedBlockNum.compareAndSet(oldBlockNum = this.competedBlockNum.get(), newBlockNum = oldBlockNum + 1))) {
        }
        return newBlockNum;
    }

    public boolean isComplete(int block) {
        return block == this.allBlockNum;
    }

    public String getId() {
        return this.id;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public FileSlice[] getFileSlices() {
        return this.fileSlices;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getAllBlockNum() {
        return this.allBlockNum;
    }

    public AtomicInteger getCompetedBlockNum() {
        return this.competedBlockNum;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getKyFlag() {
        return this.kyFlag;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setFileSlices(FileSlice[] fileSlices) {
        this.fileSlices = fileSlices;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setAllBlockNum(int allBlockNum) {
        this.allBlockNum = allBlockNum;
    }

    public void setCompetedBlockNum(AtomicInteger competedBlockNum) {
        this.competedBlockNum = competedBlockNum;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public void setKyFlag(String kyFlag) {
        this.kyFlag = kyFlag;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileSliceCollection)) {
            return false;
        }
        FileSliceCollection other = (FileSliceCollection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStartTime() != other.getStartTime()) {
            return false;
        }
        if (this.getAllBlockNum() != other.getAllBlockNum()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getFileSlices(), other.getFileSlices())) {
            return false;
        }
        String this$filename = this.getFilename();
        String other$filename = other.getFilename();
        if (this$filename == null ? other$filename != null : !this$filename.equals(other$filename)) {
            return false;
        }
        AtomicInteger this$competedBlockNum = this.getCompetedBlockNum();
        AtomicInteger other$competedBlockNum = other.getCompetedBlockNum();
        if (this$competedBlockNum == null ? other$competedBlockNum != null : !this$competedBlockNum.equals(other$competedBlockNum)) {
            return false;
        }
        String this$projectId = this.getProjectId();
        String other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
            return false;
        }
        String this$kyFlag = this.getKyFlag();
        String other$kyFlag = other.getKyFlag();
        return !(this$kyFlag == null ? other$kyFlag != null : !this$kyFlag.equals(other$kyFlag));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileSliceCollection;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startTime = this.getStartTime();
        result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
        result = result * 59 + this.getAllBlockNum();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getFileSlices());
        String $filename = this.getFilename();
        result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
        AtomicInteger $competedBlockNum = this.getCompetedBlockNum();
        result = result * 59 + ($competedBlockNum == null ? 43 : $competedBlockNum.hashCode());
        String $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
        String $kyFlag = this.getKyFlag();
        result = result * 59 + ($kyFlag == null ? 43 : $kyFlag.hashCode());
        return result;
    }

    public String toString() {
        return "FileSliceCollection(id=" + this.getId() + ", startTime=" + this.getStartTime() + ", fileSlices=" + Arrays.deepToString(this.getFileSlices()) + ", filename=" + this.getFilename() + ", allBlockNum=" + this.getAllBlockNum() + ", competedBlockNum=" + this.getCompetedBlockNum() + ", projectId=" + this.getProjectId() + ", kyFlag=" + this.getKyFlag() + ")";
    }
}

