/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.slice;

import com.jxdinfo.idp.icpac.slice.entity.FileSlice;
import com.jxdinfo.idp.icpac.slice.entity.FileSliceCollection;
import com.jxdinfo.idp.icpac.slice.entity.PreparationFileInfo;
import com.jxdinfo.idp.icpac.slice.entity.UploadFileInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class FileSliceManager {
    private static final Logger log = LoggerFactory.getLogger(FileSliceManager.class);
    private static final long EXPIRE_TIME = 600000L;
    private Map<String, FileSliceCollection> collection = new ConcurrentHashMap<String, FileSliceCollection>();
    private final Lock readLock;
    private final Lock writeLock;

    public FileSliceManager() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addFileSlice(String id, FileSlice fileSlice) {
        this.readLock.lock();
        try {
            FileSliceCollection fileSliceCollection = this.collection.get(id);
            if (fileSliceCollection == null) {
                boolean bl = false;
                return bl;
            }
            int slice = fileSliceCollection.addFileSlice(fileSlice);
            boolean bl = fileSliceCollection.isComplete(slice);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean createFileSliceCollection(String projectId, String id, int allBlockNum, String filename) {
        FileSliceCollection sliceCollection = new FileSliceCollection(projectId, id, allBlockNum, filename);
        this.collection.put(id, sliceCollection);
        return true;
    }

    public UploadFileInfo getCompleteFileInfo(String id) throws IOException {
        FileSlice[] fileSlices;
        log.info("\u91cd\u7ec4\u6587\u4ef6\u5f00\u59cb");
        long startTime = System.currentTimeMillis();
        FileSliceCollection fileSliceCollection = this.collection.get(id);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (FileSlice fileSlice : fileSlices = fileSliceCollection.getFileSlices()) {
            byte[] fileBytes = fileSlice.getFileBytes();
            baos.write(fileBytes);
        }
        UploadFileInfo uploadFileInfo = new UploadFileInfo(id, baos.toByteArray(), fileSliceCollection.getFilename(), fileSliceCollection.getProjectId(), fileSliceCollection.getKyFlag());
        this.collection.remove(id);
        log.info("\u91cd\u7ec4\u6587\u4ef6\u5b8c\u6bd5\uff0c\u82b1\u8d39\u65f6\u95f4\u4e3a\uff1a{}", (Object)((System.currentTimeMillis() - startTime) / 1000L));
        return uploadFileInfo;
    }

    public boolean createFileSliceCollection(PreparationFileInfo preparationFileInfo) {
        FileSliceCollection sliceCollection = new FileSliceCollection(preparationFileInfo.getProjectId(), preparationFileInfo.getSliceId(), preparationFileInfo.getAllBlockNum(), preparationFileInfo.getFilename());
        this.collection.put(preparationFileInfo.getSliceId(), sliceCollection);
        return true;
    }

    @Scheduled(cron="0 0 */1 * * ?")
    public void clear() {
        log.info("\u5f00\u59cbclear \u4e0d\u6b63\u5f53\u64cd\u4f5c\u4ea7\u751f\u7684\u6570\u636e");
        long currentTime = System.currentTimeMillis();
        this.collection.entrySet().removeIf(k -> {
            FileSliceCollection fileSliceCollection = (FileSliceCollection)k.getValue();
            return currentTime - fileSliceCollection.getStartTime() >= 600000L;
        });
        log.info("\u7ed3\u675fclear");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(String fileSliceId) {
        this.writeLock.lock();
        try {
            FileSliceCollection fileSliceCollection = this.collection.get(fileSliceId);
            if (fileSliceCollection == null) {
                boolean bl = false;
                return bl;
            }
            this.collection.remove(fileSliceId);
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

