/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.multisimilaritycompare.utils.sentence;

import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.icpac.common.entity.FileBytesInfo;
import com.jxdinfo.idp.icpac.common.util.FileUtils;
import com.jxdinfo.idp.icpac.docexamine.entity.location.SentenceContent;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordChapterInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordParagraphInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.entity.word.WordStructureInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadAsSentencesUtil {
    private static final Logger log = LoggerFactory.getLogger(ReadAsSentencesUtil.class);
    private static final String[] SYMBOL_SPLIT = new String[]{"\\t", "\u3002", "\uff1f", "\\?", ";", "\uff1b", "\\n", "!", "\uff01"};

    public static List<SentenceContent> readSentences(FileBytesInfo docFileInfo, Integer simThresminSentenceLen) {
        try {
            Throwable throwable;
            ByteArrayInputStream in = new ByteArrayInputStream(docFileInfo.getFileBytes());
            ArrayList<String> paragraphs = new ArrayList<String>();
            if (docFileInfo.getFileName().endsWith(".docx")) {
                throwable = null;
                try (XWPFDocument xwpfDocument = new XWPFDocument((InputStream)in);){
                    List paras = xwpfDocument.getParagraphs();
                    for (XWPFParagraph para : paras) {
                        paragraphs.add(para.getText());
                    }
                }
                catch (Throwable paras) {
                    throwable = paras;
                    throw paras;
                }
            }
            if (docFileInfo.getFileName().endsWith(".doc") || docFileInfo.getFileName().endsWith(".wps")) {
                throwable = null;
                try (HWPFDocument doc = new HWPFDocument((InputStream)in);){
                    Range r = doc.getRange();
                    for (int i = 0; i < r.numParagraphs(); ++i) {
                        paragraphs.add(r.getParagraph(i).text());
                    }
                }
                catch (Throwable r) {
                    throwable = r;
                    throw r;
                }
            }
            ArrayList<SentenceContent> sentenceList = new ArrayList<SentenceContent>();
            int sentencesIndex = 0;
            for (int i = 0; i < paragraphs.size(); ++i) {
                String paragraph = (String)paragraphs.get(i);
                if (StringUtils.isEmpty((CharSequence)paragraph)) continue;
                String symbol = Arrays.stream(SYMBOL_SPLIT).collect(Collectors.joining("|"));
                String[] sentences = paragraph.split(symbol);
                for (int i1 = 0; i1 < sentences.length; ++i1) {
                    SentenceContent content = new SentenceContent();
                    String sentence = sentences[i1];
                    if (StringUtils.isEmpty((CharSequence)sentence) || sentence.replaceAll(" ", "").length() <= simThresminSentenceLen) continue;
                    content.setSentenceIndex(sentencesIndex);
                    ++sentencesIndex;
                    content.setSentenceStr(sentence);
                    content.setTextLength(sentence.length());
                    content.setParagraphIndex(i);
                    content.setTextIndex(paragraph.indexOf(sentence));
                    sentenceList.add(content);
                }
            }
            return sentenceList;
        }
        catch (BusinessException | IOException e) {
            log.error("\u6309\u53e5\u8bfb\u53d6\u6587\u7ae0\u5931\u8d25:", e);
            return Collections.emptyList();
        }
    }

    public static Map<Integer, SentenceContent> readSentencesForMap(FileBytesInfo docFileInfo, Integer simThresminSentenceLen) {
        List<SentenceContent> sentenceContents = ReadAsSentencesUtil.readSentences(docFileInfo, simThresminSentenceLen);
        return sentenceContents.stream().collect(Collectors.toMap(SentenceContent::getSentenceIndex, sentence -> sentence));
    }

    public static Map<String, SentenceContent> readSentencesForMap(WordStructureInfo wordInfo) {
        String symbol = Arrays.stream(SYMBOL_SPLIT).collect(Collectors.joining("|"));
        HashMap<String, SentenceContent> paraSentence = new HashMap<String, SentenceContent>();
        for (WordChapterInfo chapterInfo : wordInfo.getChapterInfos()) {
            String titleName = chapterInfo.getTitleName();
            int paraSentenceIndex = 0;
            List<WordParagraphInfo> pInfoList = chapterInfo.getPInfoList();
            if (CollectionUtils.isEmpty(pInfoList)) continue;
            for (WordParagraphInfo paragraphInfo : pInfoList) {
                String[] sentences;
                Integer paraIndex = paragraphInfo.getIndex();
                String text = paragraphInfo.getText();
                if (StringUtils.isEmpty((CharSequence)text)) continue;
                for (String sentence : sentences = text.split(symbol)) {
                    sentence = sentence.trim().replaceAll("\n", "");
                    if (!StringUtils.isNotEmpty((CharSequence)titleName)) continue;
                    SentenceContent content = new SentenceContent();
                    content.setSentenceIndex(paraSentenceIndex);
                    content.setSentenceStr(sentence);
                    content.setTextLength(sentence.length());
                    content.setParagraphIndex(paraIndex);
                    content.setTextIndex(text.indexOf(sentence));
                    paraSentence.put(titleName + paraSentenceIndex, content);
                    ++paraSentenceIndex;
                }
            }
        }
        int sentenceIndex = 0;
        for (WordParagraphInfo paragraphInfo : wordInfo.getPInfoList()) {
            String[] sentences;
            Integer paraIndex = paragraphInfo.getIndex();
            String text = paragraphInfo.getText();
            if (StringUtils.isEmpty((CharSequence)text)) continue;
            for (String sentence : sentences = text.split(symbol)) {
                if (StringUtils.isEmpty((CharSequence)(sentence = sentence.trim().replaceAll("\n", "")))) continue;
                SentenceContent content1 = new SentenceContent();
                content1.setSentenceIndex(sentenceIndex);
                content1.setSentenceStr(sentence);
                content1.setTextLength(sentence.length());
                content1.setParagraphIndex(paraIndex);
                content1.setTextIndex(text.indexOf(sentence));
                paraSentence.put("" + sentenceIndex, content1);
                ++sentenceIndex;
            }
        }
        return paraSentence;
    }

    public static Map<Integer, SentenceContent> readSentencesForMap(String fileId, Integer simThresminSentenceLen) {
        if (StringUtils.isEmpty((CharSequence)fileId)) {
            return new LinkedHashMap<Integer, SentenceContent>();
        }
        FileBytesInfo docFileInfo = new FileBytesInfo();
        try {
            docFileInfo = FileUtils.getBytesInfo(Long.parseLong(fileId));
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u6587\u6863id\u83b7\u53d6\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        return ReadAsSentencesUtil.readSentencesForMap(docFileInfo, simThresminSentenceLen);
    }

    public static List<String> readParagraphs(FileBytesInfo docFileInfo) {
        try {
            Throwable throwable;
            ByteArrayInputStream in = new ByteArrayInputStream(docFileInfo.getFileBytes());
            ArrayList<String> paragraphs = new ArrayList<String>();
            if (docFileInfo.getFileName().endsWith(".docx")) {
                throwable = null;
                try (XWPFDocument xwpfDocument = new XWPFDocument((InputStream)in);){
                    List paras = xwpfDocument.getParagraphs();
                    for (XWPFParagraph para : paras) {
                        paragraphs.add(para.getText());
                    }
                }
                catch (Throwable paras) {
                    throwable = paras;
                    throw paras;
                }
            }
            if (docFileInfo.getFileName().endsWith(".doc") || docFileInfo.getFileName().endsWith(".wps")) {
                throwable = null;
                try (HWPFDocument doc = new HWPFDocument((InputStream)in);){
                    Range r = doc.getRange();
                    for (int i = 0; i < r.numParagraphs(); ++i) {
                        paragraphs.add(r.getParagraph(i).text());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            return paragraphs;
        }
        catch (BusinessException | IOException e) {
            log.error("\u6309\u6bb5\u843d\u8bfb\u53d6\u6587\u7ae0\u5931\u8d25:", e);
            return new ArrayList<String>();
        }
    }
}

