/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.multisimilaritycompare.system.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.entity.dto.DuplicateCheckIgnoreLibraryDto;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.entity.po.DuplicateCheckIgnoreLibrary;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.mapper.DuplicateCheckIgnoreLibraryMapper;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.service.DuplicateCheckDocService;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.service.DuplicateCheckIgnoreLibraryService;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.service.DuplicateCheckSentenceService;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DuplicateCheckIgnoreLibraryServiceImpl
extends ServiceImpl<DuplicateCheckIgnoreLibraryMapper, DuplicateCheckIgnoreLibrary>
implements DuplicateCheckIgnoreLibraryService {
    @Resource
    private DuplicateCheckSentenceService sentenceService;
    @Resource
    private DuplicateCheckDocService docService;
    @Value(value="${cc.projectId}")
    private String kyProjectId;
    @Resource
    private DuplicateCheckIgnoreLibraryMapper mapper;

    @Override
    public void insert(DuplicateCheckIgnoreLibraryDto ignoreLibraryDto) {
        if (StringUtils.isEmpty((CharSequence)ignoreLibraryDto.getProjectId())) {
            ignoreLibraryDto.setProjectId(this.kyProjectId);
        }
        this.sentenceService.updateIgnoreSentence(ignoreLibraryDto.getSentenceId(), "0");
        this.docService.calcSimilarityAfterDelSentence(ignoreLibraryDto.getDocId());
    }

    @Override
    public void cancel(DuplicateCheckIgnoreLibraryDto ignoreLibraryDto) {
        if (StringUtils.isEmpty((CharSequence)ignoreLibraryDto.getProjectId())) {
            ignoreLibraryDto.setProjectId(this.kyProjectId);
        }
        this.sentenceService.updateIgnoreSentence(ignoreLibraryDto.getSentenceId(), "1");
        this.docService.calcSimilarityAfterDelSentence(ignoreLibraryDto.getDocId());
    }
}

