/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.multisimilaritycompare.system.service.handler.resulthandler;

import cn.hutool.core.util.IdUtil;
import com.jxdinfo.idp.common.util.DoubleUtils;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.core.entity.DuplicateCheckInfo;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.core.entity.DuplicateCheckResult;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.core.handler.DuplicateCheckResultHandler;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.core.rmi.resp.DuplicateCheckResponse;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.core.rmi.resp.DuplicateCheckSentenceResult;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.core.rmi.resp.DuplicateCheckSimilarResult;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.core.rmi.resp.DuplicateCheckSimilarityResult;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.entity.dto.DuplicateCheckDocDto;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.entity.dto.DuplicateCheckResultDto;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.entity.dto.DuplicateCheckSentenceDto;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.entity.dto.DuplicateCheckSimilarSentenceDto;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.service.DuplicateCheckDocService;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.utils.DuplicateCheckProgress;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResultHandler
implements DuplicateCheckResultHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultResultHandler.class);
    private final DuplicateCheckDocService docService;
    private final Map<String, Double> similarityMap;
    private final Map<String, DuplicateCheckResultDto> resultCollection;
    private final List<DuplicateCheckSentenceDto> sentenceList;
    private Double maxSimilarity;
    private BigDecimal docSimilarity;

    public DefaultResultHandler(DuplicateCheckDocService docService) {
        this.docService = docService;
        this.similarityMap = new HashMap<String, Double>();
        this.resultCollection = new HashMap<String, DuplicateCheckResultDto>();
        this.sentenceList = new ArrayList<DuplicateCheckSentenceDto>();
        this.maxSimilarity = 0.0;
        this.docSimilarity = BigDecimal.valueOf(0.0);
    }

    @Override
    public void handleResult(DuplicateCheckResult checkResult) throws Exception {
        String docId = null;
        log.info("\u5f00\u59cb\u67e5\u91cd\u7ed3\u679c\u89e3\u6790");
        DuplicateCheckInfo checkInfo = checkResult.getInfo();
        try {
            docId = checkInfo.getAttachment("docId", String.class);
            if (StringUtils.isEmpty((CharSequence)docId)) {
                log.error("\u5f53\u524d\u5f85\u67e5\u91cd\u7684\u6587\u6863id\u4e3a\u7a7a\u3002\u65e0\u6cd5\u5904\u7406\u7ed3\u679c");
                return;
            }
            Object executionResult = checkResult.getExecutionResult();
            if (!checkResult.isSuccess()) {
                log.error("\u67e5\u91cd\u7ed3\u679c\u6267\u884c\u51fa\u9519");
                this.updateDocInfo(docId, "2", checkInfo);
                return;
            }
            if (executionResult == null) {
                log.error("\u5f53\u524d\u7684\u67e5\u91cd\u7ed3\u679c\u4e3a\u7a7a\u3002\u3002\u3002\u3002\u3002\u3002");
                this.updateDocInfo(docId, "1", checkInfo);
                return;
            }
            if (!(executionResult instanceof DuplicateCheckResponse)) {
                this.updateDocInfo(docId, "2", checkInfo);
                throw new RuntimeException("\u5f53\u524d\u7ed9\u5b9a\u7684\u7ed3\u679c\u7c7b\u578b\uff1a" + executionResult.getClass() + ",\u65e0\u6cd5\u8fdb\u884c\u89e3\u6790");
            }
            DuplicateCheckDocDto docInfo = this.docService.detail(docId);
            if (docInfo == null) {
                return;
            }
            DuplicateCheckResponse rmiResponse = (DuplicateCheckResponse)executionResult;
            if (CollectionUtils.isEmpty(rmiResponse.getResult())) {
                log.error("\u67e5\u91cd\u670d\u52a1\u8fd4\u56de\u7684\u67e5\u91cd\u7ed3\u679c\u4e3a\u7a7a\u3002\u3002\u3002\u3002\u3002\u3002{}", rmiResponse.getResult());
                this.updateDocInfo(docId, "1", checkInfo);
                return;
            }
            List<DuplicateCheckSimilarityResult> simiResultList = rmiResponse.getSimilarity();
            if (CollectionUtils.isEmpty(simiResultList)) {
                this.updateDocInfo(docId, "1", checkInfo);
                log.warn("\u5f53\u524d\u67e5\u91cd\u7684\u76f8\u4f3c\u8bed\u53e5\u603b\u6761\u6570\u4e3a0");
                return;
            }
            this.handleResult(rmiResponse, checkResult.getInfo(), docInfo);
            docInfo = this.docService.detail(docId);
            if (docInfo != null) {
                this.updateDocInfo(docId, "1", checkInfo);
                docInfo.setSentenceList(this.sentenceList);
                docInfo.setResultList(new ArrayList<DuplicateCheckResultDto>(this.resultCollection.values()));
                docInfo.setCandidateSentenceNum(checkInfo.getCandidateSentenceNum());
                this.docService.insertCheckResult(docInfo);
            }
        }
        catch (Exception e) {
            this.updateDocInfo(docId, "2", checkInfo);
            throw e;
        }
        finally {
            log.info("\u6587\u6863\u89e3\u6790\u7ed3\u675f");
        }
    }

    private void handleResult(DuplicateCheckResponse rmiResponse, DuplicateCheckInfo info, DuplicateCheckDocDto docInfo) {
        Set<String> baseDocSet;
        String docId = docInfo.getId();
        String projectId = info.getAttachment("projectId", String.class);
        if (StringUtils.isEmpty((CharSequence)projectId)) {
            projectId = docInfo.getProjectId();
        }
        if ((baseDocSet = this.getBaseDocIdSet(info, docInfo, docId, projectId)) == null) {
            return;
        }
        this.similarityListForMap(rmiResponse.getSimilarity());
        log.info("\u5f53\u524d\u76f8\u4e0a\u4f20\u7684\u6587\u6863\u7684\u76f8\u4f3c\u8bed\u53e5\u603b\u6761\u6570\u4e3a\uff1a{}", (Object)rmiResponse.getResult().size());
        int size = rmiResponse.getResult().size();
        boolean count = true;
        for (DuplicateCheckSentenceResult sentenceResult : rmiResponse.getResult()) {
            Double sentenceSimilarity = 0.0;
            String documentId = sentenceResult.getDocument_id();
            if (!baseDocSet.contains(docId)) {
                throw new RuntimeException(String.format("\u67e5\u91cd\u670d\u52a1\u4e2d\u7ed9\u5b9a\u7684docId\uff1a%s\u6ca1\u6709\u4ece\u9879\u76ee\u5e93\uff1a%s\u4e2d\u627e\u5230", documentId, projectId));
            }
            DuplicateCheckProgress.setProgress(documentId, (int)Math.floor((double)count * 1.0 / (double)size * 70.0) + 20);
            DuplicateCheckSentenceDto sentenceDto = this.toSentence(sentenceResult);
            ArrayList<DuplicateCheckSimilarSentenceDto> similarSentenceList = new ArrayList<DuplicateCheckSimilarSentenceDto>();
            for (DuplicateCheckSimilarResult similarResult : sentenceResult.getSimilar_sentences()) {
                String similarDocId = similarResult.getDocument_id();
                DuplicateCheckResultDto resultDto = this.resultCollection.get(documentId + "_" + similarDocId);
                if (resultDto == null) {
                    String key = documentId + "_" + similarDocId;
                    Double similarity = this.similarityMap.get(key);
                    resultDto = new DuplicateCheckResultDto(IdUtil.simpleUUID(), documentId, similarDocId, similarity);
                    this.resultCollection.put(key, resultDto);
                }
                DuplicateCheckSimilarSentenceDto similarSentenceDto = this.toSimilarSentence(similarResult, resultDto, sentenceDto);
                similarSentenceList.add(similarSentenceDto);
                if (Double.compare(sentenceSimilarity, similarResult.getSimilarty()) >= 0) continue;
                sentenceSimilarity = similarResult.getSimilarty();
            }
            if (CollectionUtils.isNotEmpty(similarSentenceList)) {
                sentenceDto.addSimilarSentenceList(similarSentenceList);
                this.sentenceList.add(sentenceDto);
            }
            this.docSimilarity = this.docSimilarity.add(BigDecimal.valueOf(sentenceSimilarity));
            if (Double.compare(this.maxSimilarity, sentenceSimilarity) >= 0) continue;
            this.maxSimilarity = sentenceSimilarity;
        }
        this.docSimilarity = BigDecimal.valueOf(this.docSimilarity.doubleValue() / (double)info.getCandidateSentenceNum());
    }

    private Set<String> getBaseDocIdSet(DuplicateCheckInfo info, DuplicateCheckDocDto docInfo, String docId, String projectId) {
        HashSet<String> baseDocSet = new HashSet<String>();
        List choseIdList = info.getAttachment("choseIdList", List.class);
        if (CollectionUtils.isEmpty((Collection)choseIdList)) {
            List<DuplicateCheckDocDto> maybeSimiDocList = this.docService.listByProjectId(projectId);
            if (CollectionUtils.isEmpty(maybeSimiDocList)) {
                log.error("\u4ece\u8be5\u6587\u6863\u5e93\u4e2d\u6ca1\u6709\u67e5\u8be2\u5230\u57fa\u7840\u6587\u6863\uff0c\u65e0\u6cd5\u8fdb\u884c\u89e3\u6790");
                return null;
            }
            for (DuplicateCheckDocDto maybeSimiDoc : maybeSimiDocList) {
                boolean isAdd = Objects.equals(maybeSimiDoc.getId(), docId) || Objects.equals(maybeSimiDoc.getKyFlag(), "1") && !Objects.equals(maybeSimiDoc.getFilePath(), docInfo.getFilePath()) && !Objects.equals(maybeSimiDoc.getFileName(), docInfo.getFileName());
                if (!isAdd) continue;
                baseDocSet.add(maybeSimiDoc.getId());
            }
        } else {
            baseDocSet.addAll(choseIdList);
            baseDocSet.add(docId);
        }
        return baseDocSet;
    }

    private DuplicateCheckSimilarSentenceDto toSimilarSentence(DuplicateCheckSimilarResult similarResult, DuplicateCheckResultDto resultDto, DuplicateCheckSentenceDto sentenceDto) {
        Object index;
        String similarSentenceStr = similarResult.getSentence();
        DuplicateCheckSimilarSentenceDto similarSentence = new DuplicateCheckSimilarSentenceDto();
        similarSentence.setId(IdUtil.simpleUUID());
        similarSentence.setResultId(resultDto.getId());
        similarSentence.setSentenceId(sentenceDto.getId());
        similarSentence.setSentence(similarSentenceStr);
        similarSentence.setFileName((String)similarResult.getAttachment("fileName"));
        Object location = similarResult.getAttachment("location");
        Object belongChapter = similarResult.getAttachment("belongChapter");
        if (belongChapter != null) {
            similarSentence.setBelongChapter((String)belongChapter);
        }
        if (location != null) {
            similarSentence.setLocation(location.toString());
        }
        if ((index = similarResult.getAttachment("index")) != null) {
            similarSentence.setSentenceIndex(Integer.parseInt(index.toString()));
        }
        similarSentence.setSimilarity(similarResult.getSimilarty());
        return similarSentence;
    }

    private DuplicateCheckSentenceDto toSentence(DuplicateCheckSentenceResult sentenceResult) {
        Object belongChapter;
        Object index;
        String documentId = sentenceResult.getDocument_id();
        String sentenceStr = sentenceResult.getSentence();
        DuplicateCheckSentenceDto sentenceDto = new DuplicateCheckSentenceDto();
        sentenceDto.setId(IdUtil.simpleUUID());
        sentenceDto.setDocId(documentId);
        sentenceDto.setSentence(sentenceStr);
        Object location = sentenceResult.getAttachment("location");
        if (location != null) {
            sentenceDto.setLocation(location.toString());
        }
        if ((index = sentenceResult.getAttachment("index")) != null) {
            sentenceDto.setSentenceIndex(Integer.parseInt(index.toString()));
        }
        if ((belongChapter = sentenceResult.getAttachment("belongChapter")) != null) {
            sentenceDto.setBelongChapter((String)belongChapter);
        }
        sentenceDto.setIgnoreFlag("1");
        return sentenceDto;
    }

    private void similarityListForMap(List<DuplicateCheckSimilarityResult> similarityList) {
        if (CollectionUtils.isEmpty(similarityList)) {
            return;
        }
        for (DuplicateCheckSimilarityResult similarityResult : similarityList) {
            this.similarityMap.put(similarityResult.getUpload_document_id() + "_" + similarityResult.getDocument_id(), similarityResult.getSimilarity());
        }
    }

    private void updateDocInfo(String docId, String taskStatus, DuplicateCheckInfo checkInfo) {
        DuplicateCheckDocDto docDto = new DuplicateCheckDocDto();
        docDto.setId(docId);
        docDto.setKyFlag("");
        docDto.setTaskStatus(taskStatus);
        docDto.setEndTime(LocalDateTime.now());
        docDto.setCandidateSentenceNum(checkInfo.getCandidateSentenceNum());
        docDto.setMaxSimilarity(this.maxSimilarity);
        docDto.setDocSimilarity(DoubleUtils.towDecimal((Double)this.docSimilarity.doubleValue()));
        this.docService.updateById(docDto);
    }
}

